#include <Python.h>
#include "../pythonmod.h"

static PyObject *ErrorObject;

static PyObject *
LCConfigFile_open(LCConfigFileObject *self, PyObject *args)
{
	char *mode;
	if (!PyArg_ParseTuple(args,"s",&mode))
		return NULL;
	FILE *f = (FILE*) self->configfile->fopen(mode);
	if (f == NULL)
		return NULL;
	PyObject *ret = PyFile_FromFile(f,"none",mode,NULL);
	return ret;
}

static PyObject *
LCConfigFile_close(LCConfigFileObject *self, PyObject *args)
{
	PyObject *file;
	if (!PyArg_ParseTuple(args,"O",&file))
		return NULL;
	FILE_CFG *f = (FILE_CFG*) PyFile_AsFile(file);
	self->configfile->fclose(f);
	Py_INCREF(Py_None);
	return Py_None;
}

static struct PyMethodDef LCConfigFile_methods[] = {
	{"open", (binaryfunc) LCConfigFile_open, 1},
	{"close", (binaryfunc) LCConfigFile_close, 1},
	{NULL, NULL}
};

static void
LCConfigFile_dealloc(LCConfigFileObject *self)
{
	if (self->owner)
		delete self->configfile;
	PyMem_DEL(self);
}

static PyObject *
LCConfigFile_getattr(LCConfigFileObject *self, char *name)
{
	return Py_FindMethod(LCConfigFile_methods, (PyObject*) self, name);
}

PyTypeObject LCConfigFile_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCConfigFile",
	sizeof(LCConfigFileObject),
	0,
	(destructor) LCConfigFile_dealloc,
	(printfunc) 0,
	(getattrfunc) LCConfigFile_getattr,
	(setattrfunc) 0,
	(cmpfunc) 0,
	(reprfunc) 0,
	0,
	0,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCConfigFile_New(const char *path, HELP_FILE *help_file, int status,
		const char *owner, const char *group, int perm,
		const char *subsys)
{
	LCConfigFileObject *self;
	self = PyObject_NEW(LCConfigFileObject, &LCConfigFile_Type);
	if (self == NULL)
		return NULL;
	self->configfile = new CONFIG_FILE(path,*help_file,status,owner,group,
					   perm,subsys);
	self->owner = 1;
	return (PyObject*) self;
}

PyObject *
LCConfigFile_FromConfig(CONFIG_FILE *configfile)
{
	LCConfigFileObject *self;
	self = PyObject_NEW(LCConfigFileObject, &LCConfigFile_Type);
	if (self == NULL)
		return NULL;
	self->configfile = configfile;
	self->owner = 0;
	return (PyObject*) self;
}

PyObject *
LCConfigFile_FromConfigDealloc(CONFIG_FILE *configfile)
{
	LCConfigFileObject *self;
	self = PyObject_NEW(LCConfigFileObject, &LCConfigFile_Type);
	if (self == NULL)
		return NULL;
	self->configfile = configfile;
	self->owner = 1;
	return (PyObject*) self;
}

static PyObject *
lcconfigfile_LCConfigFile(PyObject *self, PyObject *args)
{
	const char *path;
	HELP_FILE *help_file = &help_nil;
	LCHelpFileObject *helpfile = NULL;
	int status = CONFIGF_NONE;
	const char *owner = "root";
	const char *group = "root";
	int perm = 0644;
	const char *subsys = "base";
	if (!PyArg_ParseTuple(args, "s|Oissis",&path,&helpfile,&status,
					       &owner,&group,&perm,&subsys))
		return NULL;
	if (helpfile != NULL)
		help_file = helpfile->helpfile;
	return LCConfigFile_New(path,help_file,status,owner,group,perm,subsys);
}

static struct PyMethodDef lcconfigfile_methods[] = {
	{"LCConfigFile", lcconfigfile_LCConfigFile, 1},
	{NULL,NULL}
};

extern "C" void
initlcconfigfile()
{
	PyObject *m, *d;
	m = Py_InitModule("lcconfigfile", lcconfigfile_methods);
	d = PyModule_GetDict(m);
	ErrorObject = Py_BuildValue("s", "dialog.error");
	PyDict_SetItemString(d, "error", ErrorObject);
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module lcconfigfile");
}
