/* this part deals with settings and defaults */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "pslaveconf.h"
#include "pslaveconf.m"
#include <stdlib.h>

#include "ps_tools.h"

// #include <private_msg.h>
// #include <dialog.h>







/*
conf.hostname	cs-1.someisp.com
conf.ipno	192.168.42.21
conf.lockdir	/var/lock
conf.rlogin	/usr/bin/port-slave/rlogin
conf.pppd	/usr/bin/port-slave/pppd
conf.telnet	/usr/bin/telnet
conf.ssh	/usr/bin/ssh
conf.locallogins	1
conf.syslog	logger.someisp.com
conf.facility	6
conf.filterdir	/usr/portslave/filters
conf.stripnames	0

all.debug	0
all.authtype    radius
all.authhost1	mainhost.someisp.com
all.accthost1	mainhost.someisp.com
all.radtimeout	3
#all.authhost2	backuphost.someisp.com
#all.accthost2	backuphost.someisp.com
#all.realm     >-@flintstone fred wilma barney zelda
#all.realm     >-@duck donald louie "" ""
#all.realm     <+U uucpauth uucpacct "" ""
all.secret	testing123
all.protocol	rlogin
all.host	shellhost.someisp.com
all.ipno	192.168.42.65+
all.netmask	255.255.255.255
all.mtu		1500
all.issue	\n\
        Cistron Internet Services \n\
         POP Alphen aan den Rijn \n\
     Welcome to terminal server %h port S%p\n
all.prompt	Cistron login:
all.term	vt100
all.sysutmp	1
all.syswtmp	0
all.porttype	0
all.speed	115200
all.initchat	"" \d\l\dATZ OK\r\n-ATZ-OK\r\n
all.waitfor	RING
all.answer	"" ATA CONNECT@
all.aa		0
all.checktime	60
all.checkchat	"" AT OK
all.flow	hard
all.dcd		1
all.autoppp	proxyarp modem asyncmap 0 %i: \
		noipx noccp login auth require-pap refuse-chap \
		mtu %t mru %t \
		ms-dns 192.168.1.1 ms-dns 192.168.1.2 \
		uselib /usr/lib/libpsr.so
all.pppopt	proxyarp modem asyncmap 0 %i:%j \
		noipx noccp mtu %t mru %t netmask %m \
		idle %I maxconnect %T \
		ms-dns 192.168.1.1 ms-dns 192.168.1.2
		uselib /usr/lib/libpsr.so
*/

struct {
    char tty[TYPICAL_FIELD_SIZE];

    char debug[TYPICAL_FIELD_SIZE];
    SSTRING debug_gui; /* needed by gui */
    char authtype[TYPICAL_FIELD_SIZE];
    SSTRING authtype_gui; /* needed by gui */
    char authhost1[TYPICAL_FIELD_SIZE];
    char accthost1[TYPICAL_FIELD_SIZE];
    char radtimeout[TYPICAL_FIELD_SIZE];
//    int  radtimeout_gui; /* needed by gui */
    char authhost2[TYPICAL_FIELD_SIZE];
    char accthost2[TYPICAL_FIELD_SIZE];
//    char realm[TYPICAL_FIELD_SIZE];
//    char realm[TYPICAL_FIELD_SIZE];
//    char realm[TYPICAL_FIELD_SIZE];
    char secret[TYPICAL_FIELD_SIZE];
    char protocol[TYPICAL_FIELD_SIZE];
    SSTRING protocol_gui; /* needed by gui */
    char host[TYPICAL_FIELD_SIZE];
    char ipno[TYPICAL_FIELD_SIZE];
    char netmask[TYPICAL_FIELD_SIZE];
    char mtu[TYPICAL_FIELD_SIZE];
//    int  mtu_gui; /* needed by gui */
    char issue[TYPICAL_FIELD_SIZE];
    char prompt[TYPICAL_FIELD_SIZE];
    char term[TYPICAL_FIELD_SIZE];
    SSTRING term_gui; /* needed by gui */
    char sysutmp[TYPICAL_FIELD_SIZE];
    SSTRING sysutmp_gui; /* needed by gui */
    char syswtmp[TYPICAL_FIELD_SIZE];
    SSTRING syswtmp_gui; /* needed by gui */
    char porttype[TYPICAL_FIELD_SIZE];
    SSTRING porttype_gui; /* needed by gui */
    char speed[TYPICAL_FIELD_SIZE];
    SSTRING speed_gui; /* needed by gui */
    char initchat[TYPICAL_FIELD_SIZE];
    char waitfor[TYPICAL_FIELD_SIZE];
    char answer[TYPICAL_FIELD_SIZE];
    char aa[TYPICAL_FIELD_SIZE];
    SSTRING aa_gui; /* needed by gui */
    char checktime[TYPICAL_FIELD_SIZE];
//    int  checktime_gui; /* needed by gui */
    char checkchat[TYPICAL_FIELD_SIZE];
    char flow[TYPICAL_FIELD_SIZE];
    SSTRING flow_gui; /* needed by gui */
    char dcd[TYPICAL_FIELD_SIZE];
    SSTRING dcd_gui; /* needed by gui */
    char autoppp[TYPICAL_FIELD_SIZE];
    char pppopt[TYPICAL_FIELD_SIZE];

    SSTRING realms;
} vport;

/* returns true if given_string has valid prefix with given_number */
int is_it_valid_prefix(const char *given_string, int given_number)
{
    char *zero_point;
    char temp_string[BIG_STRING_SIZE];
    char temp_string_2[BIG_STRING_SIZE];

    sprintf(temp_string_2, "s%d", given_number);

    strcpy(temp_string, given_string);
    if((zero_point=strchr(temp_string, '.'))){
        *zero_point=0;
        if(!strcmp(temp_string, temp_string_2)){
            return(1);
        }
    }
    return(0);
}

/* return true if some line was removed */
int remove_item_from_port(int given_port)
{
    VIEWITEMS   vitems_pslave;     /* used with linuxconf's parser */
    int         total_items;
    VIEWITEM *specific_item;

    // load variables with data from file
    vitems_pslave.read(cf_pslave);
    total_items=vitems_pslave.getnb();

    while(total_items--)
    {
        specific_item=vitems_pslave.getitem(total_items);
        if(is_it_valid_prefix(specific_item->line.get(), given_port)){
//            printf("removendo: [%s]\n", specific_item->line.get());
            vitems_pslave.remove(specific_item);
            vitems_pslave.write(cf_pslave, NULL);
            return(1);
        }
    }
    return(0);
}


/* returns true if this item was deleted (so list needs to be refreshed) */
int edit_port(int given_port_number)
{
    char title_for_window[TYPICAL_STRING_SIZE];

    MENU_STATUS my_button;
    DIALOG      dia_portset;
    int         my_selection=0;

    FIELD_COMBO *co_authtype;
    FIELD_COMBO *co_term;
    FIELD_LIST  *pop_porttype;
    FIELD_COMBO *co_speed;
    FIELD_LIST  *pop_flow;
    FIELD_LIST  *pop_sysutmp;
    FIELD_LIST  *pop_syswtmp;
    FIELD_LIST  *pop_debug;
    FIELD_LIST  *pop_aa;
    FIELD_LIST  *pop_dcd;
    FIELD_COMBO *co_protocol;

    char        strident[TYPICAL_STRING_SIZE]; /* may be s0, s1, s2.. */

    VIEWITEMS   vitems_pslave;     /* used with linuxconf's parser */

    // load variables with data from file
    vitems_pslave.read(cf_pslave);

    sprintf(strident, "s%d", given_port_number); /* ex.: 's31.' */

    loadmultilinefromfile2(strident, "realm", vport.realms, vitems_pslave);

    loadfromfile2(strident, "tty", vport.tty, vitems_pslave);
    loadfromfile2(strident, "debug", vport.debug, vitems_pslave);
    loadfromfile2(strident, "authtype", vport.authtype, vitems_pslave);
    loadfromfile2(strident, "authhost1", vport.authhost1, vitems_pslave);
    loadfromfile2(strident, "accthost1", vport.accthost1, vitems_pslave);
    loadfromfile2(strident, "radtimeout", vport.radtimeout, vitems_pslave);
    loadfromfile2(strident, "authhost2", vport.authhost2, vitems_pslave);
    loadfromfile2(strident, "accthost2", vport.accthost2, vitems_pslave);
//    loadfromfile2(strident, "realm", vport.realm, vitems_pslave);
    loadfromfile2(strident, "secret", vport.secret, vitems_pslave);
    loadfromfile2(strident, "protocol", vport.protocol, vitems_pslave);
    loadfromfile2(strident, "host", vport.host, vitems_pslave);
    loadfromfile2(strident, "ipno", vport.ipno, vitems_pslave);
    loadfromfile2(strident, "netmask", vport.netmask, vitems_pslave);
    loadfromfile2(strident, "mtu", vport.mtu, vitems_pslave);
    loadfromfile2(strident, "issue", vport.issue, vitems_pslave);
    loadfromfile2(strident, "prompt", vport.prompt, vitems_pslave);
    loadfromfile2(strident, "term", vport.term, vitems_pslave);
    loadfromfile2(strident, "sysutmp", vport.sysutmp, vitems_pslave);
    loadfromfile2(strident, "syswtmp", vport.syswtmp, vitems_pslave);
    loadfromfile2(strident, "porttype", vport.porttype, vitems_pslave);
    loadfromfile2(strident, "speed", vport.speed, vitems_pslave);
    loadfromfile2(strident, "initchat", vport.initchat, vitems_pslave);
    loadfromfile2(strident, "waitfor", vport.waitfor, vitems_pslave);
    loadfromfile2(strident, "answer", vport.answer, vitems_pslave);
    loadfromfile2(strident, "aa", vport.aa, vitems_pslave);
    loadfromfile2(strident, "checktime", vport.checktime, vitems_pslave);
    loadfromfile2(strident, "checkchat", vport.checkchat, vitems_pslave);
    loadfromfile2(strident, "flow", vport.flow, vitems_pslave);
    loadfromfile2(strident, "dcd", vport.dcd, vitems_pslave);
    loadfromfile2(strident, "autoppp", vport.autoppp, vitems_pslave);
    loadfromfile2(strident, "pppopt", vport.pppopt, vitems_pslave);

    /* transfer to gui variables */
    vport.debug_gui.setfrom(vport.debug);
    vport.authtype_gui.setfrom(vport.authtype);
    vport.term_gui.setfrom(vport.term);
    vport.sysutmp_gui.setfrom(vport.sysutmp);
    vport.syswtmp_gui.setfrom(vport.syswtmp);
    vport.porttype_gui.setfrom(vport.porttype);
    vport.speed_gui.setfrom(vport.speed);
    vport.aa_gui.setfrom(vport.aa);
    vport.flow_gui.setfrom(vport.flow);
    vport.dcd_gui.setfrom(vport.dcd);
    vport.protocol_gui.setfrom(vport.protocol);

    dia_portset.newf_str(MSG_U(F_COMMDEVICE, "Comm device (required):"), vport.tty, TYPICAL_FIELD_SIZE-1);


    dia_portset.newf_title(MSG_R(T_NETWORK), 1, "", MSG_R(T_NETWORK));

//    dia_portset.newf_chk("", vport.debug_gui, "Debug");
    pop_debug=dia_portset.newf_list(MSG_R(F_DEBUG), vport.debug_gui);
        pop_debug->addopt("", MSG_U(F_USEDEFAULT, "Use default"), "");
        pop_debug->addopt("1", MSG_U(F_ENABLED, "Enabled"), "");
        pop_debug->addopt("0", MSG_U(F_DISABLED, "Disabled"), "");

    co_authtype=dia_portset.newf_combo(MSG_R(F_AUTHTYPE), vport.authtype_gui);
        co_authtype->addopt("radius");
        co_authtype->addopt("none");
    dia_portset.newf_str(MSG_R(F_AUTHHOST1), vport.authhost1, TYPICAL_FIELD_SIZE-1);
    dia_portset.newf_str(MSG_R(F_AUTHHOST2), vport.authhost2, TYPICAL_FIELD_SIZE-1);
    dia_portset.newf_str(MSG_R(F_ACCTHOST1), vport.accthost1, TYPICAL_FIELD_SIZE-1);
    dia_portset.newf_str(MSG_R(F_ACCTHOST2), vport.accthost2, TYPICAL_FIELD_SIZE-1);
    dia_portset.newf_str(MSG_R(F_RADTIMEOUT), vport.radtimeout, TYPICAL_FIELD_SIZE-1);

    dia_portset.newf_textarea(MSG_R(F_REALMSDEF), vport.realms, 30, 4);

    dia_portset.newf_str(MSG_R(F_SECRET), vport.secret, TYPICAL_FIELD_SIZE-1);
//    dia_portset.newf_str("Protocol:", vport.protocol, TYPICAL_FIELD_SIZE-1);
    co_protocol=dia_portset.newf_combo(MSG_R(F_PROTOCOL), vport.protocol_gui);
        co_protocol->addopt("console");
        co_protocol->addopt("cslip");
        co_protocol->addopt("login");
        co_protocol->addopt("ppp");
        co_protocol->addopt("rlogin");
        co_protocol->addopt("slip");
        co_protocol->addopt("ssh");
        co_protocol->addopt("tcpclear");
        co_protocol->addopt("tcplogin");
        co_protocol->addopt("telnet");
    dia_portset.newf_str(MSG_R(F_HOST), vport.host, TYPICAL_FIELD_SIZE-1);
    dia_portset.newf_str(MSG_R(F_IPNUMBER), vport.ipno, TYPICAL_FIELD_SIZE-1);
    dia_portset.newf_str(MSG_R(F_NETMASK), vport.netmask, TYPICAL_FIELD_SIZE-1);
    dia_portset.newf_str(MSG_R(F_MTU), vport.mtu, TYPICAL_FIELD_SIZE-1);
    dia_portset.newf_title(MSG_R(T_COMM), 1, "", MSG_R(T_COMM));
    dia_portset.newf_str(MSG_R(F_ISSUE), vport.issue, TYPICAL_FIELD_SIZE-1);
    dia_portset.newf_str(MSG_R(F_PROMPT), vport.prompt, TYPICAL_FIELD_SIZE-1);
    co_term=dia_portset.newf_combo(MSG_R(F_TERMTYPE), vport.term_gui);
        co_term->addopt("vt100");
//        co_term->addopt("ANSI");
//        co_term->addopt("this list is incomplete -- add more you lazy programmer!");

    pop_sysutmp=dia_portset.newf_list(MSG_R(F_UPDATEUTMP), vport.sysutmp_gui);
        pop_sysutmp->addopt("", MSG_R(F_USEDEFAULT), "");
        pop_sysutmp->addopt("1", MSG_U(F_YES, "Yes"), "");
        pop_sysutmp->addopt("0", MSG_U(F_NO, "No"), "");
    pop_syswtmp=dia_portset.newf_list("Update wtmp:", vport.syswtmp_gui);
        pop_syswtmp->addopt("", MSG_R(F_USEDEFAULT), "");
        pop_syswtmp->addopt("1", MSG_R(F_YES), "");
        pop_syswtmp->addopt("0", MSG_R(F_NO), "");
//    dia_portset.newf_chk("", vport.sysutmp_gui, "Sysutmp");
//    dia_portset.newf_chk("", vport.syswtmp_gui, "Syswtmp");

    pop_porttype=dia_portset.newf_list(MSG_R(F_PORTTYPE), vport.porttype_gui);
        pop_porttype->addopt("", MSG_R(F_USEDEFAULT), "");
        pop_porttype->addopt("0", MSG_R(F_PT_ASYNC), "");
        pop_porttype->addopt("1", MSG_R(F_PT_SYNC), "");
        pop_porttype->addopt("2", MSG_R(F_PT_ISDN), "");
        pop_porttype->addopt("3", MSG_R(F_PT_ISDN120), "");
        pop_porttype->addopt("4", MSG_R(F_PT_ISDN110), "");
    co_speed=dia_portset.newf_combo(MSG_R(F_SPEED), vport.speed_gui);
        co_speed->addopt("300");
        co_speed->addopt("600");
        co_speed->addopt("1200");
        co_speed->addopt("2400");
        co_speed->addopt("4800");
        co_speed->addopt("9600");
        co_speed->addopt("19200");
        co_speed->addopt("38400");
        co_speed->addopt("57600");
        co_speed->addopt("115200");

    dia_portset.newf_str(MSG_R(F_INITCHAT), vport.initchat, TYPICAL_FIELD_SIZE-1);
    dia_portset.newf_str(MSG_R(F_WAITFOR), vport.waitfor, TYPICAL_FIELD_SIZE-1);
    dia_portset.newf_str(MSG_R(F_ANSWER), vport.answer, TYPICAL_FIELD_SIZE-1);

//    dia_portset.newf_chk("", vport.aa_gui, "Auto answer");
    pop_aa=dia_portset.newf_list(MSG_R(F_AUTOANSWER), vport.aa_gui);
        pop_aa->addopt("", MSG_R(F_USEDEFAULT), "");
        pop_aa->addopt("1", MSG_R(F_ENABLED), "");
        pop_aa->addopt("0", MSG_R(F_DISABLED), "");

    dia_portset.newf_str(MSG_R(F_CHECKTIME), vport.checktime, TYPICAL_FIELD_SIZE-1);
    dia_portset.newf_str(MSG_R(F_CHECKCHAT), vport.checkchat, TYPICAL_FIELD_SIZE-1);
    pop_flow=dia_portset.newf_list(MSG_R(F_FLOWCONTROL), vport.flow_gui);
        pop_flow->addopt("", MSG_R(F_USEDEFAULT), "");
        pop_flow->addopt("hard", MSG_R(F_FC_HARD), "");
        pop_flow->addopt("soft", MSG_R(F_FC_SOFT), "");
        pop_flow->addopt("none", MSG_R(F_FC_NONE), "");

//    dia_portset.newf_chk("", vport.dcd_gui, "Use DCD line");
    pop_dcd=dia_portset.newf_list(MSG_R(F_USEDCD), vport.dcd_gui);
        pop_dcd->addopt("", MSG_R(F_USEDEFAULT), "");
        pop_dcd->addopt("1", MSG_R(F_YES), "");
        pop_dcd->addopt("0", MSG_R(F_NO), "");

    dia_portset.newf_str(MSG_R(F_AUTOPPP), vport.autoppp, TYPICAL_FIELD_SIZE-1);
    dia_portset.newf_str(MSG_R(F_PPPOPT), vport.pppopt, TYPICAL_FIELD_SIZE-1);

    //////
/*    char debug_gui; // needed by gui
    SSTRING authtype_gui; // needed by gui
    char authhost1[TYPICAL_FIELD_SIZE];
    char accthost1[TYPICAL_FIELD_SIZE];
    int  radtimeout_gui; // needed by gui
    char authhost2[TYPICAL_FIELD_SIZE];
    char accthost2[TYPICAL_FIELD_SIZE];

    char realm[TYPICAL_FIELD_SIZE];
//    char realm[TYPICAL_FIELD_SIZE];
//    char realm[TYPICAL_FIELD_SIZE];
    char secret[TYPICAL_FIELD_SIZE];
    char protocol[TYPICAL_FIELD_SIZE];
    char host[TYPICAL_FIELD_SIZE];
    char ipno[TYPICAL_FIELD_SIZE];
    char netmask[TYPICAL_FIELD_SIZE];
    int  mtu_gui; // needed by gui
    char issue[TYPICAL_FIELD_SIZE];
    char prompt[TYPICAL_FIELD_SIZE];
    SSTRING term_gui; // needed by gui
    char sysutmp_gui; // needed by gui
    char syswtmp_gui; // needed by gui
    SSTRING porttype_gui; // needed by gui
    SSTRING speed_gui; // needed by gui
    char initchat[TYPICAL_FIELD_SIZE];
    char waitfor[TYPICAL_FIELD_SIZE];
    char answer[TYPICAL_FIELD_SIZE];
    char aa_gui; // needed by gui
    int  checktime_gui; // needed by gui
    char checkchat[TYPICAL_FIELD_SIZE];
    SSTRING flow_gui; // needed by gui
    char dcd_gui; // needed by gui
    char autoppp[TYPICAL_FIELD_SIZE];
    char pppopt[TYPICAL_FIELD_SIZE];
  */



    sprintf(title_for_window, MSG_U(T_PORTSETTINGS, "Settings for port number %d"), given_port_number);
    my_button=dia_portset.editmenu(title_for_window, MSG_U(I_PORTSETTINGS, "Empty fields means that the\nvalue defined as default\nwill be used instead.\nPut \"\" if you want to define\nthe field as \"empty\"."), my_portset_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL);


    /* transfer from gui variables */

//    char2string(vport.debug_gui, vport.debug);
    strcpy(vport.debug, vport.debug_gui.get());
    strcpy(vport.authtype, vport.authtype_gui.get());
    strcpy(vport.term, vport.term_gui.get());
//    char2string(vport.sysutmp_gui, vport.sysutmp);
    strcpy(vport.sysutmp, vport.sysutmp_gui.get());
//    char2string(vport.syswtmp_gui, vport.syswtmp);
    strcpy(vport.syswtmp, vport.syswtmp_gui.get());

    strcpy(vport.porttype, vport.porttype_gui.get());
    strcpy(vport.speed, vport.speed_gui.get());
//    char2string(vport.aa_gui, vport.aa);
    strcpy(vport.aa, vport.aa_gui.get());
    strcpy(vport.flow, vport.flow_gui.get());
//    char2string(vport.dcd_gui, vport.dcd);
    strcpy(vport.dcd, vport.dcd_gui.get());
    strcpy(vport.protocol, vport.protocol_gui.get());


    switch(my_button){
    case MENU_ACCEPT:

        /* save to file.. */

        updatemultilinetofile2(strident, "realm", vport.realms, vitems_pslave);

        writetofile2(strident, "tty", vport.tty, vitems_pslave);
        writetofile2(strident, "debug", vport.debug, vitems_pslave);
        writetofile2(strident, "authtype", vport.authtype, vitems_pslave);
        writetofile2(strident, "authhost1", vport.authhost1, vitems_pslave);
        writetofile2(strident, "accthost1", vport.accthost1, vitems_pslave);
        writetofile2(strident, "radtimeout", vport.radtimeout, vitems_pslave);
        writetofile2(strident, "authhost2", vport.authhost2, vitems_pslave);
        writetofile2(strident, "accthost2", vport.accthost2, vitems_pslave);
//        writetofile2(strident, "realm", vport.realm, vitems_pslave);
        writetofile2(strident, "secret", vport.secret, vitems_pslave);
        writetofile2(strident, "protocol", vport.protocol, vitems_pslave);
        writetofile2(strident, "host", vport.host, vitems_pslave);
        writetofile2(strident, "ipno", vport.ipno, vitems_pslave);
        writetofile2(strident, "netmask", vport.netmask, vitems_pslave);
        writetofile2(strident, "mtu", vport.mtu, vitems_pslave);
        writetofile2(strident, "issue", vport.issue, vitems_pslave);
        writetofile2(strident, "prompt", vport.prompt, vitems_pslave);
        writetofile2(strident, "term", vport.term, vitems_pslave);
        writetofile2(strident, "sysutmp", vport.sysutmp, vitems_pslave);
        writetofile2(strident, "syswtmp", vport.syswtmp, vitems_pslave);
        writetofile2(strident, "porttype", vport.porttype, vitems_pslave);
        writetofile2(strident, "speed", vport.speed, vitems_pslave);
        writetofile2(strident, "initchat", vport.initchat, vitems_pslave);
        writetofile2(strident, "waitfor", vport.waitfor, vitems_pslave);
        writetofile2(strident, "answer", vport.answer, vitems_pslave);
        writetofile2(strident, "aa", vport.aa, vitems_pslave);
        writetofile2(strident, "checktime", vport.checktime, vitems_pslave);
        writetofile2(strident, "checkchat", vport.checkchat, vitems_pslave);
        writetofile2(strident, "flow", vport.flow, vitems_pslave);
        writetofile2(strident, "dcd", vport.dcd, vitems_pslave);
        writetofile2(strident, "autoppp", vport.autoppp, vitems_pslave);
        writetofile2(strident, "pppopt", vport.pppopt, vitems_pslave);

        vitems_pslave.write(cf_pslave, NULL);
        break;

    case MENU_DEL:
        {
            if(confirm_yesno_window(MSG_U(T_REMOVINGPORT, "Removing port..."), MSG_U(Q_REMOVINGPORT, "Sure you want to remove this port\nfrom portslave definitions?"))){
                while(remove_item_from_port(given_port_number));
                return(1);
            }
        }
        break;

    default:
        break;

    }
    return(0);
}

int *return_ports_list(void)
{
    VIEWITEMS   vitems_pslave;     /* used with linuxconf's parser */
    int         total_items;
    int        *int_array;

    // load variables with data from file
    vitems_pslave.read(cf_pslave);

    total_items=vitems_pslave.getnb();


    if((int_array=(int*)malloc(sizeof(int)*(total_items+1))))
    {
        VIEWITEM *specific_item;
        int   item_counter;
        int   port_counter;
        int   this_port_is_defined;

        *int_array=0;


        port_counter=0;
        while(port_counter<64){
            item_counter=total_items;
            this_port_is_defined=0;
            while(item_counter--)
            {
                specific_item=vitems_pslave.getitem(item_counter);
                if(is_it_valid_prefix(specific_item->line.get(), port_counter)){
                    this_port_is_defined=1;
                }
            }
            if(this_port_is_defined){
                (*int_array)++;
                int_array[*int_array]=port_counter;
            }

            port_counter++;
        }
    }
    return(int_array);
}

void manage_ports_settings(void)
{
    /* here the scroll list with all available ports should be displayed */


    int *integer_array;

    VIEWITEMS   vitems_pslave;     /* used with linuxconf's parser */

    DIALOG_RECORDS dia_portslist;
    int my_selection=0;
    MENU_STATUS my_button;
    int redraw_this_window=1;

    // load variables with data from file
    vitems_pslave.read(cf_pslave);

    while(1){
    if((integer_array=return_ports_list())){

        char string_former[TYPICAL_STRING_SIZE];
        int  my_counter;

        if(redraw_this_window){
            dia_portslist.remove_all();
            dia_portslist.newf_head("", MSG_U(X_LISTOFPORTS, "list of configured ports"));

            my_counter=0;
            while(my_counter<*integer_array){
                sprintf(string_former, "s%d", integer_array[my_counter+1]);
                dia_portslist.new_menuitem(string_former, "");
                my_counter++;
            }
            redraw_this_window=0;
        }

        my_button=dia_portslist.editmenu(MSG_U(T_PORTSLIST, "Ports' listing"), MSG_U(I_PORTSLIST, "Here you may select the port you want\nto change its characteristics."), help_nil, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            redraw_this_window=1;
            {
                int port_counter=0;
                int this_port_is_vacant=-1;
                char write_this_variable[TYPICAL_STRING_SIZE];

                while((port_counter<64)&&(this_port_is_vacant==-1)){
                    if(integer_array[port_counter+1]!=port_counter){
                        this_port_is_vacant=port_counter;
                    }
                    port_counter++;
                }
                if(this_port_is_vacant!=-1){
                    sprintf(write_this_variable, "s%d.tty", this_port_is_vacant);
                    writetofile(write_this_variable, MSG_U(X_PLEASEDEFINEVALUE, "please_define_a_value"), vitems_pslave);
                    vitems_pslave.write(cf_pslave, NULL);
                    edit_port(this_port_is_vacant);
                } else {
                    informational_window(MSG_U(T_MAXPORTSLIMIT, "Maximum ports' limit reached"), MSG_U(N_MAXPORTSLIMIT, "No more ports may be added.\nThe only way for adding one is\nto delete an older one."));
                }
            }
            break;
        default:
            redraw_this_window=edit_port(integer_array[my_selection+1]);
            break;
        }

        free(integer_array);
    }
    }
}


