/* this manages the .config file (present in spool directory
   of printer is SMB of NCP */

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>

#include "deez_parser.h"
#include "printer_common_data.h"
#include "printer_cfile.h"
#include "printer_smbncp-specific.h"

struct t_dc_var dc_var;

/* removes the ' from string, if present */
void clean_apost_from_string(char *given_string)
{
    char *zero_it;
    char temp_buff[TYPICAL_STRING_SIZE];

    if((*given_string!='\'')||(!*given_string))
        return;


    zero_it=given_string+strlen(given_string)-1;
    *zero_it=0;

    strcpy(temp_buff, given_string+1);
    strcpy(given_string, temp_buff);
}

/* returns 0 if ok */
int save_dotconfig_data(char *given_filename)
{
    FILE *dotconfigfile;

    if((dotconfigfile=fopen(given_filename, "w"))){

	if(dc_var.printerip[0] != '\0' || dc_var.port[0] != '\0'){
            fprintf(dotconfigfile, "printer_ip=%s\n", dc_var.printerip);
            fprintf(dotconfigfile, "port=%s\n", dc_var.port);
	} else
        if(dc_var.share[0]||dc_var.hostip[0]||dc_var.workgroup[0]){
            /* smb */
            fprintf(dotconfigfile, "share=\'\\\\%s\\%s\'\n", dc_var.hostname, dc_var.printername);
            fprintf(dotconfigfile, "hostip=%s\n", dc_var.hostip);
            fprintf(dotconfigfile, "user=\'%s\'\n", dc_var.user);
            fprintf(dotconfigfile, "password=\'%s\'\n", dc_var.password);
            fprintf(dotconfigfile, "workgroup=\'%s\'\n", dc_var.workgroup);
        } else {
            /* ncp */
            fprintf(dotconfigfile, "server=%s\n", dc_var.server);
            fprintf(dotconfigfile, "queue=%s\n", dc_var.queue);
            fprintf(dotconfigfile, "user=%s\n", dc_var.user);
            fprintf(dotconfigfile, "password=%s\n", dc_var.password);
        }

        fclose(dotconfigfile);
        /* if the lprng crap is installed.. */
        if(kind_of_lpr_system_installed==LPRTYPE_LPRNG){
            change_owner_and_group(given_filename, "daemon", "daemon");
            chmod(given_filename, 384); /* -rw------- */
        }
        return(0);
    }
    return(1);
}

/* returns 0 if successfull */
int load_dotconfig_data(char *given_filename)
{
    int its_ok=0;
    char *my_buff=NULL;
    int  myfilesize;
    FILE *dotconfigfile;

    if((dotconfigfile=fopen(given_filename, "r"))){
        fseek(dotconfigfile, 0, SEEK_END);
        myfilesize=ftell(dotconfigfile);
        fseek(dotconfigfile, 0, SEEK_SET);

        if((my_buff=(char *)malloc(myfilesize+1))){
            if(fread(my_buff, myfilesize, 1, dotconfigfile)){
                *(my_buff+myfilesize)=0;
                its_ok=1;
            }
        }
        fclose(dotconfigfile);
    }

    if(its_ok){
        dc_var.share[0]=0;
        dc_var.hostip[0]=0;
        dc_var.workgroup[0]=0;
        dc_var.server[0]=0;
        dc_var.queue[0]=0;
        dc_var.user[0]=0;
        dc_var.password[0]=0;
        dc_var.hostname[0]=0;
        dc_var.printername[0]=0;
        dc_var.printerip[0]=0;
        dc_var.port[0]=0;

        parse_string_data(my_buff, "share=", "\n", dc_var.share);
        parse_string_data(my_buff, "hostip=", "\n", dc_var.hostip);
        parse_string_data(my_buff, "workgroup=", "\n", dc_var.workgroup);
        parse_string_data(my_buff, "server=", "\n", dc_var.server);
        parse_string_data(my_buff, "queue=", "\n", dc_var.queue);
        parse_string_data(my_buff, "user=", "\n", dc_var.user);
        parse_string_data(my_buff, "password=", "\n", dc_var.password);
        parse_string_data(my_buff, "printer_ip=", "\n", dc_var.printerip);
        parse_string_data(my_buff, "port=", "\n", dc_var.port);

        clean_apost_from_string(dc_var.share);
        clean_apost_from_string(dc_var.hostip);
        clean_apost_from_string(dc_var.user);
        clean_apost_from_string(dc_var.password);
        clean_apost_from_string(dc_var.workgroup);
        clean_apost_from_string(dc_var.printerip);
        clean_apost_from_string(dc_var.port);

        /* now extracts the data inside */
        if(dc_var.share[0]){
            char *where_it_is;

            if(strlen(dc_var.share)>2){
                strcpy(dc_var.hostname, &dc_var.share[0]+2);
                if((where_it_is=strchr(dc_var.hostname, '\\')))
                {
                    *where_it_is=0;
                    strcpy(dc_var.printername, ++where_it_is);
                }
            }

        }

        free(my_buff);
        my_buff=NULL;

        return(0);
    }

    if(my_buff)
        free(my_buff);
    return(1);
}


