/* deez parser */
/* these are generic parsing routines (used in several parts of printer module) */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "printer_common_data.h"

/* example for usage: */
/* copy_specific_block(lixo, "teste", 0, lixo2); */
/* 0 - the first block, returns null if block doesn't exist */
/* allocate for output_string at least the same size as full_text */
/* if !*particle_to_trap, each line (ended by LF) is considered a block */
int copy_specific_block(char *full_text, char *particle_to_trap, int block_number, char *output_string)
{
    char *theplace,
         *whereitends,
         *my_buff;
    int my_counter;

    *output_string=0;

//    strcpy(output_string, full_text);

    if((my_buff=(char *)malloc(strlen(full_text)+10))){
        char *zero_marker,
             *begn_marker=NULL,
             *read_marker,
             *write_marker;

        /* removes:
         #-commented lines
         empty lines
         ..and join slash-LF-ended lines */
        {
            char my_data;

            read_marker=full_text;
            write_marker=my_buff;
//            write_marker=output_string;

            my_data=*read_marker++;
            while((my_data)&&(read_marker)){
                /* my_data is always the first byte of some line, and it's always > 0 */
                switch(my_data){
                case '#':
                    if((read_marker=strchr(read_marker, '\n'))){
                        read_marker++;
                        my_data=*read_marker++;
                    }
                    break;
                case ' ':
                    while(*read_marker==' ')
                        read_marker++;
                    my_data=*read_marker++;
                    break;
                case '\n':
                    my_data=*read_marker++;
                    break;
                default:
                    while((my_data!='\n')&&my_data){
                        *write_marker++=my_data;
                        my_data=*read_marker++;
                    }

                    /* erases spaces to LF */
                    write_marker--; // last char
                    while(*write_marker==' '){
                        write_marker--;
                    }
                    if(*write_marker!='\\'){
                        write_marker++;
                        *write_marker++='\n';
                    }
                    my_data=*read_marker++;
                }
            }
            *write_marker=0;
        }

        //        printf("----------------------\n%s\n----------------------\n", my_buff);

        /* now identifies the blocks */
//        strcpy(my_buff, output_string);
        if (*particle_to_trap){
            *output_string=0;

            my_counter=block_number+1;
            theplace=my_buff;
            theplace--;

            while(my_counter--)
                if(theplace)
                    theplace=strstr(++theplace, particle_to_trap);
            if(!theplace){
                *output_string=0;
                free(my_buff);
                return(0);
            }
            sprintf(output_string, "%s", theplace);
            if((whereitends=strstr((output_string+1), particle_to_trap)))
                *whereitends=0;
        } else {
            *output_string=0;
            zero_marker=my_buff;
            my_counter=block_number+1;

            while(my_counter--){
                if(zero_marker){
                    begn_marker=zero_marker;
                    if((zero_marker=strchr(zero_marker, '\n'))){
                        *zero_marker=0;
                        zero_marker++;
                    }
                }
            }
            if(zero_marker&&begn_marker) {
                strcpy(output_string, begn_marker);
            } else {
                free(my_buff);
                return(0);
            }
        }
        free(my_buff);
    }
    return(1);
}


/* example for usage:   */
/* parse_string_data(":af=/var/spool/lpd/lp1/acct::lp=/dev/null:","af=", ":", lixo); */
/* output_string must have at least the same size as given_string */
/* returns the first byte after the string or NULL, if string not found */
char *parse_string_data(char *given_string, char *particle_to_trap, char *stringend_markers_given, char *output_string)
{
    char *theplace,
         *zero_this;
    char stringend_markers[TYPICAL_STRING_SIZE];

    #define extra_for_stringkey 10

    sprintf(stringend_markers, "%s", stringend_markers_given);

    *output_string=0;
    zero_this=NULL;

    if((theplace=strstr(given_string, particle_to_trap))) {
        theplace+=strlen(particle_to_trap);

        if((zero_this=strstr(theplace, stringend_markers))){
            char old_value;

            old_value=*zero_this;
            *zero_this=0;
            strcpy(output_string, theplace);
            *zero_this=old_value;
        } else {
            strcpy(output_string, theplace);
        }
    } else {
        return(NULL);
    }

    if((theplace)&&(zero_this)){
        return(zero_this+1);
    } else {
        return(NULL);
    }
}


/* example for usage:   */
/* parse_integer_data(":af=/var/spool/lpd/lp1/acct::lp=/dev/null:","lp", &my_integer); */
/* returns true if ok, otherwise false */
/* use output_integer=NULL if you just want to know about particle existence (returns TRUE if present) */
int parse_integer_data(char *given_string, char *particle_to_trap, int *output_integer)
{
    char *theplace,
         *stringkey;

    #define extra_for_stringkey 10

    if(output_integer)
        *output_integer=0;

    if((theplace=strstr(given_string, particle_to_trap))) {
        if ((stringkey=(char *)malloc(strlen(particle_to_trap)+extra_for_stringkey+10))){
            sprintf(stringkey, "%s%%d", particle_to_trap);
            if(output_integer)
                sscanf(theplace, stringkey, output_integer);
            free(stringkey);
        }
        return(1);
    }
    return(0);
}

