// vim: nowrap

#include "postfixconf.h"
#include "postfixconf.m"

/*
DESCRIPTION: This DIALOG contains settings of Postfix configuration parameters that control the SMTP server program 
RETURN: 0 - case the user accept the changes
        1 - case the user cancel the changes
*/
PUBLIC int MODULE_postfixconf::smtpdserverprgm_edit(DATAMAIN &data){
	int ret = 0;
	int nof = 0;
	DIALOG dia;
	SSTRING *st;
	
	// - - - Miscellaneous - - -
	dia.newf_title (MSG_U(T_MISCELLANEOUS,"Miscellaneous"),1,"",MSG_R(T_MISCELLANEOUS));

	// disable_vrfy_command
	st = data.getvarvariable(V_DISABLE_VRFY_COMMAND);
	char var_disvrfycmd = getvalue_yesno (st);
	const char *opt_disvrfycmd[] = {MSG_R(X_YES),MSG_R(X_NO),NULL};
	dia.newf_chkm (MSG_U(F_DISVERCOMM,"Disable verify command"),var_disvrfycmd,opt_disvrfycmd);

	// smtpd_banner
	st = data.getvarvariable(V_SMTPD_BANNER);
	dia.newf_str(MSG_U(F_SMTPDBANNER,"Smtpd banner"),*st);

	// smtpd_recipient_limit
	st = data.getvarvariable(V_SMTPD_RECIPIENT_LIMIT);
	int val_smtpdreclim = st->getval();
	dia.newf_num (MSG_U(F_SMTPDRECLIMIT,"Smtpd recipient limit"), val_smtpdreclim);

	// smtpd_timeout
	st = data.getvarvariable(V_SMTPD_TIMEOUT);
	int val_smtpdtout = st->getval();
	dia.newf_num (MSG_U(F_SMTPDTOUT,"Smtpd timeout"), val_smtpdtout);
	
	// - - - Tarpit Controls - - -
	dia.newf_title (MSG_U(T_TARPITCTRL,"Tarpit Controls"),1,"",MSG_R(T_TARPITCTRL));

	// smtpd_error_sleep_time
	st = data.getvarvariable(V_SMTPD_ERROR_SLEEP_TIME);
	int val_smtpderrslptime = st->getval();
	dia.newf_num (MSG_U(F_SMTPDERRSLEEPTIME,"Smtpd error sleep time"), val_smtpderrslptime);
	
	// smtpd_soft_error_limit
	st = data.getvarvariable(V_SMTPD_SOFT_ERROR_LIMIT);
	int val_smtpdsfterrlim = st->getval();
	dia.newf_num (MSG_U(F_SMTPDSOFTERRLIMIT,"Smtpd soft error limit"), val_smtpdsfterrlim);

	// smtpd_hard_error_limit
	st = data.getvarvariable(V_SMTPD_HARD_ERROR_LIMIT);
	int val_smtpdhrderrlim = st->getval();
	dia.newf_num (MSG_U(F_SMTPDHARDERRLIMIT,"Smtpd hard error limit"), val_smtpdhrderrlim);
	
	// smtpd_helo_required
	st = data.getvarvariable(V_SMTPD_HELO_REQUIRED);
	char var_smtpdheloreq = getvalue_yesno (st);
	const char *opt_smtpdheloreq[] = {MSG_R(X_YES),MSG_R(X_NO),NULL};
	dia.newf_chkm (MSG_U(F_SMTPDHELOREQ,"Smtpd helo required"),var_smtpdheloreq,opt_smtpdheloreq);

	// - - - RESPONSE CODES - - -
	dia.newf_title (MSG_U(T_RESPONSECODES,"response codes"),1,"",MSG_R(T_RESPONSECODES));

	// access_map_reject_code	
	st = data.getvarvariable(V_ACCESS_MAP_REJECT_CODE);
	int val_accmaprejcod = st->getval();
	dia.newf_num (MSG_U(F_ACCESSMAPREJCODE,"Access map reject code"), val_accmaprejcod);
	
	// invalid_hostname_reject_code
	st = data.getvarvariable(V_INVALID_HOSTNAME_REJECT_CODE);
	int val_invhstnrejcd = st->getval();
	dia.newf_num (MSG_U(F_INVALIDHSTNAMEREJCODE,"Invalid hostname reject code"), val_invhstnrejcd);

	// maps_rbl_reject_code
	st = data.getvarvariable(V_MAPS_RBL_REJECT_CODE);
	int val_mapsrblrejcd = st->getval();
	dia.newf_num (MSG_U(F_MAPSRBLREJCODE,"Maps rbl reject code"), val_mapsrblrejcd);
	
	// reject_code
	st = data.getvarvariable(V_REJECT_CODE);
	int val_rejcd = st->getval();
	dia.newf_num (MSG_U(F_REJECTCODE,"Reject code"), val_rejcd);
	
	// relay_domains_reject_code
	st = data.getvarvariable(V_RELAY_DOMAINS_REJECT_CODE);
	int val_reldomrejcd = st->getval();
	dia.newf_num (MSG_U(F_RELAYDOMREFCODE,"Relay domains reject code"), val_reldomrejcd);
	
	// unknown_address_reject_code
	st = data.getvarvariable(V_UNKNOWN_ADDRESS_REJECT_CODE);
	int val_unkaddrejcd = st->getval();
	dia.newf_num (MSG_U(F_UNKADRSREJCODE,"Unknow address reject code"), val_unkaddrejcd);

	// unknown_client_reject_code
	st = data.getvarvariable(V_UNKNOWN_CLIENT_REJECT_CODE);
	int val_unkclntrejcd = st->getval();
	dia.newf_num (MSG_U(F_UNKCLIENTREJCODE,"Unknow client reject code"), val_unkclntrejcd);

	// unknown_hostname_reject_code
	st = data.getvarvariable(V_UNKNOWN_HOSTNAME_REJECT_CODE);
	int val_unkhstnrejcd = st->getval();
	dia.newf_num (MSG_U(F_UNKHOSTNAMEREJCODE,"Unknown hostname reject code"), val_unkhstnrejcd);

	dia.setbutinfo (MENU_USR1, MSG_R(B_SETTODEFAULT), MSG_R(B_SETTODEFAULT));
	
	while (1){
		MENU_STATUS code = dia.edit(
			MSG_U(T_CTRLSMTPSRVPRGM,"Control the SMTP server program")
			,MSG_U(I_CTRLSMTPSRVPRGM,"Here you can configure options that control the SMTP server program")
			,help_postfix_smtpdserverprgm
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_USR1);	
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			// validation
		
			// - - - Miscellaneous - - -
			// disable_vrfy_command
			setvalue_yesno (data.getvarvariable(V_DISABLE_VRFY_COMMAND), var_disvrfycmd);
			
			// smtpd_recipient_limit
			data.getvarvariable(V_SMTPD_RECIPIENT_LIMIT)->setfrom(val_smtpdreclim);
			
			// smtpd_timeout
			data.getvarvariable(V_SMTPD_TIMEOUT)->setfrom(val_smtpdtout);

			// - - - Tarpit Controls - - -
			// smtpd_error_sleep_time
			data.getvarvariable(V_SMTPD_ERROR_SLEEP_TIME)->setfrom(val_smtpderrslptime);
			
			// smtpd_soft_error_limit
			data.getvarvariable(V_SMTPD_SOFT_ERROR_LIMIT)->setfrom(val_smtpdsfterrlim);

			// smtpd_hard_error_limit
			data.getvarvariable(V_SMTPD_HARD_ERROR_LIMIT)->setfrom(val_smtpdhrderrlim);

			// smtpd_helo_required
			setvalue_yesno (data.getvarvariable(V_SMTPD_HELO_REQUIRED), var_smtpdheloreq);

			// - - - RESPONSE CODES - - -
			// access_map_reject_code
			data.getvarvariable(V_ACCESS_MAP_REJECT_CODE)->setfrom(val_accmaprejcod);

			// invalid_hostname_reject_code
			data.getvarvariable(V_INVALID_HOSTNAME_REJECT_CODE)->setfrom(val_invhstnrejcd);
			
			// maps_rbl_reject_code
			data.getvarvariable(V_MAPS_RBL_REJECT_CODE)->setfrom(val_mapsrblrejcd);
	
			// reject_code
			data.getvarvariable(V_REJECT_CODE)->setfrom(val_rejcd);
			
			// relay_domains_reject_code
			data.getvarvariable(V_RELAY_DOMAINS_REJECT_CODE)->setfrom(val_reldomrejcd);
			
			// unknown_address_reject_code
			data.getvarvariable(V_UNKNOWN_ADDRESS_REJECT_CODE)->setfrom(val_unkaddrejcd);
		
			// unknown_client_reject_code
			data.getvarvariable(V_UNKNOWN_CLIENT_REJECT_CODE)->setfrom(val_unkclntrejcd);

			// unknown_hostname_reject_code
			data.getvarvariable(V_UNKNOWN_HOSTNAME_REJECT_CODE)->setfrom(val_unkhstnrejcd);

			ret = 1;
			break;
		}else if (code == MENU_USR1){
			if ( dialog_yesno(MSG_R(T_RESTORETODEFAULT)
					 ,MSG_R(N_RESTORETODEFAULT)
					 ,help_postfix_smtpdserverprgm) == MENU_YES ){
				int values[]={
						V_DISABLE_VRFY_COMMAND,
						V_SMTPD_BANNER,
						V_SMTPD_RECIPIENT_LIMIT,
						V_SMTPD_TIMEOUT,
						V_SMTPD_ERROR_SLEEP_TIME,
						V_SMTPD_SOFT_ERROR_LIMIT,
						V_SMTPD_HARD_ERROR_LIMIT,
						V_SMTPD_HELO_REQUIRED,
						V_ACCESS_MAP_REJECT_CODE,
						V_INVALID_HOSTNAME_REJECT_CODE,
						V_MAPS_RBL_REJECT_CODE,
						V_REJECT_CODE,
						V_RELAY_DOMAINS_REJECT_CODE,
						V_UNKNOWN_ADDRESS_REJECT_CODE,
						V_UNKNOWN_CLIENT_REJECT_CODE,
						V_UNKNOWN_HOSTNAME_REJECT_CODE,
						-1
				};
				
				data.setdefaultvarvalues(values);
				
				// disable_vrfy_command
				st = data.getvarvariable(V_DISABLE_VRFY_COMMAND);
				var_disvrfycmd = getvalue_yesno (st);

				// smtpd_recipient_limit
				st = data.getvarvariable(V_SMTPD_RECIPIENT_LIMIT);
				val_smtpdreclim = st->getval();
				
				// smtpd_timeout
				st = data.getvarvariable(V_SMTPD_TIMEOUT);
				val_smtpdtout = st->getval();
				
				// smtpd_error_sleep_time
				st = data.getvarvariable(V_SMTPD_ERROR_SLEEP_TIME);
				val_smtpderrslptime = st->getval();
				
				// smtpd_soft_error_limit
				st = data.getvarvariable(V_SMTPD_SOFT_ERROR_LIMIT);
				val_smtpdsfterrlim = st->getval();

				// smtpd_hard_error_limit
				st = data.getvarvariable(V_SMTPD_HARD_ERROR_LIMIT);
				val_smtpdhrderrlim = st->getval();
				
				// smtpd_helo_required
				st = data.getvarvariable(V_SMTPD_HELO_REQUIRED);
				var_smtpdheloreq = getvalue_yesno (st);

				// access_map_reject_code	
				st = data.getvarvariable(V_ACCESS_MAP_REJECT_CODE);
				val_accmaprejcod = st->getval();
				
				// invalid_hostname_reject_code
				st = data.getvarvariable(V_INVALID_HOSTNAME_REJECT_CODE);
				val_invhstnrejcd = st->getval();

				// maps_rbl_reject_code
				st = data.getvarvariable(V_MAPS_RBL_REJECT_CODE);
				val_mapsrblrejcd = st->getval();
				
				// reject_code
				st = data.getvarvariable(V_REJECT_CODE);
				val_rejcd = st->getval();
				
				// relay_domains_reject_code
				st = data.getvarvariable(V_RELAY_DOMAINS_REJECT_CODE);
				val_reldomrejcd = st->getval();
				
				// unknown_address_reject_code
				st = data.getvarvariable(V_UNKNOWN_ADDRESS_REJECT_CODE);
				val_unkaddrejcd = st->getval();

				// unknown_client_reject_code
				st = data.getvarvariable(V_UNKNOWN_CLIENT_REJECT_CODE);
				val_unkclntrejcd = st->getval();

				// unknown_hostname_reject_code
				st = data.getvarvariable(V_UNKNOWN_HOSTNAME_REJECT_CODE);
				val_unkhstnrejcd = st->getval();
				
				dia.reload();
			}
		}
	}
	return ret;
}
