// vim: nowrap

#include "postfixconf.h"
#include "postfixconf.m"

/*
DESCRIPTION: This DIALOG contains settings of Postfix configuration parameters that control the SMTP client program.
RETURN: 0 - case the user accept the changes
        1 - case the user cancel the changes
*/
PUBLIC int MODULE_postfixconf::smtpclientprgm_edit(DATAMAIN &data){
	int ret = 0;
	int nof = 0;
	DIALOG dia;
	SSTRING *st;
	
	// - - - Miscellaneous controls - - -
	dia.newf_title (MSG_U(T_MISCCTRL,"Miscellaneous controls"),1,"",MSG_R(T_MISCCTRL));

	// best_mx_transport
	st = data.getvarvariable(V_BEST_MX_TRANSPORT);
	dia.newf_str(MSG_U(F_BESTMXTRANS,"Best mx transport"),*st);

	// fallback_relay
	st = data.getvarvariable(V_FALLBACK_RELAY);
	dia.newf_str(MSG_U(F_FALLBACKRELAY,"Fallback relay"),*st);

	// ignore_mx_lookup_error
	st = data.getvarvariable(V_IGNORE_MX_LOOKUP_ERROR);
	char var_igmxlkper = getvalue_yesno (st);
	const char *opt_igmxlkper[] = {MSG_R(X_YES),MSG_R(X_NO),NULL};
	dia.newf_chkm (MSG_U(F_IGNOREMXLOOKUPERR,"Ignore mx lookup error"),var_igmxlkper,opt_igmxlkper);

	// smtp_skip_4xx_greeting
	st = data.getvarvariable(V_SMTP_SKIP_4XX_GREETING);
	char var_smtp4xxskp = getvalue_yesno (st);
	const char *opt_smtp4xxskp[] = {MSG_R(X_YES),MSG_R(X_NO),NULL};
	dia.newf_chkm (MSG_U(F_SMTPSKP4XXGREETING,"Smtp skip 4xx greeting"),var_smtp4xxskp,opt_smtp4xxskp);
	
	// smtp_skip_quit_response	
	st = data.getvarvariable(V_SMTP_SKIP_QUIT_RESPONSE);
	char var_smtpskpresp = getvalue_yesno (st);
	const char *opt_smtpskpresp[] = {MSG_R(X_YES),MSG_R(X_NO),NULL};
	dia.newf_chkm (MSG_U(F_SMTPSKPQUITRESP,"Smtp skip quit response"),var_smtpskpresp,opt_smtpskpresp);

	// - - - Rate controls - - -
	dia.newf_title (MSG_U(T_RATECTRL,"Rate controls"),1,"",MSG_R(T_RATECTRL));

	// smtp_destination_concurrency_limit
	st = data.getvarvariable(V_SMTP_DESTINATION_CONCURRENCY_LIMIT);
	int val_smtpdstconlim = st->getval();
	dia.newf_num (MSG_U(F_SMTPDESTCONCLIM,"Smtp destination concurrency limit"), val_smtpdstconlim);

	// smtp_destination_recipient_limit
	st = data.getvarvariable(V_SMTP_DESTINATION_RECIPIENT_LIMIT);
	int val_smtpdestreclim = st->getval();
	dia.newf_num (MSG_U(F_SMTPDESTRECLIM,"Smtp destination recipient limit"), val_smtpdestreclim);

	// default_destination_recipient_limit
	st = data.getvarvariable(V_DEFAULT_DESTINATION_RECIPIENT_LIMIT);
	int val_defdestreclim = st->getval();
	dia.newf_num (MSG_U(F_DEFDESTRECLIM,"Default destination recipient limit"), val_defdestreclim);
	
	// - - - Parallel delivery to the same destination - - -
	dia.newf_title (MSG_U(T_PARALELDELIVTOTHESAMEDEST,"Parallel delivery to the same destination"),1,"",MSG_R(T_PARALELDELIVTOTHESAMEDEST));

	// local_destination_concurrency_limit
	st = data.getvarvariable(V_LOCAL_DESTINATION_CONCURRENCY_LIMIT);
	int val_locdestconclim = st->getval();
	dia.newf_num (MSG_U(F_LOCDESTCONCLIM,"Local destination concurrency limit"), val_locdestconclim);
	
	// default_destination_concurrency_limit
	st = data.getvarvariable(V_DEFAULT_DESTINATION_CONCURRENCY_LIMIT);
	int val_defdestconclim = st->getval();
	dia.newf_num (MSG_U(F_DEFDESTCONCLIM,"Default destination concurrency limit"), val_defdestconclim);

	// - - - Timeout controls - - -
	dia.newf_title (MSG_U(T_TOUTCTRL,"Timeout controls"),1,"",MSG_R(T_TOUTCTRL));

	// smtp_connect_timeout
	st = data.getvarvariable(V_SMTP_CONNECT_TIMEOUT);
	int val_smtpcontout = st->getval();
	dia.newf_num (MSG_U(F_SMTPCONNECTOUT,"Smtp connect timeout"), val_smtpcontout);

	// smtp_helo_timeout
	st = data.getvarvariable(V_SMTP_HELO_TIMEOUT);
	int val_smtphelotout = st->getval();
	dia.newf_num (MSG_U(F_SMTPHELOTOUT,"Smtp helo timeout"), val_smtphelotout);

	// smtp_mail_timeout
	st = data.getvarvariable(V_SMTP_MAIL_TIMEOUT);	
	int val_smtpmailtout = st->getval();
	dia.newf_num (MSG_U(F_SMTPMAILTOUT,"Smtp mail timeout"), val_smtpmailtout);
	
	// smtp_rcpt_timeout
	st = data.getvarvariable(V_SMTP_RCPT_TIMEOUT);
	int val_smtprcpttout = st->getval();
	dia.newf_num (MSG_U(F_SMTPRCPTOUT,"Smtp rcpt timeout"), val_smtprcpttout);
	
	// smtp_data_init_timeout
	st = data.getvarvariable(V_SMTP_DATA_INIT_TIMEOUT);
	int val_smtpdtinitout = st->getval();
	dia.newf_num (MSG_U(F_SMTPDATAINITOUT,"Smtp data init timeout"), val_smtpdtinitout);
	
	// smtp_data_xfer_timeout
	st = data.getvarvariable(V_SMTP_DATA_XFER_TIMEOUT);
	int val_smtpdtxfertout = st->getval();
	dia.newf_num (MSG_U(F_SMTPDATAXFERTOUT,"Smtp data xfer timeout"), val_smtpdtxfertout);

	// smtp_data_done_timeout
	st = data.getvarvariable(V_SMTP_DATA_DONE_TIMEOUT);
	int val_smtpdtdntout = st->getval();
	dia.newf_num (MSG_U(F_SMTPDATADONETOUT,"Smtp data done timeout"), val_smtpdtdntout);

	// smtp_quit_timeout
	st = data.getvarvariable(V_SMTP_QUIT_TIMEOUT);
	int val_smtpqtout = st->getval();
	dia.newf_num (MSG_U(F_SMTPQUITTOUT,"Smtp quit timeout"), val_smtpqtout);
	
	// - - - Delivery to mailbox - - -
	dia.newf_title (MSG_U(T_DELIVTOMAILBOX,"Delivery to mailbox"),1,"",MSG_R(T_DELIVTOMAILBOX));
	
	// home_mailbox
	st = data.getvarvariable(V_HOME_MAILBOX);
	int val_home_mailbox;
	const int str_vals_home_mailbox[] = {0,1,2};
	const char *title_home_mailbox[] = {MSG_U(X_MBOX,"Mailbox"),MSG_U(X_MDIR,"Maildir/"),NULL};
	if (st->cmp("Mailbox")==0)
		val_home_mailbox = 0;
	else if (st->cmp("Maildir/")==0)
		val_home_mailbox = 1;
	else 	val_home_mailbox = 2;
	dia.newf_chkm_str (MSG_U(F_HOME_MAILBOX,"Home mailbox"), val_home_mailbox,*st, str_vals_home_mailbox, title_home_mailbox);
			
	// mail_spool_directory
	st = data.getvarvariable(V_MAIL_SPOOL_DIRECTORY);
	dia.newf_str(MSG_U(F_MAILSPOOLDIR,"Mail spool directory"),*st);

	// mailbox_command
	st = data.getvarvariable(V_MAILBOX_COMMAND);
	dia.newf_str(MSG_U(F_MAILBOXCMD,"Mailbox command"),*st);
	
	// mailbox_transport
	st = data.getvarvariable(V_MAILBOX_TRANSPORT);
	dia.newf_str(MSG_U(F_MAILBOXTRANS,"Mailbox transport"),*st);

	// fallback_transport
	st = data.getvarvariable(V_FALLBACK_TRANSPORT);
	dia.newf_str(MSG_U(F_FALLBACKTRANS,"Fallback transport"),*st);

	// luser_relay
	st = data.getvarvariable(V_LUSER_RELAY);
	dia.newf_str(MSG_U(F_LUSERRELAY,"Luser relay"),*st);
		
	dia.setbutinfo (MENU_USR1, MSG_R(B_SETTODEFAULT), MSG_R(B_SETTODEFAULT));
	
	while (1){
		MENU_STATUS code = dia.edit(
			MSG_U(T_CTRLSMTPCLIENTPRGM,"Control the SMTP client program")
			,MSG_U(I_CTRLSMTPCLIENTPRGM,"Here you can configure options that control the SMTP client program")
			,help_postfix_smtpclientprgm
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_USR1);	
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			// ignore_mx_lookup_error
			setvalue_yesno (data.getvarvariable(V_IGNORE_MX_LOOKUP_ERROR), var_igmxlkper);
			
			// smtp_skip_4xx_greeting
			setvalue_yesno (data.getvarvariable(V_SMTP_SKIP_4XX_GREETING), var_smtp4xxskp);
			
			// smtp_skip_quit_response	
			setvalue_yesno (data.getvarvariable(V_SMTP_SKIP_QUIT_RESPONSE), var_smtpskpresp);
		
			// smtp_destination_concurrency_limit
			data.getvarvariable(V_SMTP_DESTINATION_CONCURRENCY_LIMIT)->setfrom(val_smtpdstconlim);

			// smtp_destination_recipient_limit
			data.getvarvariable(V_SMTP_DESTINATION_RECIPIENT_LIMIT)->setfrom(val_smtpdestreclim);
			
			// default_destination_recipient_limit
			data.getvarvariable(V_DEFAULT_DESTINATION_RECIPIENT_LIMIT)->setfrom(val_defdestreclim);
			
			// local_destination_concurrency_limit
			data.getvarvariable(V_LOCAL_DESTINATION_CONCURRENCY_LIMIT)->setfrom(val_locdestconclim);
	
			// default_destination_concurrency_limit
			data.getvarvariable(V_DEFAULT_DESTINATION_CONCURRENCY_LIMIT)->setfrom(val_defdestconclim);
			
			// smtp_connect_timeout
			data.getvarvariable(V_SMTP_CONNECT_TIMEOUT)->setfrom(val_smtpcontout);
		
			// smtp_helo_timeout
			data.getvarvariable(V_SMTP_HELO_TIMEOUT)->setfrom(val_smtphelotout);
			
			// smtp_mail_timeout
			data.getvarvariable(V_SMTP_MAIL_TIMEOUT)->setfrom(val_smtpmailtout);

			// smtp_rcpt_timeout
			data.getvarvariable(V_SMTP_RCPT_TIMEOUT)->setfrom(val_smtprcpttout);
				
			// smtp_data_init_timeout
			data.getvarvariable(V_SMTP_DATA_INIT_TIMEOUT)->setfrom(val_smtpdtinitout);
			
			// smtp_data_xfer_timeout
			data.getvarvariable(V_SMTP_DATA_XFER_TIMEOUT)->setfrom(val_smtpdtxfertout);
		
			// smtp_data_done_timeout
			data.getvarvariable(V_SMTP_DATA_DONE_TIMEOUT)->setfrom(val_smtpdtdntout);
			
			// smtp_quit_timeout
			data.getvarvariable(V_SMTP_QUIT_TIMEOUT)->setfrom(val_smtpqtout);
			
			//home_mailbox
			st = data.getvarvariable(V_HOME_MAILBOX);
			switch (val_home_mailbox){
				case 0:
					st->setfrom("Mailbox");
					break;
				case 1:
					st->setfrom("Maildir/");
			}
	
			//mail_spool_directory
			/*if ( !data.is_dir(data.getvarvariable(V_MAIL_SPOOL_DIRECTORY)->get()) ){
				nof=24;
				xconf_notice (MSG_R(N_NODIR));
				continue;
			}*/
			
			ret = 1;
			break;
		}else if (code == MENU_USR1){
			if ( dialog_yesno(MSG_R(T_RESTORETODEFAULT)
					 ,MSG_R(N_RESTORETODEFAULT)
					 ,help_postfix_basic) == MENU_YES ){
				int values[]={
						V_BEST_MX_TRANSPORT,
						V_FALLBACK_RELAY,
						V_IGNORE_MX_LOOKUP_ERROR,
						V_SMTP_SKIP_4XX_GREETING,
						V_SMTP_SKIP_QUIT_RESPONSE,
						V_DEFAULT_DESTINATION_RECIPIENT_LIMIT,
						V_DEFAULT_DESTINATION_CONCURRENCY_LIMIT,
						V_SMTP_CONNECT_TIMEOUT,
						V_SMTP_HELO_TIMEOUT,
						V_SMTP_MAIL_TIMEOUT,
						V_SMTP_RCPT_TIMEOUT,
						V_SMTP_DATA_INIT_TIMEOUT,
						V_SMTP_DATA_XFER_TIMEOUT,
						V_SMTP_DATA_DONE_TIMEOUT,
						V_SMTP_QUIT_TIMEOUT,
						V_HOME_MAILBOX,
						V_MAIL_SPOOL_DIRECTORY,
						V_MAILBOX_COMMAND,
						V_MAILBOX_TRANSPORT,
						V_FALLBACK_TRANSPORT,
						V_LUSER_RELAY,
						-1
				};
				data.setdefaultvarvalues(values);
				
				
 				st = data.getvarvariable(V_DEFAULT_DESTINATION_RECIPIENT_LIMIT);
 				data.getdefvarvariable(V_SMTP_DESTINATION_RECIPIENT_LIMIT)->setfrom(*st);
 
 				data.setdefaultvar(V_SMTP_DESTINATION_RECIPIENT_LIMIT);
 				
 				// local_destination_concurrency_limit and
 				// smtp_destination_concurrency_limit depends
 				// on default_destination_concurrency_limit
 				// and its values must be the same of
 				// default_destination_concurrency_limit
 				st = data.getvarvariable(V_DEFAULT_DESTINATION_CONCURRENCY_LIMIT);
 				data.getdefvarvariable(V_SMTP_DESTINATION_CONCURRENCY_LIMIT)->setfrom(*st);
 				data.getdefvarvariable(V_LOCAL_DESTINATION_CONCURRENCY_LIMIT)->setfrom(*st);
 					
 				data.setdefaultvar(V_LOCAL_DESTINATION_CONCURRENCY_LIMIT);
 				data.setdefaultvar(V_SMTP_DESTINATION_CONCURRENCY_LIMIT);
				
				// ignore_mx_lookup_error
				st = data.getvarvariable(V_IGNORE_MX_LOOKUP_ERROR);
				var_igmxlkper = getvalue_yesno (st);

				// smtp_skip_4xx_greeting
				st = data.getvarvariable(V_SMTP_SKIP_4XX_GREETING);
				var_smtp4xxskp = getvalue_yesno (st);
				
				// smtp_skip_quit_response	
				st = data.getvarvariable(V_SMTP_SKIP_QUIT_RESPONSE);
				var_smtpskpresp = getvalue_yesno (st);

				// smtp_destination_concurrency_limit
				st = data.getvarvariable(V_SMTP_DESTINATION_CONCURRENCY_LIMIT);
				val_smtpdstconlim = st->getval();

				// smtp_destination_recipient_limit
				st = data.getvarvariable(V_SMTP_DESTINATION_RECIPIENT_LIMIT);
				val_smtpdestreclim = st->getval();

				// default_destination_recipient_limit
				st = data.getvarvariable(V_DEFAULT_DESTINATION_RECIPIENT_LIMIT);
				val_defdestreclim = st->getval();
	
				// local_destination_concurrency_limit
				st = data.getvarvariable(V_LOCAL_DESTINATION_CONCURRENCY_LIMIT);
				val_locdestconclim = st->getval();
				
				// default_destination_concurrency_limit
				st = data.getvarvariable(V_DEFAULT_DESTINATION_CONCURRENCY_LIMIT);
				val_defdestconclim = st->getval();

				// smtp_connect_timeout
				st = data.getvarvariable(V_SMTP_CONNECT_TIMEOUT);
				val_smtpcontout = st->getval();

				// smtp_helo_timeout
				st = data.getvarvariable(V_SMTP_HELO_TIMEOUT);	
				val_smtphelotout = st->getval();

				// smtp_mail_timeout
				st = data.getvarvariable(V_SMTP_MAIL_TIMEOUT);	
				val_smtpmailtout = st->getval();
				
				// smtp_rcpt_timeout
				st = data.getvarvariable(V_SMTP_RCPT_TIMEOUT);
				val_smtprcpttout = st->getval();
				
				// smtp_data_init_timeout
				st = data.getvarvariable(V_SMTP_DATA_INIT_TIMEOUT);
				val_smtpdtinitout = st->getval();
				
				// smtp_data_xfer_timeout
				st = data.getvarvariable(V_SMTP_DATA_XFER_TIMEOUT);
				val_smtpdtxfertout = st->getval();

				// smtp_data_done_timeout
				st = data.getvarvariable(V_SMTP_DATA_DONE_TIMEOUT);
				val_smtpdtdntout = st->getval();

				// smtp_quit_timeout
				st = data.getvarvariable(V_SMTP_QUIT_TIMEOUT);
				val_smtpqtout = st->getval();
				
				// home_mailbox
				st = data.getvarvariable(V_HOME_MAILBOX);
				if (st->cmp("Mailbox")==0)
				val_home_mailbox = 0;
				else if (st->cmp("Maildir/")==0)
					val_home_mailbox = 1;
				else 	val_home_mailbox = 2;
				dia.reload();
			}
		}
	}
	return ret;
}
