
/*
#include <ctype.h>
#include <errno.h>
#include <newt.h>
#include <popt.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <malloc.h>
#include <fcntl.h>
#include <libintl.h> 
#include <locale.h>
#include <libgen.h>
*/
#include <string.h>

#include <kudzu.h>

#define MOUSE_NOT_FOUND 0
#define MOUSE_FOUND 1
#define EXACT_MOUSE_FOUND 2

/* returns the mouse data found into provided variables
 or returns ==0 if mouse not found, ==1 if found, ==2 if exact mouse
 model found */
#if !defined(__mc68000__)
int return_attached_mouse(char *wh_mouse_driver, char *wh_mouse_device)
{
    int good_probe=0;
    struct device **devs;
    struct device *mouse;
    struct serialDevice *sermouse;
    int i;

    if(devs=probeDevices(CLASS_MOUSE, BUS_UNSPEC, PROBE_ONE)){
        mouse=devs[0];
        /* copies the device where the mouse was found */
        strcpy(wh_mouse_device, mouse->device);

        switch (mouse->bus) {
        case BUS_PSAUX:
            strcpy(wh_mouse_driver, "genericps/2");
            return 1;
            break;
#ifdef __sparc__
        case BUS_SBUS:
            strcpy(wh_mouse_driver, "sun");
            return 1;
            break;
#endif
        case BUS_SERIAL:
            sermouse = (struct serialDevice *) mouse;
            if (sermouse->pnpmfr && sermouse->pnpmodel) {
                if (!strcmp(sermouse->pnpmfr,"MSH") &&
                    !strcmp(sermouse->pnpmodel,"0001")) {
                    strcpy(wh_mouse_driver, "msintelli");
                    good_probe = 1;
                } /* microsoft intellimouse */
                if (!strcmp(sermouse->pnpmfr,"LGI") &&
                    !strncmp(sermouse->pnpmodel,"80",2)) {
                    strcpy(wh_mouse_driver, "logimman");
                    good_probe = 1;
                } /* logitech three button */
                if (!strcmp(sermouse->pnpmfr,"KYE") &&
                    !strcmp(sermouse->pnpmodel,"0003")) {
                    strcpy(wh_mouse_driver, "geniusnm");
                    good_probe = 1;
                } /* Genius / KYE NetMouse */
            }
            if (!good_probe)
                strcpy(wh_mouse_driver, "generic");
            if (good_probe)
                return(EXACT_MOUSE_FOUND);
            else
                return(MOUSE_FOUND);
            break;
        default:
            return(MOUSE_NOT_FOUND);
            break;
        }
    }
}
#endif

