
/* if is_new_entry!=0 then the 'del' button is not shown */
/* retuns !=0 if user confirmed, ==0 if cancelled or removed the entry */
int section_edit_users_prop(VIEWITEMS &my_vitems, int which_group, int which_item, int is_new_entry)
{
    DIALOG         my_dialog;
    MENU_STATUS    my_button=MENU_NULL;
    int            my_selection=0;
    int illegal_entry_found=1;
    int did_user_accept=0; // 0 user cancelled, !=0 user confirmed

    INIT_PROPERTIES_EDITION;

    CREATE_STR_FIELD(my_nwlogin,0,MSG_U(F_NETWARELOGIN, "Netware login:"));
    CREATE_STR_FIELD(my_syslogin,1,MSG_U(F_SYSTEMLOGIN, "System login:"));
    CREATE_OPT_STR_FIELD(my_passwd,2,MSG_U(F_LOGPASSWD, "Password (opt.):"));
    CREATE_BIN_FLAGSHOLDER(3);
    CREATE_BIN_CHK_FIELD(my_fixedpass,0,MSG_U(F_FIXEDPASSWD, "Fixed password"));

    while(illegal_entry_found){
        illegal_entry_found=0;
        if(is_new_entry){
            my_button=my_dialog.edit(MSG_U(T_INSERTINGNEWUSER, "Inserting new user..."), "", hf_user_props, my_selection, MENUBUT_ACCEPT|MENUBUT_QUIT);
        }else{
            my_button=my_dialog.edit(MSG_U(T_EDITINGUSER, "Editing user..."), "", hf_user_props, my_selection, MENUBUT_ACCEPT|MENUBUT_DEL|MENUBUT_QUIT);
        }

        did_user_accept=0;
        switch(my_button){
        case MENU_DEL:
            if(askuser_for_deletion()){
                parser_remove_line(my_vitems, which_group, which_item);
                SAVE_FILE_NWSERVCONF;
                return(0);
            }
            illegal_entry_found=1;
            break;
        case MENU_ACCEPT:
            did_user_accept=1;

            illegal_entry_found|=replace_word(line_storage, my_nwlogin.get(), 0, ILLEGAL_SPACES|ILLEGAL_EMPTYNESS|UPPERCASE_ONLY);
            illegal_entry_found|=replace_word(line_storage, my_syslogin.get(), 1, ILLEGAL_SPACES|ILLEGAL_EMPTYNESS);
            empty_is_dash(my_passwd, 0);
            minor_adjust(my_passwd);
            illegal_entry_found|=replace_word(line_storage, my_passwd.get(), 2, ILLEGAL_SPACES|ILLEGAL_EMPTYNESS);
            /* set mask */
            set_bit_status(my_flags, 0, my_fixedpass);
            DUMP_BIN_FLAGSHOLDER_NOZERO(3);

            if(!illegal_entry_found){
                CLOSE_PROPERTIES_EDITION;
                SAVE_FILE_NWSERVCONF;
            }else{
                warnuser_invalid_data_entered();
            }
            break;
        default:
            break;
        }
    }
    return(did_user_accept);
}

void section_edit_users(void)
{
    INIT_FILE_NWSERVCONF;

    DIALOG_RECORDS my_dialog;
    MENU_STATUS    my_button=MENU_NULL;
    int            my_selection=0;
    int which_group=13;

    my_dialog.newf_head("", MSG_U(X_NETWAREL_SYSTEML, "Netware login\tsystem login"));

    while(1){
        insert_to_dialog_records(my_dialog, my_vitems, which_group, 0, 1);

        my_selection=0;
        my_button=my_dialog.editmenu(MSG_U(T_DEFINEDUSERS, "Defined users"), "", help_nil, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            /* adds item, but if used does not confirm the properties' window the item is removed */
            if(!section_edit_users_prop(my_vitems, which_group, parser_add_line(my_vitems, MSG_U(X_NEWUSERENTRY, "USERNAME\tusername\tmy_password"), which_group), 1)){
                my_vitems.remove_all();
                my_vitems.read(cf_nwservconf);
            }
            break;
        default:
            section_edit_users_prop(my_vitems, which_group, my_selection, 0);
            break;
        }
    }
}


