
#ifndef SYSCTL_H
#define SYSCTL_H

#include <fviews.h>
#include <popen.h>
#include "kernelconf.h"

class SYSCTL
{
protected:
	VIEWITEMS_PARSER vip;
	VIEWITEMS vi;
	char buf[1000];
	bool modified;

	/*~PROTOBEG~ SYSCTL */
public:
	SYSCTL (void);
private:
	char *dot_to_slash (const char *var);
public:
	void erase (const char *var);
	const char *get (const char *var);
	const char *get_from_file (const char *var);
	const char *get_from_sys (const char *var);
	bool probe (const char *var);
	void set (const char *var, const char *val);
	void set_to_file (const char *var, const char *val);
	void set_to_file (const char *var, int val);
	void set_to_sys (const char *var, const char *val);
	void set_to_sys (const char *var, int val);
private:
	char *slash_to_dot (const char *var);
public:
	~SYSCTL (void);
	/*~PROTOEND~ SYSCTL */
};


#endif /* SYSCTL_H */
