#include <string.h>
#include <netconf.h>
#include <translat.h>
#include "inetdconf.h"
#include "inetdconf.m"
#include "inetdconfedit.h"
#include <module_apis/servicectl_apidef.h>

/*
 * Find if there are any duplicate service names. IN that case return
 * protocol type.
 */
static const char * get_service_name_protocol( INETDCONF *inetdconf )
{
	static char value[20];
	value[0] = '\0';
	int count = 0;
	if (inetdconf->my_inetdconflist == 0 ) {
		return value;
	}
//fprintf(stderr,"get_service_name_protocol: inetdconf->service_name.get()=%s\n", inetdconf->service_name.get());
	for ( int i=0; i<inetdconf->my_inetdconflist->getnb(); i++ ) {
		INETDCONF *entry = inetdconf->my_inetdconflist->getitem( i );
		if ( strcmp(entry->service_name.get(),inetdconf->service_name.get()) == 0 ) {
			count++;
			if ( count > 1 ) break;
		}
	}
	if ( count == 1 ) {
		return value;
	}
	snprintf(value,sizeof(value)," (%s)",inetdconf->protocol.get());
	return value;
}

static const char * get_service_name( INETDCONF *inetdconf )
{
	static char name[20];
	snprintf(name,sizeof(name),"%s%s",inetdconf->service_name.get(),get_service_name_protocol(inetdconf));
	return name;
}

static const char * get_service_id( INETDCONF *inetdconf )
{
	static char service_id[20];
	if ( xinetd_conf_flag ) {
		snprintf( service_id, sizeof(service_id), "%d/%s", inetdconf->port, inetdconf->protocol.get());
	} else {
		snprintf( service_id, sizeof(service_id), "%d/%s/%d", inetdconf->port, inetdconf->protocol.get(), inetdconf->inetdconf_line );
	}
	return service_id;
}

/*
 * SERVICECTL_API
 */
class SERVICE_INETDCONF: public SERVICE {
public:
	SERVICE_INETDCONF( const char *_name,
			const char *_desc,
			int state);
	int control (SERVICE_OPER oper);
	int edit (void);
	const char *getconfstatus (void);
	const char *getrunstatus (void);
	void showstatus (void);
};

PUBLIC SERVICE_INETDCONF::SERVICE_INETDCONF(
	const char *_name,
	const char *_desc,
	int _state)
	: SERVICE (_name,_desc,_state,OWNER_INTERNAL)
{
//fprintf(stderr,"SERVICE_INETDCONF::SERVICE_INETDCONF: name=%s desc=%s state=%d\n", _name, _desc, _state);
}

PUBLIC int SERVICE_INETDCONF::edit( )
{
	INETDCONFLIST inetdconflist;
	inetdconflist.read();
//fprintf(stderr,"SERVICE_INETDCONF::edit: inetdconflist.getnb()=%d\n",inetdconflist.getnb());
	for ( int i=0; i<inetdconflist.getnb(); i++ ) {
		INETDCONF *inetdconf = inetdconflist.getitem( i );
		if ( name.cmp( get_service_name(inetdconf) ) == 0 ) {
//fprintf(stderr,"SERVICE_INETDCONF::edit: get_service_id(inetdconf)=%s\n",get_service_id(inetdconf));
			if ( desc.cmp( get_service_id(inetdconf) ) == 0 ) {
				inetdconf->edit( &inetdconflist );
				break;
			}
		}
	}
//fprintf(stderr,"SERVICE_INETDCONF::edit OK\n");
	return( previous );
}

PUBLIC const char *SERVICE_INETDCONF::getconfstatus (void)
{
//fprintf(stderr,"SERVICE_INETDCONF::getconfstatus\n");
	return state == 0 ? MSG_U(I_SYSVENABLED,"Enabled")
			: MSG_U(I_SYSVDISABLED,"Disabled");                       
}

PUBLIC const char *SERVICE_INETDCONF::getrunstatus (void)
{
//fprintf(stderr,"SERVICE_INETDCONF::getrunstatus\n");
	return state == 0 ? MSG_U(I_RUNNING,"On demand") : "";
}

PUBLIC void SERVICE_INETDCONF::showstatus (void)
{
//fprintf(stderr,"SERVICE_INETDCONF::showstatus\n");
}

PUBLIC int SERVICE_INETDCONF::control (SERVICE_OPER oper)
{
//fprintf(stderr,"SERVICE_INETDCONF::control\n");
	int ret = -1;
	return ret;
}

static int inetdconf_collect (SERVICES &tb)
{
//fprintf(stderr,"inetdconf_collect\n");
	INETDCONFLIST inetdconflist;
	inetdconflist.read();
	for ( int i=0; i<inetdconflist.getnb(); i++ ) {
		INETDCONF *inetdconf = inetdconflist.getitem( i );
//fprintf(stderr,"inetdconf_collect: get_service_id(inetdconf)=%s\n",get_service_id(inetdconf));
		tb.add (new SERVICE_INETDCONF (get_service_name(inetdconf),get_service_id(inetdconf),inetdconf->enabled?0:1));
	}
	return( 1 );
}

static int inetdconf_control (const char *)
{
	return -1;
}

void *inetdconf_servicectl_api_get ()
{
//fprintf(stderr,"inetdconf_servicectl_api_get\n");
	SERVICECTL_API *api = new SERVICECTL_API;
	api->collect = inetdconf_collect;
	api->control = inetdconf_control;
	return api;
}

void inetdconf_servicectl_api_release (void *obj)
{
	SERVICECTL_API *api = (SERVICECTL_API*)obj;
	delete api;
}

