#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "fsbrowser.h"
#include "fsbrowser.m"

MODULE_DEFINE_VERSION(fsbrowser);

PUBLIC MODULE_fsbrowser::MODULE_fsbrowser()
	: LINUXCONF_MODULE("fsbrowser")
{
	linuxconf_loadmsg ("fsbrowser",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_fsbrowser::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_FSCONF){
		keymenu = MSG_U(M_fsbrowser,"Browse directories");
		dia.new_menuitem ("fsbrowser","",keymenu);
	}
}

PUBLIC int MODULE_fsbrowser::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_FSCONF){
		if (key == keymenu){
			fsedit();
		}
	}
	return 0;
}


PUBLIC int MODULE_fsbrowser::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"fsbrowser")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module fsbrowser\n"
		 "linuxconf --modulemain fsbrowser [ specific options ]\n"
		 "\n")
		);
}

PUBLIC void MODULE_fsbrowser::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_fsbrowser::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"fsbrowser")==0){
		ret = -1;
		if (argc == 1){
			if (netconf_mainaccess()){
				fsedit();
			}
		}else{
			::usage();
		}
	}
	return ret;
}


static MODULE_fsbrowser fsbrowser;

