/* DRBD configuration module v1.6 */
/* by Daniel Mealha Cabrita (dancab@conectiva.com) */
/*
   v1.0 first version
   v1.1 june 8th, 2000
   v1.4 august 28th, 2000
        wrote the probe/restart routines the right way (now using linuxconf's probe)
   v1.5
   v1.6 november 29th, 2000
        changed the way the drbd entries' list refreshes: now it no longer
        flashes and the last selection is kept
*/

#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "drbdconf.h"
#include "drbdconf.m"

#include "drbdconf_ed.cc"

#include <netconf_def.h>

MODULE_DEFINE_VERSION(drbdconf);

PUBLIC MODULE_drbdconf::MODULE_drbdconf()
	: LINUXCONF_MODULE("drbdconf")
{
	linuxconf_loadmsg ("drbdconf",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_drbdconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_SERVER){
		keymenu = MSG_U(M_drbd,"DRBD devices");
		dia.new_menuitem ("drbdconf","",keymenu);
	}
}

PUBLIC int MODULE_drbdconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_SERVER){
		if (key == keymenu){
                    drbd_module_starter();
                    // ### Place the call to the edit function here
		}
	}
	return 0;
}


PUBLIC int MODULE_drbdconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"drbdconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain drbdconf usage\n"
		 "\n"
		 "    drbdconf --option ...\n")
		);
}

PUBLIC void MODULE_drbdconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_drbdconf::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"drbdconf")==0){
		ret = -1;
		if (argc == 1){
             		drbd_module_starter();
			// ### Place call to main menu of the module
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}

PUBLIC int MODULE_drbdconf::probe (int level, int target, bool simul)
{
    if(level==2){
        char current_sum[500];
        const char *saved_sum;
        const char my_nothing[]="";
        int it_must_be_restarted=0; /* true, if drbd needs to be restarted */

        /* looks at each drbd config files to know if restarting is needed */
        {
            char my_filename[TYPICAL_STRING_SIZE];
            char my_drbd_varname[TYPICAL_STRING_SIZE];
            int my_counter=MAX_DRBD_FILES;

            while(my_counter--){
//                sprintf(my_filename, "/etc/sysconfig/drbd/drbd%d", my_counter);
                sprintf(my_filename, "%s/%s%d", DRBD_CONFIG_PATH, DRBD_CONFIG_FILENAME, my_counter);
                sprintf(my_drbd_varname, "drbd%d", my_counter);
                {
                    CONFIG_FILE cf_drbd(my_filename, help_nil, CONFIGF_OPTIONAL|CONFIGF_MANAGED, DRBD_SYSTEMDEF);
                    if(cf_drbd.exist()){
                        cf_drbd.md5sum(current_sum);
                        if(!(saved_sum=linuxconf_getval("drbdconf", my_drbd_varname)))
                            saved_sum=my_nothing;
                        if(strcmp(saved_sum, current_sum)){
                            it_must_be_restarted=1;
                            if(simul==false){
                                linuxconf_replace("drbdconf", my_drbd_varname, current_sum);
                                linuxconf_save();
                            }
                        }
                    }
                }
            }
        }

        if(it_must_be_restarted){
            if(simul==false){
                net_title(MSG_U(T_DRBDCONFIGCHANGED, "DRBD configurations were changed"));
                netconf_system_if("drbd", "restart");
            }
            net_prtlog(NETLOG_CMD, MSG_U(X_EXECUTINGDRBDRESTART, "Executing: drbd restart\n"));
            net_prtlog(NETLOG_WHY, MSG_U(X_ONEORMORECFGCHANGED, "One or more config files were changed. Service must restart.\n"));
        }
    }

    return(0);
}

static MODULE_drbdconf drbdconf;

