#pragma interface
#ifndef INTERNAL_H
#define INTERNAL_H

#ifndef MISC_H
	#include <misc.h>
#endif
#ifndef MODULE_H
	#include <module.h>
#endif

#ifndef NETCONF_H
	#include <netconf.h>
#endif
#ifndef DAEMONI_H
	#include <daemoni.h>
#endif

#include <modapi_def.h>
#include <modapi.h>

#include "viewsub.h"

// We must define a special CONFIG_FILE to handle archiving of the include
// files
class CONFIG_FILE_HTTPD: public CONFIG_FILE{
	/*~PROTOBEG~ CONFIG_FILE_HTTPD */
public:
	CONFIG_FILE_HTTPD (const char *_path);
	int extract (SSTREAM&ss);
	/*~PROTOEND~ CONFIG_FILE_HTTPD */
};

class APACHE_HELP_FILE: public HELP_FILE{
	/*~PROTOBEG~ APACHE_HELP_FILE */
public:
	APACHE_HELP_FILE (const char *fname);
	/*~PROTOEND~ APACHE_HELP_FILE */
};

class MODULE_APACHE: public LINUXCONF_MODULE{
	/*~PROTOBEG~ MODULE_APACHE */
public:
	MODULE_APACHE (void);
	int domenu (MENU_CONTEXT context,
		 const char *key);
	int execmain (int argc, char *argv[], bool);
	void setmenu (DIALOG&dia, MENU_CONTEXT context);
	void usage (SSTRINGS&tb);
	/*~PROTOEND~ MODULE_APACHE */
};
class HTTPD_CONFIG;
class HTTPD_USERS;

class HTTPD_USER: public ARRAY_OBJ { 
public:
	SSTRING comment;
	SSTRING user;
	SSTRING pass;

 	/*~PROTOBEG~ HTTPD_USER */
public:
	int edit (HTTPD_USERS&users);
	/*~PROTOEND~ HTTPD_USER */
};

class HTTPD_USERS: public ARRAY{
public:
	CSSTRING file;
	HTTPD_USER *getitem (int no);
	int cwrite(void);	
	int edit(void);
	HTTPD_USERS ();
};

class HTTPD_AUTHS: public ARRAY { 
public:
	HTTPD_USERS *getitem (int no);
	int edit();
};

class HTTPD_FEATURES{
	VIEWITEM *it;
public:
	char indexes;
	char followsymlinks;
	char includes;
	char execcgi;
	char symlinksifownermatch;
	char multiviews;
	char includesnoexec;

	/*~PROTOBEG~ HTTPD_FEATURES */
public:
	HTTPD_FEATURES (VIEWITEMS_SUB&sub);
	void setallopt (int val);
	void setdia (DIALOG&dia);
	void update (const char *prefix,
		 VIEWITEMS_SUB&sub);
	/*~PROTOEND~ HTTPD_FEATURES */
};
class HTTPD_OVERRIDE{
	VIEWITEM *it;
public:
	char authconfig;
	char fileinfo;
	char indexes;
	char limit;
	char options;
	SSTRING comment;

	/*~PROTOBEG~ HTTPD_OVERRIDE */
public:
	HTTPD_OVERRIDE (VIEWITEMS_SUB&sub);
	void setallopt (int val);
	void setdia (DIALOG&dia);
	void update (const char *prefix,
		 VIEWITEMS_SUB&sub);
	/*~PROTOEND~ HTTPD_OVERRIDE */
};

class HTTPD_CONFIG{
public:
	VIEWITEMS_S itemss;
	/*~PROTOBEG~ HTTPD_CONFIG */
public:
	HTTPD_CONFIG (bool extract);
	HTTPD_CONFIG (void);
	int certreq (void);
	int editdefaults (void);
	int editdirs (void);
	int editfiles (bool filematch);
	int editvhosts (void);
	void listconfigs (void);
	bool locatevhost (const char *vhost);
	int modedit (void);
	int perfedit (void);
	int signreq (void);
	int ssl_edit (void);
	int write (void);
	/*~PROTOEND~ HTTPD_CONFIG */
};

class DAEMON_HTTPD: public DAEMON_INTERNAL{
	/*~PROTOBEG~ DAEMON_HTTPD */
	/*~PROTOEND~ DAEMON_HTTPD */
};

extern const char subsys_httpd[];


#include "apache.p"

#endif

