#include "diawxxt.h"

enum TEXT_STYLE {
	R_normal=0,
	R_under=1,
	R_bold=2
};
struct RICH_POSINFO {
	int x;
	int y;
	int maxh;
	bool draw;
};
static wxFont *tbfont[3];
static RICH_POSINFO pos;
static int font_maxh;

static void richtext_drawone (
	wxDC *dc,
	TEXT_STYLE style,
	const char *s)
{
	if (s[0] != '\0'){
		dc->SetFont (tbfont[style]);
		float tw,th;
		dc->GetTextExtent (s,&tw,&th);
		int iw = (int)tw;
		if (pos.draw){
			dc->DrawText (s,pos.x,pos.y);
		}
		pos.x += iw;
	}
}


PRIVATE void FORMBASE::richtext_draweval (const char *s)
{
	if (tbfont[0] == NULL){
		tbfont[0] = new wxFont (12,wxDEFAULT,wxNORMAL,wxNORMAL,FALSE);
		tbfont[1] = new wxFont (12,wxDEFAULT,wxNORMAL,wxLIGHT,FALSE);
		tbfont[2] = new wxFont (12,wxDEFAULT,wxNORMAL,wxBOLD,FALSE);
		font_maxh = 0;
		for (int i=0; i<3; i++){
			dc->SetFont (tbfont[i]);
			int h = (int)dc->GetCharHeight();
			if (h > font_maxh) font_maxh = h;
		}
	}
	char accum[300];
	char *pt = accum;
	TEXT_STYLE style = R_normal;
	while (*s != '\0'){
		TEXT_STYLE newstyle = style;
		if (s[1] == 8){
			if (s[0] == '_'){
				// Underline
				newstyle = R_under;
			}else{
				newstyle = R_bold;
			}
			s += 2;
		}else{
			newstyle = R_normal;
		}
		if (style != newstyle){
			*pt = '\0';
			richtext_drawone (dc,style,accum);
			style = newstyle;
			pt = accum;
		}
		*pt++ = *s++;
	}
	*pt = '\0';
	richtext_drawone (dc,style,accum);
	dc->SetFont (font_normal);
}

PUBLIC void FORMBASE::richtext_draw (const char *s, int x, int y)
{
	pos.x = x;
	pos.y = y;
	pos.draw = true;
	richtext_draweval (s);
}

PUBLIC void FORMBASE::richtext_extent (const char *s, int &sw, int &sh)
{
	pos.x = pos.y = 0;
	pos.draw = false;
	richtext_draweval (s);
	sw = pos.x;
	sh = font_maxh;
}

