#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <unistd.h>
#include <errno.h>
#include <sys/wait.h>

static void erroropen (const char *fname)
{
	fprintf (stderr,"Can't open file %s (%s)\n",fname,strerror(errno));
	exit (-1);
}


int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc < 2){
		fprintf (stderr,"tlproto: Transform .tlcc file into .cc for the proto utility\n");
	}else{
		char *tb[argc];
		for (int i=1; i<argc; i++){
			tb[i] = NULL;
			const char *arg = argv[i];
			const char *pt = strstr (arg,".tlcc");
			if (pt != NULL && pt[5] == '\0' && arg[0] != '-'){
				const char *fname = strrchr (arg,'/');
				if (fname == NULL){
					fname = arg;
				}else{
					fname++;
				}
				char newfile[PATH_MAX];
				snprintf (newfile,sizeof(newfile)-1,"/tmp/%s",fname);
				// Copy the file without the <mod> and </mod> token
				FILE *fin = fopen (arg,"r");
				if (fin == NULL){
					erroropen (arg);
				}else{
					FILE *fout = fopen (newfile,"w");
					if (fout == NULL){
						erroropen (arg);
					}else{
						char buf[1000];
						bool outputon = true;
						while (fgets(buf,sizeof(buf)-1,fin)!=NULL){
							if (strncmp(buf,"<mod>",5)==0
								|| strncmp(buf,"</mod>",6)==0){
								fprintf (fout,"//%s",buf);
							}else if (strncmp(buf,"<obj ",5)==0){
								outputon = false;
							}else if (strncmp(buf,"</obj>",6)==0){
								outputon = true;
							}else if (outputon){
								fputs (buf,fout);
							}
						}
						fclose (fout);
					}
					fclose (fin);
				}
				argv[i] = strdup(newfile);
				tb[i] = argv[i];
			}
		}
		if (fork()==0){
			execvp ("proto",argv);
		}
		int status;
		wait (&status);
		ret = WIFEXITED(status) ? 0 : -1;
		for (int i=1; i<argc; i++){
			if (tb[i] != NULL) unlink (tb[i]);
		}
	}
	return ret;
}

