
/* this configuration deals with the 'users' file */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "radiusconf.h"
#include "radiusconf.m"

#include "rc_parser.h"
#include "rc_tools.h"

/* dumps sstrings to a combo_box as items */
void dump_sstrings_2_combo(FIELD_COMBO *given_fc, SSTRINGS &given_sstrings)
{
    int total_to_go;
    int my_counter=0;

    total_to_go=given_sstrings.getnb();
    while(total_to_go--)
        given_fc->addopt(given_sstrings.getitem(my_counter++)->get());
}

void edit_user_properties(int which_group, VIEWITEMS &given_vitems)
{
    DIALOG      my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;
    SSTRING     dialog_title;
    SSTRINGS    level_one_vars; // all level-1 vars indexed here
                                // (used to check if all are empty -- it would be unacceptable)
    SSTRINGS    avail_huntgroups, // all the defined huntgroups are here
                avail_hints;      // all the possible hints are here

    /* fills avail_huntgroups */
    {
        VIEWITEMS_PARSER my_vitems_parser;
        VIEWITEMS my_vitems(my_vitems_parser);
        int         progressive_counter=0;
        SSTRING     username_to_insert,
                    match_to_insert;

        my_vitems.read(cf_huntgroups);

        /* fills list.. */
        while(returns_data_for_list(my_vitems, progressive_counter++, match_to_insert, username_to_insert))
            avail_huntgroups.add(new SSTRING(username_to_insert.get()));
        avail_huntgroups.sort();
        avail_huntgroups.remove_dups();
    }
    /* fills avail_hints */
    {
        VIEWITEMS_PARSER my_vitems_parser;
        VIEWITEMS my_vitems(my_vitems_parser);
        int         remaining_groups=0;
        SSTRING     hint_to_insert;

        my_vitems.read(cf_hints);
        remaining_groups=how_many_groups_are(my_vitems);

        /* fills list.. */
        while(remaining_groups){
            load_var_data(my_vitems, remaining_groups--, "Hint", 1, hint_to_insert);
            cuts_quotes_off(hint_to_insert);
            if(!is_empty_string(hint_to_insert.get())){
                avail_hints.add(new SSTRING(hint_to_insert.get()));
            }
        }
        avail_hints.sort();
        avail_hints.remove_dups();
    }

    level_one_vars.neverdelete();
    my_dialog.setbutinfo(MENU_USR1, MSG_U(B_MOVE,"Move..."), NULL);

    /* loads vars.. */
    /* builds gui.. */
    EASY_TITLE(MSG_U(F_USERNAME,"User name:"));

    EASY_BOOL(s1_fallthrough,"Fall-Through",1,MSG_U(F_FALLTHROUGH,"Fall through:"),f1_fallthrough);
    /* level 0 */
    my_dialog.newf_title(MSG_U(X_USERSMATCH,"Match"), 1, "", MSG_R(X_USERSMATCH));
    EASY_FC(c0_authtype,"Auth-Type",0,s0_authtype,MSG_U(F_AUTHENTICATIONTYPE,"Authentication type:"));
    EASY_ADD_FC(c0_authtype,"Local");
    EASY_ADD_FC(c0_authtype,"System");
    EASY_FC(c0_servicetype,"Service-Type",0,s0_servicetype,MSG_U(F_SERVICETYPEU1,"Service type:"));
    EASY_ADD_FC(c0_servicetype,"Callback-Login-User");
    EASY_ADD_FC(c0_servicetype,"Framed-User");
    EASY_ADD_FC(c0_servicetype,"Login-User");
    EASY_ADD_FC(c0_servicetype,"Shell-User");
    EASY_STR_QUOTED(s0_password,"Password",0,MSG_U(F_PASSWORDU1,"Password:"));
    EASY_FC_QUOTED(c0_huntgroup,"Huntgroup-Name",0,s0_huntgroup,MSG_U(F_HUNTGROUPNAMEU1,"Huntgroup name:"));
    dump_sstrings_2_combo(c0_huntgroup, avail_huntgroups);
    EASY_FC_QUOTED(c0_hint,"Hint",0,s0_hint,MSG_U(F_HINT,"Hint:"));
    dump_sstrings_2_combo(c0_hint, avail_hints);

    /* level 1 */
    my_dialog.newf_title(MSG_U(X_USERSCHANGES,"Changes"), 1, "", MSG_R(X_USERSCHANGES));
    my_dialog.newf_title(MSG_U(X_USERSMISC,"Misc"), 2, "", MSG_R(X_USERSMISC));
    EASY_FC(c1_servicetype,"Service-Type",1,s1_servicetype,MSG_U(F_SERVICETYPEU2,"Service type:"));
    EASY_ADD_FC(c1_servicetype,"Callback-Login-User");
    EASY_ADD_FC(c1_servicetype,"Framed-User");
    EASY_ADD_FC(c1_servicetype,"Login-User");
    EASY_ADD_FC(c1_servicetype,"Shell-User");
    EASY_STR_QUOTED(s1_callbacknumber,"Callback-Number",1,MSG_U(F_CALLBACKNUMBER,"Callback number:"));
    EASY_STR(s1_loginiphost,"Login-IP-Host",1,MSG_U(F_LOGINIPHOST,"Login IP host:"));
    EASY_STR(s1_logintcpport,"Login-TCP-Port",1,MSG_U(F_LOGINTCPHOST,"Login TCP port:"));
    EASY_FC(c1_loginservice,"Login-Service",1,s1_loginservice,MSG_U(F_LOGINSERVICE,"Login service:"));
    EASY_ADD_FC(c1_loginservice,"PortMaster");
    EASY_ADD_FC(c1_loginservice,"Telnet");
    my_dialog.newf_title(MSG_U(X_USERSFRAMES,"Frames"), 2, "", MSG_R(X_USERSFRAMES));
    EASY_FC(c1_framedprotocol,"Framed-Protocol",1,s1_framedprotocol,MSG_U(F_FRAMEDPROTOCOL,"Framed protocol:"));
    EASY_ADD_FC(c1_framedprotocol,"PPP");
    EASY_ADD_FC(c1_framedprotocol,"SLIP");
    EASY_STR(s1_framedipaddress,"Framed-IP-Address",1,MSG_U(F_FRAMEDIPADDRESS,"Framed IP address:"));
    EASY_STR(s1_framedipnetmask,"Framed-IP-Netmask",1,MSG_U(F_FRAMEDIPNETMASK,"Framed IP netmask:"));
    EASY_FC(c1_framedrouting,"Framed-Routing",1,s1_framedrouting,MSG_U(F_FRAMEDROUTING,"Framed routing:"));
    EASY_ADD_FC(c1_framedrouting,"Broadcast-Listen");
    EASY_STR_QUOTED(s1_framedfilterid,"Framed-Filter-Id",1,MSG_U(F_FRAMEDFILTERID,"Framed filter id:"));
    EASY_STR(s1_framedmtu,"Framed-MTU",1,MSG_U(F_FRAMEDMTU,"Framed MTU:"));
    EASY_FC(c1_framedcompression,"Framed-Compression",1,s1_framedcompression,MSG_U(F_FRAMEDCOMPRESSION,"Framed compression:"));
    EASY_ADD_FC(c1_framedcompression,"Van-Jacobsen-TCP-IP");

    while(1){
        /* opens dialog.. */
        dialog_title.setfromf(MSG_U(T_USERENTRYN,"User entry %d"), which_group+1);
        my_selection=0;
        my_button=my_dialog.editmenu(dialog_title.get(), "", hf_users, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL|MENUBUT_USR1);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ACCEPT:
            {
                if(invalid_entry(my_group_title.get())){
                    informative_window(MSG_U(T_INVALIDNAMEPROVUSERS,"Invalid name provided"), MSG_U(E_INVALIDNAMEPROVUSERS,"The name can't be empty\nneither have spaces within."));
                }else{
                    if(are_all_empty(level_one_vars)){
                        informative_window(MSG_U(T_INVALIDCONFIGUSERS,"Invalid configuration"), MSG_U(E_INVALIDCONFIGUSERS,"The \"Changes\" settings must have\nat least one entry defined."));
                    }else{
                        /* save vars.. */
                        EASY_TITLE_WRITE;
                        /* level 0 */
                        EASY_SSTRING_WRITE(s0_authtype,"Auth-Type",0);
                        EASY_SSTRING_WRITE(s0_servicetype,"Service-Type",0);
                        EASY_SSTRING_QUOTED_WRITE(s0_password,"Password",0);
                        EASY_SSTRING_QUOTED_WRITE(s0_huntgroup,"Huntgroup-Name",0);
                        EASY_SSTRING_QUOTED_WRITE(s0_hint,"Hint",0);

                        /* level 1 */
                        EASY_SSTRING_WRITE(s1_framedprotocol,"Framed-Protocol",1);
                        EASY_SSTRING_WRITE(s1_framedipaddress,"Framed-IP-Address",1);
                        EASY_SSTRING_WRITE(s1_servicetype,"Service-Type",1);
                        EASY_SSTRING_WRITE(s1_framedipnetmask,"Framed-IP-Netmask",1);
                        EASY_SSTRING_WRITE(s1_framedrouting,"Framed-Routing",1);
                        EASY_SSTRING_QUOTED_WRITE(s1_framedfilterid,"Framed-Filter-Id",1);
                        EASY_SSTRING_WRITE(s1_framedmtu,"Framed-MTU",1);
                        EASY_SSTRING_WRITE(s1_framedcompression,"Framed-Compression",1);
                        EASY_SSTRING_WRITE(s1_loginiphost,"Login-IP-Host",1);
                        EASY_SSTRING_QUOTED_WRITE(s1_callbacknumber,"Callback-Number",1);
                        EASY_SSTRING_WRITE(s1_loginservice,"Login-Service",1);
                        EASY_SSTRING_WRITE(s1_logintcpport,"Login-TCP-Port",1);

                        /* let's make sure the Fall-Through is always the last line */
                        {
                            SSTRING empty_thing="";

                            EASY_SSTRING_WRITE(empty_thing,"Fall-Through",1);
                            EASY_SSTRING_WRITE(s1_fallthrough,"Fall-Through",1);
                        }
                        given_vitems.write(cf_users, 0);
                        return;
                    }
                }
            }
            break;
        case MENU_DEL:
            /* remove this entry */
            delete_whole_group(given_vitems, which_group);
            given_vitems.write(cf_users, 0);
            return;
            break;
        case MENU_USR1:
            /* move group */
            {
                int my_temp;

                my_temp=select_new_position(given_vitems, MSG_U(T_SELECTNEWPOSUSERS,"Select new position"), MSG_U(X_SELECTNEWPOSUSERS,"user name\tmatch"), MSG_U(X_LASTPOSITION,"(last_position)"));
                if(my_temp!=-1){
                    move_group(given_vitems, which_group, my_temp);
                    given_vitems.write(cf_users, 0);
                    return;
                }
            }
            break;
        default:
            break;
        }
    }

}


void show_users_list(void)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    VIEWITEMS_PARSER my_vitems_parser;
    VIEWITEMS my_vitems(my_vitems_parser);

    my_vitems_parser.comstrs.add(new SSTRING("$")); // treat $something as comments too
    my_vitems.read(cf_users);

    my_dialog.newf_head("", MSG_U(X_USERNAMEMATCHUSERS,"user name\tmatch"));

    while(1){
        int         progressive_counter=0;
        SSTRING     username_to_insert,
                    match_to_insert;

        /* fills list.. */
        while(returns_data_for_list(my_vitems, progressive_counter, match_to_insert, username_to_insert)){
            my_dialog.set_menuitem(progressive_counter, username_to_insert.get(), match_to_insert.get());
            progressive_counter++;
        }

        // remove entries below (they're the previous ones and useless now)
        my_dialog.remove_last(progressive_counter+1);

        my_button=my_dialog.editmenu(MSG_U(T_USERLISTENTRIES,"User list entries"), MSG_U(I_SENSITIVE2POSITIONS,"WARNING: This list is sensitive to items' positions.\nRead documentation for details."), hf_general_list2, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            {
                int how_many;

                how_many=how_many_groups_are(my_vitems);
                create_new_group(my_vitems, "DEFAULT", "\tService-Type = Shell-User");
                edit_user_properties(how_many, my_vitems);
                my_vitems.write(cf_users, 0);
            }
            break;
        default:
            {
                edit_user_properties(my_selection, my_vitems);

                break;
            }
        }
    }





}

