/* this part deals with settings and defaults */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
// #include <translat.h>
// #include "pslaveconf.h"
// #include "pslaveconf.m"
// #include <stdlib.h>

// #include <private_msg.h>
// #include <dialog.h>


#include <fviews.h>



#define TYPICAL_FIELD_SIZE 300
#define TYPICAL_STRING_SIZE 100
#define BIG_STRING_SIZE 2000

/* return true if yes, false if no */
int confirm_yesno_window(const char *my_title, const char *my_text)
{
    if(dialog_yesno(my_title, my_text, help_nil)==MENU_YES){
        return(1);
    } else {
        return(0);
    }
}

void informational_window(const char *my_title, const char *my_text)
{
    int nothing=0;
    DIALOG uhoh_dialog;

    uhoh_dialog.editmenu(my_title, my_text, help_nil, nothing, 0);
}


void char2string(char given_char, char *output_string)
{
    int temp_value;

    temp_value=given_char;
    sprintf(output_string, "%d", temp_value);
}

void int2string(int given_int, char *output_string)
{
    sprintf(output_string, "%d", given_int);
}

/* return true if they're the same variable */
int is_the_same_variable(const char *provided_variable, const char *provided_line)
{
    if(strlen(provided_line)>=strlen(provided_variable)){
        if(!strncmp(provided_line, provided_variable, strlen(provided_variable))){
            char analyse_this;
            /* allright, let's see if the var in line is not a different var
              with the same beginning */
            analyse_this=*(provided_line+strlen(provided_variable));
            if((analyse_this<32)||(analyse_this==' ')||(analyse_this=='='))
                return(1);
        }
    }
    return(0);
}

/* given a line with varname+data, gives the data */
const char *return_data_from_variable(const char *given_line)
{
/*    char *get_from_this_point;

    if((get_from_this_point=strchr(given_line, ' '))){
        while(*get_from_this_point==' ')
            get_from_this_point++;
    }
    return(get_from_this_point);
*/

    const char *get_from_this_point;

    get_from_this_point=given_line;
    while(*get_from_this_point>32){
        get_from_this_point++;
    }
    while((*get_from_this_point)&&(*get_from_this_point<33)){
        get_from_this_point++;
    }
    if(!*get_from_this_point)
        get_from_this_point=NULL;
    return(get_from_this_point);
}

/* locates variable's viewitem
this is used both for reading and writting variables' routine */
/* if variable not found, returns NULL */
VIEWITEM *locate_variables_viewitem(const char *givenvarname, VIEWITEMS &vitems_pslave)
{
    VIEWITEM *specific_item;
    int total_items;
    int where_i_am;
    VIEWITEM *which_vitem_to_return=NULL;

    total_items=vitems_pslave.getnb();
    where_i_am=0;

    while(where_i_am<total_items){
        specific_item=vitems_pslave.getitem(where_i_am);
        if(is_the_same_variable(givenvarname, specific_item->line.get())){
            which_vitem_to_return=specific_item;
        }
        where_i_am++;
    }

    return(which_vitem_to_return);
}

/* locates variable's viewitem _or_ creates a new one and returns it */
VIEWITEM *which_viewitem_to_write(const char *givenvarname, VIEWITEMS &vitems_pslave)
{
    VIEWITEM *specific_item;
    int where_i_am;
    int total_items;
    VIEWITEM *return_this_viewitem;

    if(!(return_this_viewitem=locate_variables_viewitem(givenvarname, vitems_pslave))){
        /* locate best place to create variable entry */
        total_items=vitems_pslave.getnb();
        where_i_am=0;

        specific_item=vitems_pslave.getitem(where_i_am);
        while((where_i_am<total_items)&&(strcmp(givenvarname, specific_item->line.get())>0)){
            specific_item=vitems_pslave.getitem(where_i_am);
            where_i_am++;
        }

        /* inserts the variable.. */
        return_this_viewitem=new VIEWITEM("");
        vitems_pslave.insert(where_i_am, return_this_viewitem);
    }

    return(return_this_viewitem);
}

/* adds spaces to the right of varname (so data will be always
   in the right column */
/* returned pointer _MUST_ be freed after usage */
char *adjust_varname(const char *given_varname)
{
    char *my_buff=NULL;
    int  my_allocation_size;

    if(strlen(given_varname)<15){
        my_allocation_size=16;
    } else {
        my_allocation_size=strlen(given_varname)+1;
    }

    if((my_buff=(char *)malloc(my_allocation_size))){
        strcpy(my_buff, given_varname);
        while(strlen(my_buff)<15){
            strcat(my_buff, " ");
        }
    }

    return(my_buff);
}

/* transfers (parses) data from the specified variable to the string array */
void loadfromfile(char *givenvarname, char *dumpstringhere, VIEWITEMS &usedvitems)
{
/*    char my_tempbuff[1000];
    char *my_returned_string;

    if((my_returned_string=(char*)usedvitems.locateval(givenvarname, my_tempbuff))){
        strcpy(dumpstringhere, my_returned_string);
    } else {
        *dumpstringhere=0;
    }
*/

    VIEWITEM *my_viewitem;

    if((my_viewitem=locate_variables_viewitem(givenvarname, usedvitems))){
        const char *my_copyfrom;

        if((my_copyfrom=return_data_from_variable(my_viewitem->line.get())))
           strcpy(dumpstringhere, my_copyfrom);
    } else {
        *dumpstringhere=0;
    }
}

/* same as above but for writting.. (really?) */
void writetofile(const char *givenvarname, const char *givenstring, VIEWITEMS &usedvitems)
{
/*  if(*givenstring){
        usedvitems.update(givenvarname, givenstring);
    } else {
        VIEWITEM *to_erase;

        //empty entry: remove the line from file
        if((to_erase=usedvitems.locate(givenvarname, 0, usedvitems.getnb()))){
//            printf("to_erase: [%x]\n", to_erase);
            usedvitems.remove_del(to_erase);
        }
    }
*/

    VIEWITEM *my_viewitem;

    my_viewitem=which_viewitem_to_write(givenvarname, usedvitems);

    if(*givenstring){
        {
            char *adjusted_varname;
            if((adjusted_varname=adjust_varname(givenvarname))){
                my_viewitem->line.setfrom(adjusted_varname);
                free(adjusted_varname);
            }
        }
        my_viewitem->line.append(" ");
        my_viewitem->line.append(givenstring);
    } else {
        usedvitems.remove_del(my_viewitem);
    }
}

/* given var1 and var2 --> var1.var2 */
/* returned pointer _MUST_ be freed after usage */
char *glue_varname(char *firstvarname, char *secondvarname)
{
    char *my_buff=NULL;

    if((my_buff=(char *)malloc(strlen(firstvarname)+strlen(secondvarname)+2)))
        sprintf(my_buff, "%s.%s", firstvarname, secondvarname);

    return(my_buff);
}

/* transfers (parses) data from the specified variable to the string array */
/* alternative syntax */
void loadfromfile2(char *firstvarname, char *secondvarname, char *dumpstringhere, VIEWITEMS &usedvitems)
{
    char *my_buff;

    if((my_buff=glue_varname(firstvarname, secondvarname))){
        loadfromfile(my_buff, dumpstringhere, usedvitems);
        free(my_buff);
    }
}

/* this too, same as above but for writting */
void writetofile2(char *firstvarname, char *secondvarname, char *givenstring, VIEWITEMS &usedvitems)
{
    char *my_buff;

    if((my_buff=glue_varname(firstvarname, secondvarname))){
        writetofile(my_buff, givenstring, usedvitems);
        free(my_buff);
    }
}

/* transfers (parses) data from the specified variable to the string array */
/* multiline operation (ex.: all.realm variables) */
void loadmultilinefromfile(char *givenvarname, SSTRING &dumpstringhere, VIEWITEMS &vitems_pslave)
{
    int  where_i_am;
    int  total_items;
    VIEWITEM *specific_item;
    const char *data_to_append;

//    *dumpstringhere=0;
    dumpstringhere.setfrom("");

    total_items=vitems_pslave.getnb();
    where_i_am=0;

    while(where_i_am<total_items){
        specific_item=vitems_pslave.getitem(where_i_am);
        if(is_the_same_variable(givenvarname, specific_item->line.get())){
            if((data_to_append=return_data_from_variable(specific_item->line.get()))){
                dumpstringhere.append(data_to_append);
                dumpstringhere.append("\n");
//                strcat(dumpstringhere, data_to_append);
//                strcat(dumpstringhere, "\n");
            }
        }
        where_i_am++;
    }
}

/* delete this.. useless now */
/* this routine is currently useless */
void add_line_to_file(char *line_to_add, VIEWITEMS &vitems_pslave)
{
    VIEWITEM *temporary_line=new VIEWITEM("");

    temporary_line->line.setfrom(line_to_add);
    vitems_pslave.add(temporary_line);
}

/* for variables defined several times in the same file..
   each substring ended by \n is considered a new variable entry */
void updatemultilinetofile(char *givenvarname, SSTRING &provided_data_string, VIEWITEMS &vitems_pslave)
{
    const char *provided_data;
    int total_items;
    int where_i_am=0;
    int where_to_insert=0;
    VIEWITEM *specific_item;

    /* let's make sure there's an entry for this variable in the right place,
       if it didn't exist before */
    (which_viewitem_to_write(givenvarname, vitems_pslave))->line.setfrom(givenvarname);

    provided_data=provided_data_string.get();
    total_items=vitems_pslave.getnb();

    /* locate variable (if exists) and delete the old data */
    while(where_i_am<total_items){
        specific_item=vitems_pslave.getitem(where_i_am);
        if(is_the_same_variable(givenvarname, specific_item->line.get())){

            if(!where_to_insert)
                where_to_insert=where_i_am;

            vitems_pslave.remove_del(where_i_am);
            where_i_am--;
            total_items--;
        }
        where_i_am++;
    }

    /* now rewrite that variable at the same place the previous one */
    {
        char *my_buff;
        char *my_zero;
        char *my_pos;

        if((my_buff=(char *)malloc(strlen(provided_data)+2))){
            strcpy(my_buff, provided_data);
            strcat(my_buff, "\n");

            my_pos=my_buff;
            while((my_zero=strchr(my_pos, '\n'))){
                *my_zero=0;

                // copiar de my_pos
                if(*my_pos){
                    VIEWITEM *temporary_line=new VIEWITEM("");

                    {
                        char *adjusted_varname;
                        if((adjusted_varname=adjust_varname(givenvarname))){
                            temporary_line->line.setfrom(adjusted_varname);
                            free(adjusted_varname);
                        }
                    }
                    temporary_line->line.append(" ");
                    temporary_line->line.append(my_pos);
                    vitems_pslave.insert(where_to_insert++, temporary_line);
                }
                my_pos=my_zero+1;
            }

            free(my_buff);
        }
    }
}

/* these following two do the same as the previous ones,
 but using them you may provide the variable name
 in two parts (so they'll concatenate them for you) */
void updatemultilinetofile2(char *givenvar1, char *givenvar2, SSTRING &provided_data, VIEWITEMS &vitems_pslave)
{
    char *my_buff;

    if((my_buff=glue_varname(givenvar1, givenvar2))){
        updatemultilinetofile(my_buff, provided_data, vitems_pslave);
        free(my_buff);
    }
}

void loadmultilinefromfile2(char *givenvar1, char *givenvar2, SSTRING &dumpstringhere, VIEWITEMS &vitems_pslave)
{
    char *my_buff;

    if((my_buff=glue_varname(givenvar1, givenvar2))){
        loadmultilinefromfile(my_buff, dumpstringhere, vitems_pslave);
        free(my_buff);
    }
}


