
#ifndef PRINTER_GI_DEF

#include <modapi.h>
#include <fviews.h>

/* use this structure to read/write a printer's properties to its config files */
struct t_printer_props{
    char    printer_type;   /* (read only) PRT_LOCAL PRT_REMOTE PRT_SMBWIN PRT_NETWARE or PRT_DIRECT*/
    SSTRING printername;    /* (read only) 'lp' etc.. */
    SSTRING f_printername,  /* (read only) name of the filter (filter identificator) */
            f_description,  /* (read only) filter description */
            f_resolution,   /* 300x300.. etc -- see gi_returns_lists() */
            f_papersize,    /* A4, letter, etc -- see gi_returns_lists() */
            f_colordepth;   /* color 12bit, b&w, N/A, etc -- see gi_returns_lists() */
    int margin_horiz,       /* typical value: 18 */
        margin_vert;        /* typical value: 18 */
    SSTRING extra_gsopts;   /* extra GS parameters (opt) */
    char send_eof,           // (bool) send eof after the job
         correct_crlf,       // (bool) correct the 'ladder effect'
         fastascii;          // (bool) if true, ascii is not filtered (can't be used with ppa printers)
    /* variables which depend on the chosen printer type
       (leave untouched the ones you don't use) */
    SSTRING use_device,     // /dev/lp0 etc (PRT_LOCAL)
            remote_machine, // PRT_REMOTE
            remote_queue,   // PRT_REMOTE
            user,           // PRT_SMBWIN and PRT_NETWARE
            password,       // PRT_SMBWIN and PRT_NETWARE
            hostname,       // PRT_SMBWIN
            remote_printername, // PRT_SMBWIN
            hostip,             // PRT_SMBWIN
            workgroup,          // PRT_SMBWIN
            server,             // PRT_NETWARE
            netw_queue;         // PRT_NETWARE
};

/* this is used to provide the available items for certain lists
 (which are affected by the selected printer filter)
 f_resolution or f_colordepth may be empty! */
/* the *_desc variables are optional, they just provide a description
   for each item (f_resolution.getnb()==f_resolution_desc.getnb()) */
struct t_avail_opts{
    SSTRINGS f_resolution, f_resolution_desc,
             f_colordepth, f_colordepth_desc,
             f_papersize, f_papersize_desc;
};

int gi_return_filtersnames(SSTRINGS &drop_here);
int gi_return_printers_list(SSTRINGS &drop_here);
void gi_return_printer_data(int which_printer, t_printer_props &drop_here);
void gi_write_printer_data(int which_printer, t_printer_props &drop_here);
void gi_select_new_filter(int which_printer, t_printer_props &drop_here, const char *use_filter);
void gi_returns_lists(int which_printer, t_printer_props &get_from, t_avail_opts &dump_here);
int gi_create_a_printer(char type_printr, char *printer_name, char *my_fullspoolpath);
void gi_remove_printer(int which_printer_v);

void gi_init(void);
void gi_close(void);



#define PRINTER_GI_DEF
#endif

