// vim: nowrap

#pragma implementation
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <translat.h>
#include <fviews.h>
#include "postfixconf.h"
#include "postfixconf.m"
#include "postfix_data.h"
#include "alias.h"
#include "virtuals.h"
#include "canonical.h"
#include <subsys.h>

const char subsys_postfix[]="postfix";

static LINUXCONF_SUBSYS sub0 (subsys_postfix
	,P_MSG_U(M_SUBPOSTFIX,"Postfix configuration"));


MODULE_DEFINE_VERSION(postfixconf);

PUBLIC MODULE_postfixconf::MODULE_postfixconf()
	: LINUXCONF_MODULE("postfixconf")
{
	linuxconf_loadmsg ("postfixconf",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_postfixconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_SERVER){
		keymenu = MSG_U(M_POSTFIXCONF,"Postfixconf");
		dia.new_menuitem ("postfixconf","",keymenu);
	}
}

PUBLIC int MODULE_postfixconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_SERVER){
		if (key == keymenu){
			// ### Place the call to the edit function here
			postfix_edit();
		}
	}
	return 0;
}


PUBLIC int MODULE_postfixconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"postfixconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}

static void usage()
{
	fprintf (stderr, MSG_U(T_USAGE
		,"Module postfixconf\n"
		 "linuxconf --modulemain postfixconf [ specific options ]\n"
		 "\n"
		 "    --virtualedit [ path ]\n"
		 "    --aliasedit [ path ]\n"
		 "    --canonicaledit [ path ]\n"
		 "    --variables (list of the recognized variables by module)\n"
		 "    --setvariable variable [value]\n"
		 "\n"
		));
}

PUBLIC void MODULE_postfixconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_postfixconf::execmain (int argc , char *argv[], bool standalone)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"postfixconf")==0){
		ret = -1;
		if (argc == 1){
			// ### Place call to main menu of the module
			postfix_edit();
		}else{
			// ### Add some option parsing for the module
			if (argc == 2 && (strcmp( argv[1],"--variables" ) == 0)){
				// show the postfix variables, actual value and defvalue that postfixconf can configure
				argc -= 1; argv++;
				if (cf_postfix_main.exist()){ // if the file exist
					DATAMAIN data;
					
					if ( data.load()!=-1 ){ // verify if the cfg file can be read
						if(data.setdefaultvalues()==1){
							data.showvalues();
						}else	printf (MSG_R(E_GETTINGDEFVAL));
					}else	printf (MSG_R(E_READING),cf_postfix_main.getpath());
				}else	printf (MSG_R(E_FILENOTFOUND), cf_postfix_main.getpath());
			}else	if ( argc > 2 ){ // command line commands
					if ( strcmp( argv[1],"--virtualedit" ) == 0 ) {
						argc -= 2; argv++; argv++;
						VIRTUALS vrt(*argv,NULL,true,DEFAULT_DATABASE);
						vrt.edit();
					}else if ( strcmp( argv[1],"--aliasedit" ) == 0 ){
						argc -= 2; argv++; argv++;
						ALIASES ali(*argv,NULL,true,DEFAULT_DATABASE);
						ali.edit();
					}else if ( strcmp( argv[1],"--canonicaledit" ) == 0 ){
						argc -= 2; argv++; argv++;
						CANONICAL can(*argv,NULL,true,DEFAULT_DATABASE);
						can.edit();
					}else if ( strcmp( argv[1],"--setvariable" ) == 0 ){
						argc -= 2; argv++; argv++;
						if (cf_postfix_main.exist()){
							DATAMAIN data;
							int ret = data.write_one(*argv, *(argv+1));
							if (ret == -1){
								printf (MSG_R(E_FILENOTFOUND), cf_postfix_main.getpath());
							}else if (ret == 0){
								printf ( "file not recognized\n" );
							}
						}else	printf ( MSG_R(E_FILENOTFOUND), cf_postfix_main.getpath() );
					}
			}else{
				::usage();
			}
		}
	}
	return ret;
}

static MODULE_postfixconf postfixconf;

PUBLIC void MODULE_postfixconf::postfix_edit()
{
	/* 
	 * #Specification: postfix / main menu
	*/
	int choice=0;
	int modified = 0;
	
	if (!cf_postfix_main.exist()){ // if the cfg file exist
		xconf_error (MSG_U(E_FILENOTFOUND,"File '%s' not found!"), cf_postfix_main.getpath());
		return;
	}

	// Create DATAMAIN class. This class contains all postfix variables and method for them
	DATAMAIN data;
	
	if ( data.load()==-1 ){// if the cfg file can't be read
		xconf_error (MSG_U(E_READING,"Error reading file '%s'"),cf_postfix_main.getpath());
		return;
	}
	if(data.setdefaultvalues()!=1){// getting default values
		xconf_error (MSG_U(E_GETTINGDEFVAL,"Error getting default values"));
		return;
	}
	data.sincronizedefault(); // sincronize the postfix variable with defaults

	static const char *basic = MSG_U(M_BASICINF,"Basic information");
	static const char *addressmasq = MSG_U(M_ADDMASQ,"Address masquerading");
	static const char *smtpclientprgm = MSG_U(M_SMTPCLPRGM,"Smtp client program");
	static const char *smtpdserverprgm = MSG_U(M_SMTPSERVPRGM,"Smtp server program");
	static const char *miscellaneous = MSG_U(M_MISC,"Miscellaneous");
	static const char *ressctrlparam = MSG_U(M_RESCTRLPARAM,"Resource controls parameters");
	static const char *ldaplookuptout = MSG_U(M_LDAPLKPTOUT,"Ldap lookup timeout");
	static const char *ctrllocaldeliv = MSG_U(M_CTRLOCDEL,"Control local delivery");
	static const char *ctrldelivrates = MSG_U(M_CTRLDELRATES,"Control delivery rates");
	static const char *spamctrl = MSG_U(M_MSPAMCTRL,"Spam controls");
	static const char *tablelocations = MSG_U(M_TABLELOC,"Table locations");
	static const char *virtualtables = MSG_U(M_VIRTUAL,"Virtual tables");
	static const char *aliastables = MSG_U(M_ALIASES,"Aliases tables");
	static const char *canonicaltables = MSG_U(M_CANONICAL,"Canonical tables");
//	static const char *configuration = MSG_U(M_CONFIGURATION,"View configuration");  // for tests
	
	static const char *menuopt1[]={
		MSG_U(M_CONFIG,"Configure"),			basic,
//		"",						configuration, // for tests
		"",                             		addressmasq,
		"",						smtpclientprgm,
		"",						smtpdserverprgm,
		"",						miscellaneous,
		"",						ressctrlparam,
		"",						ldaplookuptout,
		"",						ctrllocaldeliv,
		"",						ctrldelivrates,
		"",						spamctrl,
		"",						tablelocations,
		NULL
	};
	
	static const char *menuopttable[]={
		MSG_U(M_EDIT,"Edit"),				virtualtables,
		"",						aliastables,
		"",						canonicaltables,
		NULL
	};

	DIALOG_MENU dia;
	dia.new_menuitems (menuopt1);
	dia.new_menuitems (menuopttable);
	SSTRING sendpath (cf_postfix_main.getpath());
	
	while (1){
		MENU_STATUS code = dia.editmenu (MSG_U(T_POSTFIX,"Postfix configurator"),
						 MSG_U(I_POSTFIX,"This package allows you to configure\n"
			                                         "Postfix, the mail system configurator\n")
						 ,help_postfix_intro
						 ,choice,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			if (modified){
				char intro[1000];
				sprintf (intro // ask for user if he wan't save the cfg file
					,MSG_U(I_GENPOSTFIX,"You have modified postfix's configuration.\n"
					                    "A new %s must be generated.\n"
					                    "Do you want to do it now")
					                    ,sendpath.get());
				if (dialog_yesno(MSG_U(N_WARNING,"Generate file"),intro,help_postfix_intro) == MENU_YES){
					if (data.backup_file()==-1) // can't write backup file
						xconf_notice (MSG_U(E_BACKUPFILE,"Couldn't write backup file"));
					if ( data.save()==-1 ) // can't save the file
						xconf_notice (MSG_U(E_SAVING,"Couldn't save changes on '%s'"),sendpath.get());
				}
			}
			break;
		}else{
			const char *key = dia.getmenustr (choice);
			if (key == basic){
				modified |= basic_edit(data);
			}else if (key == addressmasq){
				modified |= addressmasq_edit(data);
			}else if (key == smtpclientprgm){
				modified |= smtpclientprgm_edit(data);
			}else if (key == smtpdserverprgm){
				modified |= smtpdserverprgm_edit(data);
			}else if (key == miscellaneous){
				modified |= miscellaneous_edit(data);
			}else if (key == ressctrlparam){
				modified |= ressctrlparam_edit(data);
			}else if (key == ldaplookuptout){
				modified |= ldaplookuptout_edit(data);
			}else if (key == ctrllocaldeliv){
				modified |= ctrllocaldeliv_edit(data);
			}else if (key == ctrldelivrates){
				modified |= ctrldelivrates_edit(data);
			}else if (key == spamctrl){
				modified |= spamctrl_edit(data);
			}else if (key == virtualtables){
				modified = virtualtable_edit(data);
			}else if (key == aliastables){
				modified = aliastable_edit(data);
			}else if (key == canonicaltables){
				modified = canonicaltables_edit(data);
			}else if (key == tablelocations){
				modified |= tablelocations_edit(data);
			}//else if (key == configuration){ // for tests
			//	configuration_edit(data);
			//}
		}
	}
}

// for tests
/*
PUBLIC void MODULE_postfix::configuration_edit(DATAMAIN &data){
	SSTRING strgen;
	data.viewvardefault(strgen);
	xconf_notice (strgen.get());
}
*/
