/*
	This small utility is used to collect statistics about processes
	and context switches. These numbers are always climbing. This
	is not the number of running process, but the processes run so far
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int main (int, char *[])
{
	int ret = -1;
	FILE *fin = fopen ("/proc/stat","r");
	if (fin != NULL){
		char buf[100];
		int nbctxt = 0;
		int nbproc = 0;
		while (fgets (buf,sizeof(buf)-1,fin)!=NULL){
			if (strncmp(buf,"ctxt",4)==0){
				char *pt = buf+4;
				while (*pt == ' ') pt++;
				nbctxt = atoi(pt);
			}else if (strncmp(buf,"processes",9)==0){
				char *pt = buf+9;
				while (*pt == ' ') pt++;
				nbproc = atoi(pt);
			}
		}
		printf ("%d\n%d\n\nContext switch and processes\n"
			,nbctxt,nbproc);
		ret = 0;
		fclose (fin);
	}
	if (ret == -1){
		printf ("0\n0\n\nCan't read /proc/stat\n");
	}
	return 0;
}


