#ifndef kernelconf_h
#define kernelconf_h
#pragma interface
#ifndef MISC_H
    #include <misc.h>
#endif
#ifndef MODULE_H
    #include <module.h>
#endif

#include <modapi_def.h>
#include <modapi.h>
#include "sysctl.h"

class MODULE_kernelconf: public LINUXCONF_MODULE{
    /*~PROTOBEG~ MODULE_kernelconf */
public:
	MODULE_kernelconf (void);
	int dohtml (const char *key);
	int domenu (MENU_CONTEXT context,
		 const char *key);
	int execmain (int argc,
		 char *argv[],
		 bool);
	int message (const char *msg,
		 int argc,
		 const char *argv[]);
	int probe (int level, int runlevel, bool sim);
	void setmenu (DIALOG&dia,
		 MENU_CONTEXT context);
	void usage (SSTRINGS&tb);
    /*~PROTOEND~ MODULE_kernelconf */
};

#include "kernelconf.p"

#endif
