
#include <stdlib.h>
#include <string.h>
#include <fviews.h>
#include "aptconf.h"

static CONFIG_FILE vlist_file(
		"/etc/apt/vendors.list",
		help_nil,CONFIGF_MANAGED,
		"root","root",0600);

PRIVATE bool VLIST::get_value(const char *line, SSTRING &s)
{
	const char *start = line, *end;
	while (*start != 0 && *start != '"') start++;
	if (*start == 0) return false;
	start++;
	end = start;
	while (*end != 0 && *end != '"') end++;
	if (*end == 0) return false;
	s.setfrom(start,end-start);
	return true;
}

PUBLIC VLIST::VLIST()
	: vi(vlp)
{
	vi.read(vlist_file);
	modified = 0;
}

PUBLIC VLIST::~VLIST()
{
	if (modified){
		vi.write(vlist_file,NULL);
	}
}

PUBLIC int VLIST::count()
{
	return vi.getnb(VLIST_KEYSTART);
}

PUBLIC bool VLIST::get(int nb, VLIST_ITEM &vlitem)
{
	VIEWITEM *it = vi.getitem(nb, VLIST_KEYSTART);
	if (it != NULL){
		int realpos = vi.lookup(it,-1);
		while (it != NULL && it->type != VLIST_KEYEND){
			switch (it->type){
				case VLIST_KEYSTART:
					this->get_value(it->line.get(),vlitem.vendor);
					break;
				case VLIST_NAME:
					this->get_value(it->line.get(),vlitem.comment);
					break;
				case VLIST_FINGERPRINT:
					this->get_value(it->line.get(),vlitem.fp);
					break;
			}
			realpos++;
			it = vi.getitem(realpos, -1);
		}
	}
	return false;
}

#define KEYSTART_TEMPLATE "simple-key \"%s\" {"
#define NAME_TEMPLATE     "\tName \"%s\";"
#define FP_TEMPLATE       "\tFingerprint \"%s\";"
#define KEYEND_TEMPLATE   "};"


PUBLIC void VLIST::set(int nb, VLIST_ITEM &vlitem)
{
	int keystart_len = vlitem.vendor.getlen()+strlen(KEYSTART_TEMPLATE);
	int name_len = vlitem.comment.getlen()+strlen(NAME_TEMPLATE);
	int fp_len = vlitem.fp.getlen()+strlen(FP_TEMPLATE);

	int max_len = (keystart_len > name_len) ?
			 ((keystart_len > fp_len) ? keystart_len : fp_len)
			:((name_len > fp_len) ? name_len : fp_len);

	char *line = (char *) malloc(max_len);
	
	if (nb >= vi.getnb(VLIST_KEYSTART)){
		VIEWITEM *it;
		sprintf(line,KEYSTART_TEMPLATE,vlitem.vendor.get());
		it = new VIEWITEM(line,VLIST_KEYSTART);
		vi.add(it);
		sprintf(line,NAME_TEMPLATE,vlitem.comment.get());
		it = new VIEWITEM(line,VLIST_NAME);
		vi.add(it);
		sprintf(line,FP_TEMPLATE,vlitem.fp.get());
		it = new VIEWITEM(line,VLIST_FINGERPRINT);
		vi.add(it);
		it = new VIEWITEM(KEYEND_TEMPLATE,VLIST_KEYEND);
		vi.add(it);
	}else{
		int realpos = vi.realpos(nb,VLIST_KEYSTART);
		VIEWITEM *name = NULL, *fp = NULL;
		VIEWITEM *keystart = vi.getitem(realpos,-1);
		int pos = realpos;
		VIEWITEM *it = keystart;
		while (it != NULL && it->type != VLIST_KEYEND){
			switch (it->type){
				case VLIST_NAME:
					name = it;
					break;
				case VLIST_FINGERPRINT:
					fp = it;
					break;
			}
			it = vi.getitem(++pos, -1);
		}
		sprintf(line,KEYSTART_TEMPLATE,vlitem.vendor.get());
		keystart->line.setfrom(line);
		sprintf(line,NAME_TEMPLATE,vlitem.comment.get());
		if (name != NULL){
			name->line.setfrom(line);
		}else{
			name = new VIEWITEM(line,VLIST_NAME);
			vi.insert(realpos+1,name,-1);
		}
		sprintf(line,FP_TEMPLATE,vlitem.fp.get());
		if (fp != NULL){
			fp->line.setfrom(line);
		}else{
			fp = new VIEWITEM(line,VLIST_NAME);
			vi.insert(realpos+1,fp,-1);
		}
	}

	modified = true;
}

PUBLIC void VLIST::erase(int nb)
{
	int pos = vi.realpos(nb,VLIST_KEYSTART);
	VIEWITEM *it = vi.getitem(pos,-1);
	while (it != NULL) {
		if (it->type == VLIST_KEYEND) {
			vi.remove_del(pos, -1);
			break;
		}
		vi.remove_del(pos, -1);
		it = vi.getitem(pos,-1);
	}
}

PUBLIC bool VLIST_ITEM::check()
{
	if (vendor.getlen() > 0 && fp.getlen() > 0 && comment.getlen() > 0){
		return true;
	}
	return false;
}
