#include "misc.h"
#include "misc.m"
#include <dialog.h>


static bool batchmode = false;
/*
	Control the error message handling (interactive or on stderr)
*/
void error_setmode (bool batch)
{
	batchmode = batch;
}


/*
	Print an error message in a popup
*/
static void xconf_msg (
	const char *title,
	const char *icon,
	const char *msg,
	va_list list)
{
	if (!batchmode) dialog_clear();
	if (batchmode || !dialog_uiok()){
		fprintf (stderr,"%s\n",title);
		vfprintf (stderr,msg,list);
		fputs ("\n",stderr);
	}else{
		char buf[2000];
		vsnprintf (buf,sizeof(buf)-1,msg,list);
		html_setpopup();
		dialog_msgbox ((char*)title,buf,icon);
	}
}
/*
	Print an error message in a popup
*/
void xconf_error (const char *msg, ...)
{
	va_list list;
	va_start (list,msg);
	xconf_msg (MSG_U(T_ERROR,"Error"),MSG_U(I_ICONERROR,"Error"),msg,list);
	va_end (list);
}

/*
	Print a notice to the user.
*/
void xconf_notice (const char *msg, ...)
{
	va_list list;
	va_start (list,msg);
	xconf_msg (MSG_U(T_PLEASE,"Please note")
		,MSG_U(I_ICONNOTICE,"Notice"),msg,list);
	va_end (list);
}

