/*
	This program is there to intercept and log all traffic between
	linuxconf and remadmin
*/
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

static void guispy_copy (int in, int out, const char *file)
{
	FILE *fout = fopen (file,"w");
	char buf[1000];
	int nb;
	while ((nb=read(in,buf,sizeof(buf)))>0){
		write (out,buf,nb);
		fwrite (buf,1,nb,fout);
		fflush (fout);
	}
	fclose (fout);
	_exit (1);
}

static void usage ()
{
	fprintf (stderr,
		"guispy in.log out.log command args ...\n"
		"\n"
		"guispy spy channel 0 and send a copy to command\n"
		"it also spy channel 1 (output of command) and send\n"
		"this output on its own channel 1.\n"
		"\n"
		"in.log will contain everything received on channel 0\n"
		"out.log will contain everything sent by command on channel 1\n");
}

int main (int argc, char *argv[])
{
	if (argc < 4){
		usage();
	}else{
		int tbin[2];
		int tbout[2];
		if (pipe(tbin)!=-1 && pipe(tbout)!=-1){
			if (fork()==0){
				dup2 (tbin[0],0);
				dup2 (tbout[1],1);
				execv (argv[3],argv+3);
				fprintf (stderr,"Can't exec %s\n",strerror(errno));
				_exit (-1);
			}else if (fork()==0){
				guispy_copy (0,tbin[1],argv[1]);
			}else{
				guispy_copy (tbout[0],1,argv[2]);
			}
		}
	}
	return 0;
}	


