//LabPlot : LImage.h

#ifndef LIMAGE_H
#define LIMAGE_H

#include <qcolor.h>
#include <qpainter.h>
#include <qstringlist.h>
#include "Point.h"

class LImage
{
public:
	LImage(Point p=0, QString n="", double s=1.0, double a=0);
	QStringList Info();
	void save(QTextStream *t);
	void open(QTextStream *t,int version);
	Point Pos() { return pos; }
	void setPos(double x, double y) { pos=Point(x,y);}
	QString Name() { return name; }
	double Scale() { return scale; }
	double Angle() { return angle; }
	void draw(QPainter *p, double w, double h);
	bool inside(int x, int y, int w, int h);
protected:
	Point pos;
	QString name;
	double scale;
	double angle;
};

#endif //LIMAGE_H
