//LabPlot : InterpolationListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <qstring.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qcolordialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "InterpolationListDialog.h"

#ifdef HAVE_GSL
#include <gsl/gsl_spline.h>
#endif

InterpolationListDialog::InterpolationListDialog(Worksheet *p, Spreadsheet *s, const char *name)
	: ListDialog(p, s, name)
{
	setCaption(i18n("Interpolation Dialog"));

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QHBox *hb = new QHBox(tab1);
	new QLabel(i18n(" Type : "),hb);

	typecb = new KComboBox(hb);
	QStringList typelist;
	typelist<<i18n("linear")<<i18n("polynomial")<<i18n("cspline")<<i18n("cspline (periodic)");
	typelist<<i18n("akima")<<i18n("akima (periodic)");
	typecb->insertStringList(typelist);

	hb = new QHBox(tab1);
	new QLabel(i18n(" From : "),hb);
	ale = new KLineEdit(QString("0"),hb);
	ale->setValidator(new QDoubleValidator(ale));
	new QLabel(i18n(" To : "),hb);
	int b=0;
	if(s)
		b=s->Table()->numRows();
	ble = new KLineEdit(QString::number(b),hb);
	ble->setValidator(new QDoubleValidator(ble));
	hb = new QHBox(tab1);
	new QLabel(i18n(" number of points : "),hb);
	nrle = new KLineEdit(QString("100"),hb);
	nrle->setValidator(new QIntValidator(nrle));

	if(p) {
		updateRange();
		QObject::connect(lv,SIGNAL(selectionChanged()),SLOT(updateRange()));
	}
	
	Style style;
	Symbol symbol;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw);
	else
		styletab = simpleStyle(tw,0, &style, &symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void InterpolationListDialog::apply_clicked() {
	// TODO : all selected graphs
#ifdef HAVE_GSL
	double a=(ale->text()).toDouble();
	double b=(ble->text()).toDouble();
	int number = (nrle->text()).toInt();

	gsl_interp_accel *acc = gsl_interp_accel_alloc();

	const gsl_interp_type *type = gsl_interp_linear;
	switch (typecb->currentItem()) {
	case 0: type = gsl_interp_linear;break;
	case 1: type = gsl_interp_polynomial;break;
	case 2: type = gsl_interp_cspline;break;
	case 3: type = gsl_interp_cspline_periodic;break;
	case 4: type = gsl_interp_akima;break;
	case 5: type = gsl_interp_akima_periodic;break;
	}

	if(s) {
		QTable *table = s->Table();
		int col = table->currentColumn();
		int n = table->numRows();
		
		// add column if needed
		bool empty=TRUE;
		for(int i=0;i<n;i++) {
			if(table->text(i,table->numCols()-1).length()>0) {
				empty =FALSE;
			}
		}
		if (!empty)
			s->addColumn();

		double *ax = new double[n];
		double *ay = new double[n];
		for(int i=0;i<n;i++){
			ax[i]=i;
			ay[i]=table->text(i,col).toDouble();
		}

		gsl_spline *spline = gsl_spline_alloc(type, n);
		gsl_spline_init(spline, ax, ay, n);
		
		int newcol = table->numCols()-1;
		for (int i = 0;i<number;i++) {
			
			// insert into last column
			table->setText((int)(i*n/number),newcol,QString::number((double) gsl_spline_eval(spline, i*n/number, acc)));
		}

		gsl_spline_free (spline);
		free(ax);free(ay);

		return;
	}
	
	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->getNumber()==0)
		return;
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	GRAPHType st = gl->getStruct(item);

	if (st == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *data = g->Data();

		double xmin=0, xmax=1, ymin=0, ymax=1;
		Point *ptr = new Point[number];

		double *ax = new double[nx];
		double *ay = new double[nx];
		for(int i=0;i<nx;i++){
			ax[i]=data[i].X();
			ay[i]=data[i].Y();
		}

		gsl_spline *spline = gsl_spline_alloc(type, nx);
		gsl_spline_init(spline, ax, ay, nx);

		for (int i = 0;i<number;i++) {
			double x = a+i/(double)(number-1)*(b-a);
			double y = gsl_spline_eval(spline, x, acc);
			
			// new ranges
			if (i==0) {
				xmin=xmax=x;
				ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}

			ptr[i].setPoint(x,y);
		}

		gsl_spline_free (spline);
		free(ax);free(ay);
		
		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		QString fun = QString(i18n("interpolation of ")+g->Label());

		Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			widthle->text().toInt(),pencb->currentItem(),brushcb->currentItem());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
		
		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,number);
		p->addGraph2D(ng);
	}
	else if (st == GRAPH3D) {
		// TODO
	}
	else if (st == GRAPHM) {
		// TODO
	}

	gsl_interp_accel_free (acc);
	
	updateList();
#else
		KMessageBox::error(this, i18n("Sorry. Your installation doesn't support the GSL!"));
#endif
}
