#include <qapplication.h>
#include <qcanvas.h>
#include <qpainter.h>
//#include <gisdefs.h>
#include "GRASSPainter.h"
#include "GRASSVectorLayer.h"


class QWidgetx:public QWidget
{
	public:
		QWidgetx(QWidget *parent=0,const char *name=0);
};

QWidgetx::QWidgetx(QWidget *parent, const char *name):QWidget(parent, name) {}



int main( int argc, char **argv )
{
    	QApplication a(argc,argv);
	QWidgetx canvas;

	GRASSPainter gPainter("spearfish"); 

	for (int i=2; i < argc; i++) { 
		GRASSVectorLayer* vecLayer = new GRASSVectorLayer(&gPainter, argv[i], ""); 
		vecLayer->drawMode(GRASSVectorLayer::fill); 
		vecLayer->fillColor(Qt::blue); 
		gPainter.addLayer(vecLayer); 
	}
	
	canvas.show();

	a.setMainWidget(&canvas);
	
	QPixmap mapPixmap(800,600); 
	QPainter p; 
	p.begin(&mapPixmap); 
	QRect rect(0,0,800,600); 
	gPainter.paint(rect, &p); 
	p.end(); 
	canvas.setBackgroundPixmap(mapPixmap); 
	
	return a.exec();
}
