/***************************************************************************
                          structdialog.cpp  -  description
                             -------------------
    begin                : Mon Apr 30 2001
    copyright            : (C) 2001 by Brachet Pascal
    email                : pascal.brachet@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "structdialog.h"
#include <klocale.h>

structdialog::structdialog(QWidget *parent, const char *name)
    :KDialogBase( parent, 0L, true, name, Ok | Cancel, Ok )
{
	setCaption(name);
  QWidget *page = new QWidget(this);
  setMainWidget(page);

  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );

  title_edit = new QLineEdit( page, "title_edit" );
  title_edit->setFocusPolicy( QWidget::StrongFocus );
  title_edit->setText( "" );
  title_edit->setMaxLength( 32767 );
  title_edit->setFocus();

  QLabel_1= new QLabel(page,"NoName");
  QLabel_1->setText(i18n("Title :"));

  checkbox = new QCheckBox( page, "checkbox");
  checkbox->setFocusPolicy( QWidget::TabFocus );
  checkbox->setText( i18n("With numeration" ));
  checkbox->setAutoRepeat( FALSE );
  checkbox->setAutoResize( FALSE );
  checkbox->setChecked( TRUE );

  topLayout->addWidget(QLabel_1);
  topLayout->addWidget(title_edit);
  topLayout->addWidget(checkbox);

  resize(250,110);

}

structdialog::~structdialog(){
}

