/* -------------------------- gnuPlotFile class --------------------------
   
   This is a class to create an object to plot datafiles. It contains all
   variables necessary for plotting files and knows how to issue the correct
   command to gnuPlot to plot the file with its options. 

   This file is part of Xgfe: X Windows GUI front end to Gnuplot
   Copyright (C) 1998 David Ishee

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ------------------------------------------------------------------------*/

#include "gnuPlotFile.h"

gnuPlotFile::gnuPlotFile()
{
  filename = "";
  styleType = "points";
  dataSetStart = "";
  dataSetEnd = "";
  dataSetInc = "";
  samplePointInc = "";
  sampleLineInc = "";
  sampleStartPoint = "";
  sampleStartLine = "";
  sampleEndPoint = "";
  sampleEndLine = "";
  fileSmoothType = "none";  
  xColumn = "";
  yColumn = "";
  zColumn = "";
  formatString = "";
  rawFormatString = "";
  styleType = "points";
  legendTitle = "default";
  filter = "";
  filterQuoteChar = "double";
}

string gnuPlotFile::getPlotCmd()
{
  string plotstring;

  if (filter == "")
  {
    // insert filename with quotes
    plotstring += " '";
    plotstring += filename;
    plotstring += "' ";
  }
  else
  {
    if (filterQuoteChar == "single")
      plotstring += "'";
    else if (filterQuoteChar == "double")
      plotstring += '"';
    
    plotstring += "< ";
    plotstring += filter;

    if (filterQuoteChar == "single")
      plotstring += "'";
    else if (filterQuoteChar == "double")
      plotstring += '"';
  }

  // setup datafile modifiers

  // insert "index" command
  if ((dataSetStart != "") && (dataSetEnd != "") && (dataSetInc != ""))
  {
    plotstring += " index ";
    plotstring += dataSetStart;
    plotstring += ":";
    plotstring += dataSetEnd;
    plotstring += ":";
    plotstring += dataSetInc;
  }

  if ((dataSetStart != "") && (dataSetEnd != "") && (dataSetInc == ""))
  {
    plotstring += " index ";
    plotstring += dataSetStart;
    plotstring += ":";
    plotstring += dataSetEnd;
  }
  
  if ((dataSetStart != "") && (dataSetEnd == "") && (dataSetInc == ""))
  {
    plotstring += " index ";
    plotstring += dataSetStart;
  }

  // insert "every" command
  if ((samplePointInc != "") || (sampleLineInc != "") || 
      (sampleStartPoint != "") || (sampleStartLine != "") || 
      (sampleEndPoint != "") || (sampleEndLine != ""))
  {
    if (sampleEndLine != "")
    {
      plotstring += " every ";
      plotstring += samplePointInc;
      plotstring += ":";
      plotstring += sampleLineInc;
      plotstring += ":";
      plotstring += sampleStartPoint;
      plotstring += ":";
      plotstring += sampleStartLine;
      plotstring += ":";
      plotstring += sampleEndPoint;
      plotstring += ":";
      plotstring += sampleEndLine;
    }
    else if (sampleEndPoint != "")
    {
      plotstring += " every ";
      plotstring += samplePointInc;
      plotstring += ":";
      plotstring += sampleLineInc;
      plotstring += ":";
      plotstring += sampleStartPoint;
      plotstring += ":";
      plotstring += sampleStartLine;
      plotstring += ":";
      plotstring += sampleEndPoint;
    }
    else if (sampleStartLine != "")
    {
      plotstring += " every ";
      plotstring += samplePointInc;
      plotstring += ":";
      plotstring += sampleLineInc;
      plotstring += ":";
      plotstring += sampleStartPoint;
      plotstring += ":";
      plotstring += sampleStartLine;
    }
    else if (sampleStartPoint != "")
    {
      plotstring += " every ";
      plotstring += samplePointInc;
      plotstring += ":";
      plotstring += sampleLineInc;
      plotstring += ":";
      plotstring += sampleStartPoint;
    }
    else if (sampleLineInc != "")
    {
      plotstring += " every ";
      plotstring += samplePointInc;
      plotstring += ":";
      plotstring += sampleLineInc;
    }
    else if (samplePointInc != "")
    {
      plotstring += " every ";
      plotstring += samplePointInc;
    }
  }

  // insert using command if columns or format string is specified 
  // and a raw format string is not specified
  if (rawFormatString == "")
  {      
    if ((xColumn != "") || (yColumn != "") || (zColumn != "") || 
        (formatString != ""))
    {
      plotstring += " using ";
      plotstring += xColumn;
      plotstring += ":";
      plotstring += yColumn;
      
      if (zColumn != "")
      {
        plotstring += ":";
        plotstring += zColumn;
      }
      
      plotstring += " ";
      plotstring += formatString;
    }      
  }
  else 
  {
    plotstring += " using ";
    plotstring += rawFormatString;
  }

  // insert "smooth" command
  if (fileSmoothType != "none")
  {
    plotstring += " smooth ";
    plotstring += fileSmoothType;
  }

  // insert title for legend
  if (legendTitle == "notitle")
    plotstring += " notitle";

  if ((legendTitle != "default") && (legendTitle != "notitle"))
  {
    plotstring += " title ";
    plotstring += '"';
    plotstring += legendTitle;
    plotstring += '"';
  }
  
  // insert plotting style
  plotstring += " with ";
  plotstring += styleType;

  return plotstring;
}

void gnuPlotFile::setFilename(string file)
{
  filename = file;
}

string gnuPlotFile::getFilename()
{
  return filename;
}


void gnuPlotFile::setFileStyleType(string type)
{
  styleType = type;
}

string gnuPlotFile::getFileStyleType()
{
  return styleType;
}

void gnuPlotFile::setFileDataSetStart(string start)
{
  dataSetStart = start;
}

string gnuPlotFile::getFileDataSetStart()
{
  return dataSetStart;
}

void gnuPlotFile::setFileDataSetEnd(string end)
{
  dataSetEnd = end;
}

string gnuPlotFile::getFileDataSetEnd()
{
  return dataSetEnd;
}

void gnuPlotFile::setFileDataSetIncrement(string inc)
{
  dataSetInc = inc;
}

string gnuPlotFile::getFileDataSetIncrement()
{
  return dataSetInc;
}

void gnuPlotFile::setFileSampPointInc(string pinc)
{
  samplePointInc = pinc;
}

string gnuPlotFile::getFileSampPointInc()
{
  return samplePointInc;
}

void gnuPlotFile::setFileSampLineInc(string linc)
{
  sampleLineInc = linc;
}

string gnuPlotFile::getFileSampLineInc()
{
  return sampleLineInc;
}

void gnuPlotFile::setFileSampStartPoint(string startp)
{
  sampleStartPoint = startp;
}

string gnuPlotFile::getFileSampStartPoint()
{
  return sampleStartPoint;
}

void gnuPlotFile::setFileSampStartLine(string startl)
{
  sampleStartLine = startl;
}

string gnuPlotFile::getFileSampStartLine()
{
  return sampleStartLine;
}

void gnuPlotFile::setFileSampEndPoint(string endp)
{
  sampleEndPoint = endp;
}

string gnuPlotFile::getFileSampEndPoint()
{
  return sampleEndPoint;
}

void gnuPlotFile::setFileSampEndLine(string endl)
{
  sampleEndLine = endl;
}

string gnuPlotFile::getFileSampEndLine()
{
  return sampleEndLine;
}

void gnuPlotFile::setFileSmoothType(string type)
{
  fileSmoothType = type;
}

string gnuPlotFile::getFileSmoothType()
{
  return fileSmoothType;
}

void gnuPlotFile::setFileXColumn(string column)
{
  xColumn = column;
}

string gnuPlotFile::getFileXColumn()
{
  return xColumn;
}

void gnuPlotFile::setFileYColumn(string column)
{
  yColumn = column;
}

string gnuPlotFile::getFileYColumn()
{
  return yColumn;
}

void gnuPlotFile::setFileZColumn(string column)
{
  zColumn = column;
}

string gnuPlotFile::getFileZColumn()
{
  return zColumn;
}

void gnuPlotFile::setFileFormatString(string format)
{
  formatString = format;
}

string gnuPlotFile::getFileFormatString()
{
  return formatString;
}

void gnuPlotFile::setRawFileFormatString(string format)
{
  rawFormatString = format;
}

string gnuPlotFile::getRawFileFormatString()
{
  return rawFormatString;
}

void gnuPlotFile::setLegendTitle(string title)
{
  legendTitle = title;
}

string gnuPlotFile::getLegendTitle()
{
  return legendTitle;
}

void gnuPlotFile::setFileFilter(string thefilter)
{
  filter = thefilter;
}

string gnuPlotFile::getFileFilter()
{
  return filter;
}

void gnuPlotFile::setFileFilterQuoteChar(string quote)
{
  filterQuoteChar = quote;
}

string gnuPlotFile::getFileFilterQuoteChar()
{
  return filterQuoteChar;
}
