/**********************************************************************

	--- Qt Architect generated file ---

	File: fileOptions.cpp

    This file is part of Xgfe: X Windows GUI front end to Gnuplot
    Copyright (C) 1998 David Ishee

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.       

 *********************************************************************/

#include "fileOptions.h"

#define Inherited fileOptionsData

fileOptions::fileOptions
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "Data File Options" );
}


fileOptions::~fileOptions()
{
}

void fileOptions::setGnuInterface(gnuInterface* gnu)
{
  gnuInt = gnu;
  
  // get options and insert into widgets

  string dataSetStart = gnuInt->getFileDataSetStart();
  string dataSetEnd = gnuInt->getFileDataSetEnd();
  string dataSetInc = gnuInt->getFileDataSetIncrement();
  string sampPointInc = gnuInt->getFileSampPointInc();
  string sampLineInc = gnuInt->getFileSampLineInc();
  string sampStartPoint = gnuInt->getFileSampStartPoint();
  string sampStartLine = gnuInt->getFileSampStartLine();
  string sampEndPoint = gnuInt->getFileSampEndPoint();
  string sampEndLine = gnuInt->getFileSampEndLine();
  string xCol = gnuInt->getFileXColumn();
  string yCol = gnuInt->getFileYColumn();
  string zCol = gnuInt->getFileZColumn();
  string format = gnuInt->getFileFormatString();
  string rawFormat = gnuInt->getRawFileFormatString();
  string smoothType = gnuInt->getFileSmoothType();

  dataSetStartEdit->setText(dataSetStart.c_str());
  dataSetEndEdit->setText(dataSetEnd.c_str());
  dataSetIncEdit->setText(dataSetInc.c_str());
  pointIncEdit->setText(sampPointInc.c_str());
  lineIncEdit->setText(sampLineInc.c_str());
  startPointEdit->setText(sampStartPoint.c_str());
  startLineEdit->setText(sampStartLine.c_str());
  endPointEdit->setText(sampEndPoint.c_str());
  endLineEdit->setText(sampEndLine.c_str());
  xColumnEdit->setText(xCol.c_str());
  yColumnEdit->setText(yCol.c_str());
  zColumnEdit->setText(zCol.c_str());
  formatEdit->setText(format.c_str());
  rawFormatEdit->setText(rawFormat.c_str());

  if (smoothType == "none")
    interpList->setCurrentItem(0);
  else if (smoothType == "unique")
    interpList->setCurrentItem(1);
  else if (smoothType == "csplines")
    interpList->setCurrentItem(2);
  else if (smoothType == "acsplines")
    interpList->setCurrentItem(3);
  else if (smoothType == "bezier")
    interpList->setCurrentItem(4);
  else if (smoothType == "sbezier")
    interpList->setCurrentItem(5);
}

void fileOptions::setFormat()
{
  string dataSetStart = dataSetStartEdit->text().data();
  string dataSetEnd = dataSetEndEdit->text().data();
  string dataSetInc = dataSetIncEdit->text().data();
  string sampPointInc = pointIncEdit->text().data();
  string sampLineInc = lineIncEdit->text().data();
  string sampStartPoint = startPointEdit->text().data();
  string sampStartLine = startLineEdit->text().data();
  string sampEndPoint = endPointEdit->text().data();
  string sampEndLine = endLineEdit->text().data();
  string xCol = xColumnEdit->text().data();
  string yCol = yColumnEdit->text().data();
  string zCol = zColumnEdit->text().data();
  string format = formatEdit->text().data();
  string rawFormat = rawFormatEdit->text().data();
  string smoothType = interpList->currentText().data();

  gnuInt->setFileDataSetStart(dataSetStart);
  gnuInt->setFileDataSetEnd(dataSetEnd);
  gnuInt->setFileDataSetIncrement(dataSetInc);
  gnuInt->setFileSampPointInc(sampPointInc);
  gnuInt->setFileSampLineInc(sampLineInc);
  gnuInt->setFileSampStartPoint(sampStartPoint);
  gnuInt->setFileSampStartLine(sampStartLine);
  gnuInt->setFileSampEndPoint(sampEndPoint);
  gnuInt->setFileSampEndLine(sampEndLine);
  gnuInt->setFileXColumn(xCol);
  gnuInt->setFileYColumn(yCol);
  gnuInt->setFileZColumn(zCol);
  gnuInt->setFileFormatString(format);
  gnuInt->setRawFileFormatString(rawFormat);
  gnuInt->setFileSmoothType(smoothType);

  QDialog::accept();
}
