\
\ histogram.4th
\
\  Bin a series of values to create a histogram. 
\
\  Copyright (c) 1998 Krishna Myneni, Provided under the terms
\  of the GNU General Public License.
\
\  Last Revised: 4-16-2000
\
\  Requires:
\
\	matrix.4th
\
\  Usage:
\
\  The values are entered onto the stack as a series of floating point 
\  numbers followed by the integer count (denoted by 'frc'), followed by the 
\  desired bin width, i.e.:
\
\	f1 f2 ... fn n fwidth histogram
\
\  The number of bins created is stored in the variable nbins, and
\  the histogram values are in the integer matrix hist_array. Print
\  the matrix by
\
\	hist_array mat.
\
\  A horizontal text plot of the histogram can be made by typing 
\
\	show_histogram
\

\ include matrix

1024 constant MAX_BINS
create hist_array MAX_BINS cells 8 + allot  \ integer matrix to hold histogram
1 1 hist_array mat_size!

fvariable hmax		\ max of data
fvariable hmin		\ min of data
fvariable hwidth	\ bin width
variable nbins		\ number of bins

\ The word histogram bins the data on the stack with the specified bin width
	
: histogram ( frc fwidth -- )
	hwidth f! 
	frc_dup frc_max hmax f!
	frc_dup frc_min hmin f!   

	hmax f@ hmin f@ f- hwidth f@ f/		\ compute number of bins
	f>s 1+ dup nbins !			\ needed

	MAX_BINS > if
	  cr ." Width is too small -- Too many bins required!" cr exit
	then

	nbins @ 1 hist_array mat_size!		\ resize histogram array 
	hist_array mat_zero			\ clear histogram array

	0 do
	  hmin f@ f- hwidth f@ f/ f>s 1+ 	\ compute bin number
	  1 hist_array mat_addr			\ address of bin
	  1 swap +!				\ increment the bin count
	loop
;

: show_histogram ( -- )
	cr
	." 1___5____10" cr
	nbins @ dup 0> if 
	  0 do 
	    i 1+ 1 hist_array mat@
	    dup 0> if 0 do 42 emit loop else drop then cr
	  loop
	else
	  drop
	then ;


	  	






