package jfractionlab.worksheets;

import java.io.File;
import java.util.ArrayList;

import jfractionlab.JFractionLab;

public class AdditionWSGenerator extends WorkSheetGenerator {
	
	private ArrayList<AdditionExcercise> al_excercises;
	
	public AdditionWSGenerator(File file) {
		super(lang.Messages.getString("add_fractions"));
		al_excercises = new ArrayList<AdditionExcercise>();
		al_solutionLine = new ArrayList<String>();
		mkExcercises(nb_of_excercises,10);
		generateText();
		writeFiles(file);
//		writeFile(
//				new File(file.getAbsolutePath() + "_" + lang.Messages.getString("excercises.tex")),
//				al_excercisesText
//		);
//		writeFile(
//				new File(file.getAbsolutePath() + "_" + lang.Messages.getString("solutions.tex")),
//				al_solutionsText
//		);
	}//Constructor
	
	@Override
	protected void mkExcercises(int nb, int max){
		for (int i = 0; i<nb; i++){
			al_excercises.add(new AdditionExcercise(max));
		}//for
	}//mkFractions
	
	@Override
	protected String writeOneLine(boolean isExcercise, int nb) {
		String strReturn = "";
		int n1 = al_excercises.get(nb).getN1();
		int d1 = al_excercises.get(nb).getD1();
		int n2 = al_excercises.get(nb).getN2();
		int d2 = al_excercises.get(nb).getD2();
		int lcd1 = al_excercises.get(nb).getLCD();
		int n3 = al_excercises.get(nb+1).getN1();
		int d3 = al_excercises.get(nb+1).getD1();
		int n4 = al_excercises.get(nb+1).getN2();
		int d4 = al_excercises.get(nb+1).getD2();
		int lcd2 = al_excercises.get(nb+1).getLCD();
		if(isExcercise){
			strReturn += String.valueOf(nb+1);
			strReturn += "&"; //-----------------------
			strReturn += "$\\frac{"+n1+"}{"+d1+"}";
			strReturn += " + ";
			strReturn += "\\frac{"+n2+"}{"+d2+"}$";
			strReturn += " =";
			strReturn += "&"; //-----------------------
			strReturn += String.valueOf(nb+2);
			strReturn += "&"; //-----------------------
			strReturn += "$\\frac{"+n3+"}{"+d3+"}";
			strReturn += " + ";
			strReturn += "\\frac{"+n4+"}{"+d4+"}$";
			strReturn += " =\\\\";
		}else{
			int cn1, cn2;
			strReturn += String.valueOf(nb+1);
			strReturn += "&"; //-----------------------
			strReturn += "$\\frac{"+n1+"}{"+d1+"}";
			strReturn += " + ";
			strReturn += "\\frac{"+n2+"}{"+d2+"}$";
			strReturn += " = ";
			cn1 = lcd1/d1*n1;
			cn2 = lcd1/d2*n2;
			strReturn += "$\\frac{"+cn1+" + "+cn2+"}{"+lcd1+"}$ = ";
			strReturn += writeResult(cn1, cn2, lcd1);
			strReturn += "&"; //-----------------------
			strReturn += String.valueOf(nb+2);
			strReturn += "&"; //-----------------------
			strReturn += "$\\frac{"+n3+"}{"+d3+"}";
			strReturn += " + ";
			strReturn += "\\frac{"+n4+"}{"+d4+"}$";
			strReturn += " = ";
			cn1 = lcd2/d3*n3;
			cn2 = lcd2/d4*n4;
			strReturn += "$\\frac{"+cn1+" + "+cn2+"}{"+lcd2+"}$ = ";
			strReturn += writeResult(cn1, cn2, lcd2);
			strReturn += "\\\\";
		}
		return strReturn;
	}
	
	private String writeResult(int n1, int n2, int lcd){
		String strReturn ="";
		String strBla = "";
		int n = n1+n2;
		int ggt = JFractionLab.ggt(n, lcd);
		strReturn += "$\\frac{";
		strReturn += String.valueOf(n);
		strReturn += "}{";
		strReturn += String.valueOf(lcd);
		strReturn += "}$";
		strBla = strReturn;
		if(n < lcd){
			if(n != n/ggt){
				strBla = "$\\frac{";
				strBla += String.valueOf(n/ggt);
				strBla += "}{";
				strBla += String.valueOf(lcd/ggt);
				strBla += "}$";
				strReturn += " = "+strBla;
			}
		}else if (n > lcd){
			int n_reduced = n;
			int lcd_reduced = lcd;
			
			if(n != n/ggt){
				n_reduced = n/ggt;
				lcd_reduced = lcd/ggt;
				strBla = "$\\frac{";
				strBla += String.valueOf(n_reduced);
				strBla += "}{";
				strBla += String.valueOf(lcd_reduced);
				strBla += "}$";
				strReturn += " = "+strBla;
			}
			strBla = String.valueOf(n_reduced/lcd_reduced);
			strBla += "$\\frac{";
			strBla += String.valueOf(n_reduced%lcd_reduced);
			strBla += "}{";
			strBla += lcd_reduced;
			strBla += "}$";
			strReturn += " = "+strBla;
		}else if(n == lcd){
			strBla = "1";
			strReturn += " = "+strBla;
		}
		al_solutionLine.add(strBla);
		return strReturn;
	}
}