#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <stdarg.h>

#include "error.h"

#ifndef _DEBUG
#define MEMLOG(x)
#else
void MEMLOG(char *s, ...)
{
        va_list ap;
        FILE *fh = fopen("log.log", "a+");
        if (!fh)
                error_exit("error logging\n");

        va_start(ap, s);
        vfprintf(fh, s, ap);
        va_end(ap);

        fclose(fh);
}

typedef struct
{
	void *p;
	char *descr;
	int size;
} memlist;
memlist *pm = NULL;
int n_pm = 0;

void dump_mem(int sig)
{
	int loop;

	signal(SIGHUP, dump_mem);

	if (sig != SIGHUP)
		error_exit("dump_mem: unexpected signal %d for dump_mem\n", sig);

	MEMLOG("%d elements of memory used\n", n_pm);
	for(loop=0; loop<n_pm; loop++)
	{
		MEMLOG("%06d] %p %d (%s)\n", loop, pm[loop].p, pm[loop].size, pm[loop].descr);
	}
	MEMLOG("--- finished memory dump\n");
}

int remove_mem_element(void *p)
{
	int old_size = 0;

	if (p)
	{
		int loop;

		for(loop=0; loop<n_pm; loop++)
		{
			if (pm[loop].p == p)
			{
				int n_to_move;

				old_size = pm[loop].size;

				n_to_move = (n_pm - loop) - 1;
				if (n_to_move > 0)
					memmove(&pm[loop], &pm[loop + 1], n_to_move * sizeof(memlist));
				else if (n_to_move < 0)
					error_exit("remove_mem_element: n_to_move < 0!\n");
				n_pm--;
				loop=-1;

				break;
			}
		}

		if (loop != -1)
		{
			MEMLOG("remove_mem_element: pointer %p not found\n", p);
		}

		if (n_pm)
		{
			pm = (memlist *)realloc(pm, sizeof(memlist) * n_pm);
			if (!pm) error_exit("remove_mem_element: failed to shrink memorylist to %d elements\n", n_pm);
		}
		else
		{
			free(pm);
			pm = NULL;
		}
	}

	return old_size;
}
void add_mem_element(void *p, int size, char *what)
{
	pm = (memlist *)realloc(pm, sizeof(memlist) * (n_pm + 1));
	if (!pm) error_exit("add_mem_element: failed to grow memorylist from %d elements\n", n_pm);
	pm[n_pm].p = p;
	pm[n_pm].size = size;
	pm[n_pm].descr = what;
	n_pm++;
}
#endif

void myfree(void *p)
{
#ifdef _DEBUG
	int old_size = remove_mem_element(p);

	MEMLOG("myfree: %p (%d bytes)\n", p, old_size);
#endif
	free(p);
}

void * myrealloc(void *oldp, int new_size, char *what)
{
#ifdef _DEBUG
	int old_size;
	void *newp;
/*	static int rand_val;
	char rand_val_init = 0;
	int rand_size;

	if (!rand_val_init)
	{
		srand48((int)time(NULL) + (int)getpid());
		rand_val_init = 1;
	}
	do
	{
		rand_val = lrand48();
	}
	while(rand_val == 0);
*/

	newp = realloc(oldp, new_size);
	if (!newp)
		error_exit("myrealloc: failed to reallocate to %d bytes for %s\n", new_size, what);
	old_size = remove_mem_element(oldp);
	MEMLOG("myrealloc(%s): %p (%d -> %d bytes)\n", what, oldp, old_size, new_size);
	add_mem_element(newp, new_size, what);
	signal(SIGHUP, dump_mem);

/*	rand_size = new_size - old_size;
	if (rand_size > 0)
	{
		MEMLOG("randomizing(%s) %d bytes\n", what, rand_size);
		memset(&((char *)newp)[old_size], rand_val, rand_size);
	}
*/
#else
	/* ----------------------------------------------------
	 * add code for repeatingly retry? -> then configurable
	 * via configurationfile with number of retries and/or
	 * sleep
	 * ----------------------------------------------------
	 */
	void *newp = realloc(oldp, new_size);
	if (!newp)
		error_exit("myrealloc: failed to reallocate to %d bytes for %s\n", new_size, what);
#endif

	return newp;
}

void * mymalloc(int size, char *what)
{
	return myrealloc(NULL, size, what);
}

char * mystrdup(char *in, char *what)
{
	int len = strlen(in) + 1;
	char *newp = (char *)mymalloc(len, what);

	memcpy(newp, in, len);

	return newp;
}
