#!/usr/bin/perl 

# configurable part

my $program  = 'Html2Wml';
my $progfile = 'html2wml.cgi';

# end configuration


sub fatal { print @_; exit -1; }
sub nonfatal { print @_ }

if($] < 5.004) {
    fatal("Your version of Perl ($]) is too old. \n", 
          "Please upgrade to version 5.004 or later. \n");
}

open(FILE, $progfile) 
  || fatal("Can't open program file. Check if your archive is correct. \n");

my %modules = ();

while(<FILE>) {
    chop;
    
    ## end of code section
    if(/^__END__/) { last }
    if(/^__DATA__/) { last }
    
    ## skip POD sections
    if(/^=head/) {
        do { $_ = <FILE> } until(/^=cut/)
    }
    
    if(/^\s*(use|require) +([\w:]+)/) { $modules{$2} = $1 }
}

close(FILE);

for my $module (keys %modules) {
    eval "$modules{$module} $module";
    if($@) {
        if($modules{$module} eq 'use') {
            fatal("Perl module $module is needed to use $program. \n")
        } else {
            nonfatal("Perl module $module is not installed. \n", 
                     "Some fonctionalities of Html2Wml won't be available. \n")
        }
    }
}

exit 0;

