
 /***************************************************************************/

/*
 * Portions Copyright (c) 1999 GMRS Software GmbH
 * Carl-von-Linde-Str. 38, D-85716 Unterschleissheim, http://www.gmrs.de
 * All rights reserved.
 *
 * Author: Arno Unkrig <arno@unkrig.de>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by GMRS Software GmbH.
 * 4. The name of GMRS Software GmbH may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY GMRS SOFTWARE GMBH ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GMRS SOFTWARE GMBH BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

 /***************************************************************************/
 
/*
 * Changes to version 1.2.2 were made by Martin Bayer <mbayer@zedat.fu-berlin.de>
 * Date and reason of last modification: Fre Jun  8 17:24:35 CEST 2001 - new method
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the file
 * COPYING for more details.
 */

 /***************************************************************************/


#include <ctype.h>
#include <iostream.h>

#include "Properties.h"

/* ------------------------------------------------------------------------- */

const char *
Properties::getProperty(const char *key, const char *dflt) const
{
  map<string, string>::const_iterator i;
  i = property_map.find(key);
  return i == property_map.end() ? dflt : (*i).second.c_str();
}

// neue Methode fuer leere Attribute - Johannes Geiger

const char *
Properties::getProperty(const char *key) const
{
  map<string, string>::const_iterator i;
  i = property_map.find(key);
  return i == property_map.end() ? NULL : (*i).second.c_str();
}

/* ------------------------------------------------------------------------- */

void
Properties::load(istream &is)
{
  string key, value;
  while (readProperty(is, &key, &value)) setProperty(key, value);
}

/* ------------------------------------------------------------------------- */

/*
 * Expand the escape sequence at "line[pos]". Backslash-Newline reads another
 * line from "is".
 */
static void
expandEscape(string *line_in_out, string::size_type *pos_in_out, istream &is)
{
  for (;;) {
    if (line_in_out->at(*pos_in_out) != '\\') { ++*pos_in_out; return; }
    if (*pos_in_out != line_in_out->size() - 1) break;

    string tmp;
    if (!getline(is, tmp)) {++*pos_in_out; return; }
    int j;
    for (j = 0; j < tmp.size() && isspace(tmp[j]); ++j);
    line_in_out->replace(
      *pos_in_out, string::npos,
      tmp, j, string::npos
    );
  }

  char c = line_in_out->at(*pos_in_out + 1);
  switch (c) {
  case 't': c = '\t'; break;
  case 'n': c = '\n'; break;
  case 'r': c = '\r'; break;
  }
  line_in_out->replace(*pos_in_out, 2, &c, 1);
  ++*pos_in_out;
}

/*static*/ bool
Properties::readProperty(istream &is, string *key_return, string *value_return)
{
  string            line;
  string::size_type i, l;

  // Skip empty and comment lines.
  for (;;) {
    if (!getline(is, line)) return false;
    l = line.size();

    // Skip leading white-space.
    for (i = 0; i < l && isspace(line[i]); ++i);
    if (i == l) continue;                // Line contains only white-space.

    // Ignore comment lines.
    if (line[i] == '#' || line[i] == '!') continue; // Comment line.

    break;
  }

  // Parse key.
  string::size_type bok = i;
  while (i < line.size()) {
    char c = line[i];
    if (isspace(c) || c == '=' || c == ':') break;
    expandEscape(&line, &i, is);
  }
  string::size_type eok = i;

  // Skip key terminator.
  while (i < l && isspace(line[i])) ++i;
  if (i < l && (line[i] == '=' || line[i] == ':')) {
    for (++i; i < l && isspace(line[i]); ++i);
  }

  // Substitute escape sequences in value.
  string::size_type bov = i;
  while (i < line.size()) expandEscape(&line, &i, is);

  // Return key and value.
  key_return->assign(line, bok, eok - bok);
  value_return->assign(line, bov, string::npos);
  return true;
}

/* ------------------------------------------------------------------------- */

