/* GNOME Transcript
 * Copyright (C) 1999-2000 the Free Software Foundation
 * Authors : Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include <gtrans_ifase/gtrans_ifase.h>
#include "gtrans_conn_list.h"
#include "gtrans_db_editor.h"
#include "gtrans_error_dialog.h"
#include "gtrans_create_table.h"
#include "gtrans_edit_table.h"
#include "gtrans_drop_table.h"



extern GtkWidget    *conn_list;



/**
 * gtrans_edit_db_refresh
 */
static void
gtrans_edit_db_refresh(GTransDbEditor *gde)
{
	GTransIFaseResult  *res;
	
	res = gtrans_ifase_exec_list_tables(gde->conn);
	
	if (gtrans_ifase_result_status(res)){
		gtrans_error_dialog(gtrans_ifase_result_error_msg(res));
		gtrans_ifase_result_free(res);
		return;
	}	
	
	gtrans_db_editor_refresh(gde,res);
	gtrans_ifase_result_free(res);
}




/**
 * gtrans_edit_db_new_table:
 * @gde : The Database Editor
 *
 * Stars the table designer to create a new table.
 */
static void
gtrans_edit_db_new_table(GTransDbEditor  *gde)
{
	gtrans_create_table(gde);
}




/**
 * gtrans_edit_db_open_table
 * @gde : The Database Editor
 *
 * Open the contents of a table for editing.
 */
static void
gtrans_edit_db_open_table(GTransDbEditor  *gde)
{
	gtrans_edit_table(gde);
}





/**
 * gtrans_edit_db_drop_table
 * @gde : The Database Editor
 *
 * Drops the table selected in @gde from the database.
 */
static void
gtrans_edit_db_drop_table(GTransDbEditor  *gde)
{
	gtrans_drop_table(gde);
}





/**
 * gtrans_edit_db_close:
 * @widget : The Database Editor
 *
 * Close the database editor.
 */
static void
gtrans_edit_db_close(GtkWidget          *gde,
		     GTransConnListItem *item)
{
	item->gde = NULL;
	gtk_widget_destroy(gde);
}




/*
 * gtrans_edit_db_start_editor
 * @conn : Connection to a database backend
 *
 * Starts the GTransDbEditor arrownd the database backend @conn.
 */
void
gtrans_edit_db_start_editor(GTransConnListItem *item)
{
	GtkWidget         *gde;
	GTransIFaseConn   *conn;
	GTransIFaseResult *res;
	
	conn = item->conn;
	gde = gtrans_db_editor_new(conn);
	item->gde = gde;
	
	res = gtrans_ifase_exec_list_tables(conn);
	if (gtrans_ifase_result_status(res)){
		gtrans_error_dialog(gtrans_ifase_result_error_msg(res));
		gtrans_ifase_result_free(res);
		return;
	}	
	
	gtrans_db_editor_fill_with_tables(GTRANS_DB_EDITOR(gde),res);
	gtrans_ifase_result_free(res);
	
	
	gtk_signal_connect_object(GTK_OBJECT(gde),"open_table",
				  GTK_SIGNAL_FUNC(gtrans_edit_db_open_table),
				  GTK_OBJECT(gde));
	
	gtk_signal_connect_object(GTK_OBJECT(gde),"new_table",
				  GTK_SIGNAL_FUNC(gtrans_edit_db_new_table),
				  GTK_OBJECT(gde));
	
	gtk_signal_connect_object(GTK_OBJECT(gde),"del_table",
				  GTK_SIGNAL_FUNC(gtrans_edit_db_drop_table),
				  GTK_OBJECT(gde));
	
	gtk_signal_connect_object(GTK_OBJECT(gde),"refresh",
				  GTK_SIGNAL_FUNC(gtrans_edit_db_refresh),
				  GTK_OBJECT(gde));

	gtk_signal_connect(GTK_OBJECT(gde),"close",
			   GTK_SIGNAL_FUNC(gtrans_edit_db_close),
			   (gpointer) item);

	gtk_widget_show(gde);
}




/*
 * gtrans_edit_db_selected
 *
 * Starts the GTransDbEditor arrownd the selected database.
 */
void
gtrans_edit_db_selected()
{
	GTransConnListItem *item;
	
	item = gtrans_conn_list_selected(conn_list);
	if (item == NULL){
		gtrans_error_dialog(GTransErrorMsg[GTRANS_ERROR_SELECT_DB]);
		return;
	}
	
	if (item->gde != NULL)
		return;
	
	gtrans_edit_db_start_editor(item);
}




/*
 * gtrans_edit_db
 *
 * Just call the above.
 */
void
gtrans_edit_db(GtkWidget     *widget,
	       gpointer       data)
{
	gtrans_edit_db_selected();
}

