/* GNOME Transcript
 * Copyright (C) 1999-2000 the Free Software Foundation
 * Authors : Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include <gtrans_ifase/gtrans_ifase.h>
#include "gtrans_db_editor.h"
#include "gtrans_error_dialog.h"




/**
 * gtrans_drop_table_confirm:
 * @tname : The name of the table to drop 
 *
 * Returns 0 (YES button pos) if confirmation was made. 
 */
gint 
gtrans_drop_table_confirm(gchar *tname)
{
	GtkWidget  *dlg;
	gchar      *msg;
		
	msg = g_strdup_printf(_("\nDrop table '%s' ?\n"),tname);
	
	dlg = gnome_message_box_new(msg,GNOME_MESSAGE_BOX_QUESTION,
				    GNOME_STOCK_BUTTON_YES,
				    GNOME_STOCK_BUTTON_NO,
				    NULL);
	
	GTK_WINDOW(dlg)->position = GTK_WIN_POS_MOUSE;
	
	g_free(msg);
	
	return gnome_dialog_run_and_close(GNOME_DIALOG(dlg));
}




/**
 * gtrans_drop_table:
 * @gde : The GTransTableEditor
 *
 * Drop the table selected in @gde from the database.
 */
void
gtrans_drop_table(GTransDbEditor *gde)
{
	GTransIFaseResult  *res;
	gint                ipos;
	gchar              *tname;
	
	tname = (gchar *)gde->table_idata;
	if (!tname){
		gtrans_error_dialog(GTransErrorMsg[GTRANS_ERROR_SELECT_TABLE_DEL]);
		return;
	}
	
	if (gtrans_drop_table_confirm(tname) != 0)
		return;
	
	res = gtrans_ifase_exec_drop_table(gde->conn,tname);
	if (gtrans_ifase_result_status(res)){
		gtrans_error_dialog(gtrans_ifase_result_error_msg(res));
		return;
	}	
	
	ipos  = gde->table_ipos;
	gtrans_db_editor_remove_table(GTRANS_DB_EDITOR(gde),ipos);
}
