/*
 * GUI status-bar module
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <gnome.h>
#include "diff.h"
#include "gui.h"
#include "gdwin.h"


/**
 * statusbar_create:
 **/
void
statusbar_create(GDiffWindow *gdwin)
{
	GtkWidget *statusbar;
	
	statusbar = gnome_appbar_new(FALSE, TRUE, GNOME_PREFERENCES_USER);
	gnome_app_set_statusbar(gdwin->app, statusbar);
}

/**
 * statusbar_update:
 * 'default' implies that the message will remains on status-bar.
 **/
void
statusbar_update(GDiffWindow *gdwin, const char *msg)
{
	gnome_appbar_set_default(GNOME_APPBAR(gdwin->app->statusbar), msg);
}



/**
 * sbar_create_msg:
 * Using file names and line numbers, make a message for status-bar.
 * Returned buffer should be freed by the caller.
 * If begins is NULL, ignore it.
 * Input:
 * int num; the number of files. 2 or 3.
 * const char *fnames; an array of file names.
 * const int *begins; an array of begin line number.
 * const int *ends; an array of end line number.
 **/
char*
sbar_create_msg(int num, const char **fnames, const int *begins, const int *ends)
{
	char *msg;

	g_assert(num == 2 || num == 3);
	if (begins == NULL) {
		if (num == 2)
			msg = g_strdup_printf("%s : %s", fnames[0], fnames[1]);
		else
			msg = g_strdup_printf("%s : %s : %s", fnames[0], fnames[1], fnames[2]);
	} else {
		if (num == 2)
			msg = g_strdup_printf("%s [%d - %d] : %s [%d - %d]",
								  fnames[0], begins[0], ends[0],
								  fnames[1], begins[1], ends[1]);
		else
			msg = g_strdup_printf("%s [%d - %d] : %s [%d - %d] : %s [%d - %d]",
								  fnames[0], begins[0], ends[0],
								  fnames[1], begins[1], ends[1],
								  fnames[2], begins[2], ends[2]);
	}
	return msg;
}
