/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  extra-widgets.c: Functions to create embeddable and reusable widgets.

  Copyright (C)  2001-2003  Alexandru Csete.

  Authors:   Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <gnome.h>
#include "extra-widgets.h"

const gchar *gfx_filter_desc[] = {
	N_("Automatic from extension"),
	"PNG", "JPEG", "GIF", "PCX",
	"TIFF", "BMP", "WMF", "XPM", "XBM",
	"PNM", "HRZ", "PAT", "PSP", "PSD",
	"SGI", "TGA", "XWD"
};

const gchar *gfx_filter_ext[] = {
        NULL,
	"png", "jpg", "gif", "pcx",
	"tif", "bmp", "wmf", "xpm", "xbm",
	"pnm", "hrz", "pat", "psp", "psd",
	"sgi", "tga", "xwd"
};


GtkWidget *filesel_graphic_filter ()
{
	/* This function creates a GtkOptionMenu containing
	   valid image file extensions. Used as filter in the
	   image file selector dialog.
	*/
	GtkWidget *optionmenu,*menu,*item;
	guint i;

	menu = gtk_menu_new ();
	for (i=0; i<GFX_FILTER_NUM; i++) {
		item = gtk_menu_item_new_with_label (gfx_filter_desc[i]);
		gtk_object_set_data (GTK_OBJECT (item), "filter", GUINT_TO_POINTER (i));
		gtk_menu_append (GTK_MENU (menu), item);
	}

	optionmenu = gtk_option_menu_new ();
	gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), menu);
	return optionmenu;
}
	   
