#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# qt/ToolBar.py
#
# DESCRIPTION:
# NOTES:
#

import string, sys
from qt import *
from gnue.forms.uidrivers._commonGuiToolkit.ToolBar import ToolBar as _BaseToolBar

class ToolBar(_BaseToolBar):

  # Create the menu
  def init(self):
    self.toolbar = QToolBar(_("Forms Navigation"), self.container)
    self.toolbar.show()
    return self.toolbar

  # Add a menu item (action)
  def addAction(self, name, userAction):
    iconloc = userAction.getIconLocation(size="24x24")
    grayloc = userAction.getIconLocation(size="24x24-gray")

    # Set the action icon if available
    if iconloc:
      try:
        # Some caching logic for faster second/third forms
        icon = _cachedIcons[iconloc]
      except KeyError:
        icon = QIconSet(QPixmap(iconloc))
        _cachedIcons[iconloc] = icon
        if grayloc:
          icon.setPixmap(QPixmap(grayloc), QIconSet.Normal, QIconSet.Disabled)
        else:
          print "** WARNING: No gray version of '%s' to toolbar; no icon" % userAction.event

    else:
      print "** WARNING: Cannot add '%s' to toolbar; no icon" % userAction.event
      return

    action = QAction(self.toolbar, name)
    action.setIconSet(icon)
    action.setText(name)
    if userAction.canToggle:
      action.setToggleAction(True)

    # Set popup tooltip
    try:
      action.setToolTip(userAction.help)
    except AttributeError:
      action.setToolTip(userAction.description)


    # Set status tip   TODO: Doesn't seem to do anything
    try:
      action.setStatusTip(userAction.description)
    except AttributeError:
      pass

    # Connect to the events
    event = 'request%s' % userAction.event
    function = '_%s_activate' % id(action)
    if userAction.canToggle:
      self.__dict__[function] = lambda state, l=self.driver, \
              e=event, a=action, \
              te='request%s' % userAction.canToggle, \
              f=self.form: l.dispatchEvent(state and e or te,_form=f)

      QObject.connect(action, SIGNAL('toggled(bool)'),self.__dict__[function])
    else:
      self.__dict__[function] = lambda l=self.driver, e=event, f=self.form: l.dispatchEvent(e,_form=f)
      QObject.connect(action, SIGNAL('activated()'), self.__dict__[function])

    # Add ourself to toolbar
    action.addTo(self.toolbar)

    return action


  # Add a separator
  def addSeparator(self):
    self.toolbar.addSeparator()

  # Enable a menu item
  def enableItem(self, item):
    item.setEnabled(True)

  # Disable a menu item
  def disableItem(self, item):
    item.setEnabled(False)

  def startingItem(self, item):
    item.setOn(True)

  def endingItem(self, item):
    item.setOn(False)

  # A menu item was selected
  def __itemSelected(self, itemid):
    print "foobar"
    self.driver.dispatchEvent(self.__idmap[itemid], _form=self.form)


_cachedIcons = {}
