#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# gtk2/widgets/component.py
#
# DESCRIPTION:
# A part of a gtk2 based user interface driver for GNUe forms.
#
# NOTES:
#
import gtk
import bonobo
import bonobo.ui

from gnue.forms.uidrivers.gtk2.widgets._base import UIHelper

#
# UIComponent
#
# Widget set that implements a Bonobo Container
#
class UIComponent(UIHelper):

  def _createWidget(self, event, spacer):
    object = event.object

    oafiid = ""

    # TODO: for nomal mime-types do a specify and standart (text/*) search
    query = "has(bonobo:supported_mime_types, '%s')" % object.mimetype +\
            "AND has(repo_ids,'IDL:Nautilus/View:1.0')"
    list = bonobo.activation.query(query)
    for i in list:
      oafiid=i.iid    
      
    if len(oafiid)<1:
      raise "Mimetype not supported"

    container = bonobo.ui.Container()

    self.control = bonobo.ui.Widget(oafiid, container.corba_objref())
    
#    self.pane = gtk.ScrolledWindow()
#    self.pane.add_with_viewport(self.control)
    self.pane = self.control
    
    self.pane.set_size_request(self.itemWidth, self.itemHeight)

    event.container.put(self.pane, object.Char__x * event.widgetWidth,
                        (object.Char__y + spacer) * event.widgetHeight)
    return self.control


    
  def setValue(self, value, index=0, enabled=1):
    widget = self.widgets[index]
    try:
      obj = widget.get_objref().queryInterface("IDL:Nautilus/View:1.0")
      
      # TODO: 1. relative paths don't work.
      #       2. try to implement read/write from db too.
      #       3. add persistent file interface
      obj.load_location(value)
      
      obj.unref()
    except:
      pass

  


configuration = {
    'baseClass'  : UIComponent,
    'provides'   : 'GFComponent',
    'container'  : 0,
    }
