#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# GFContainer.py
#
# DESCRIPTION:
"""
A base class for all GFObjects that can be containers
"""

from GFObj import GFObj
from GFTabStop import GFTabStop

class GFContainer(GFObj):
  def __init__(self, parent=None, type='GFContainer'):
    GFObj.__init__(self, parent, type)


  # Build a "focus order" from all our children
  # (and, recursively, any child containers)
  # TODO: This assumes sane focusstop values; no sanity checks!
  def getFocusOrder(self, list=None):
    specificFocusStops = {}
    allFocusStops = []
    if not list:
      list = self._children
    for child in list:
      if isinstance(child,GFContainer):
        tabStops = child.getFocusOrder()
        if len(tabStops):
          allFocusStops.append(tabStops)
          try:
            specificFocusStops[child.focusorder-1] = tabStops
          except AttributeError:
            pass
      elif isinstance(child,GFTabStop):
        allFocusStops.append([child])
        try:
          specificFocusStops[child.focusorder-1] = [child]
        except AttributeError:
          pass

    rv = [None] * len(allFocusStops)
    for key in specificFocusStops.keys():
      rv.pop(key)
      rv[key:key] = specificFocusStops[key]
      allFocusStops.pop(allFocusStops.index(specificFocusStops[key]))

    focusStop = 0
    maxStops = len(rv)
    while focusStop < maxStops:
      if not rv[focusStop]:
        rv.pop(focusStop)
        rv[focusStop:focusStop] = allFocusStops[0]
        allFocusStops.pop(0)
      focusStop += 1

    return rv
