## ----------------------------------------------------------------------------
##                                                                           --
##                      GNADE  : GNu Ada Database Environment                --
##                                                                           --
##  Filename        : $Source: /var/cvs/gnuada/gnade/win32/support/all_modules.awk,v $
##  Description     : The top level makefile of GNADE
##  Author          : Sune Falk  <sunef@hem.passagen.se>  
##  Created On      : 28-3-2001 
##  Last Modified By: $Author: me $
##  Last Modified On: $Date: 2001/04/01 20:20:51 $
##  Status          : $State: Exp $
##                                                                           --
##  Copyright (C) 2000-2001 Sune Falk
##
##  GNADE is copyrighted by the persons and institutions enumerated in the   --
##  AUTHORS file. This file is located in the root directory of the          --
##  GNADE distribution.                                                      --
##                                                                           --
##  GNADE is free software;  you can redistribute it  and/or modify it under --
##  terms of the  GNU General Public License as published  by the Free Soft- --
##  ware  Foundation;  either version 2,  or (at your option) any later ver- --
##  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
##  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
##  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
##  for  more details.  You should have  received  a copy of the GNU General --
##  Public License  distributed with GNAT;  see file COPYING.  If not, write --
##  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
##  MA 02111-1307, USA.                                                      --
##                                                                           --
##  As a special exception,  if other files  instantiate  generics from      --
##  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
##  files  to produce an executable, these  units or libraries do not by     --
##  itself cause the resulting  executable  to  be covered  by the  GNU      --
##  General  Public  License.  This exception does not however invalidate    --
##  any other reasons why  the executable file  might be covered by the      --
##  GNU Public License.                                                      --
##                                                                           --
##  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
##                                                                           --
## ----------------------------------------------------------------------------
##
##  Functional Description
##  ======================
##
## Generate a dummy program including all specifications in the
## current directory
##
##  produces a new file all_modules.adb
##
BEGIN {
   fn       = "all_modules.adb";
   grep_cmd = "grep -hi \"^package \" *.ads | sort"
   n_lines  = 0;
   print "--" >fn
   print "-- Dummy main for building all packages in the current directory" >fn
   print "--" >fn
   print "-- Created by all_modules.awk " strftime("%Y-%m-%d %H:%M")  >fn;
   print "--" >fn;
   print "\npragma Warnings (Off);\n" >fn;
   
   while (grep_cmd | getline) {
      print "with " $2 ";" >fn;
      n_lines++;
   }
   close (grep_cmd);
   if (!n_lines) {
      close(fn);
      system ("rm " fn);
      print "No file all_modules.adb created";
      exit(1);
   }
   print "--" >fn;
   print "procedure All_Modules is" >fn;
   print "begin"                    >fn;
   print "   null;"                 >fn;
   print "end All_Modules;"         >fn;

   print "Created all_modules.adb";
   exit (0);
}


