--|
--| Filename        : $Source: /var/cvs/gnuada/gnade/esql/esql_parser.ads,v $
--| Description     : Scanner for the embedded SQL translator
--| Author          : Michael Erdmann
--| Created On      : 22.12.2000
--| Last Modified By: $Author: me $
--| Last Modified On: $Date: 2001/05/23 21:11:35 $
--| Status          : $State: Exp $
--|
--| Copyright (C) 2000 Michael Erdmann
--|
--| This program is free software; you can redistribute it and/or
--| modify it under the terms of the GNU General Public License
--| as published by the Free Software Foundation; either version 2
--| of the License, or (at your option) any later version.
--|
--| This program/code is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License along
--| with this program; if not, write to the Free Software Foundation, Inc.,
--| 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--|
--| As a special exception,  if other files  instantiate  generics from this
--| unit, or you link  this unit with other files  to produce an executable,
--| this  unit  does not  by itself cause  the resulting  executable  to  be
--| covered  by the  GNU  General  Public  License.  This exception does not
--| however invalidate  any other reasons why  the executable file  might be
--| covered by the  GNU Public License.
--|
--| Functional Description
--| ======================
--| This package contains the esql parser. The result of the
--| parse process is stored in the ESQL_Reader data. As a consequence
--| the code generation is a part of this package as well.
--|
--|
--| Restrictions
--| ============
--|
--| References
--| ==========
--|
--|

--* Ada

--* Translator packages
with Scanner;

package ESQL_Parser is

   type ESQL_Reader is private;

   Syntax_Exception      : exception ;
   End_Of_File_Exception : exception ;

   --|
   --| Create new instance of the ESQL Parser.
   --|
   function New_ESQL_Parser(
      F : in Scanner.File_Reader ) return ESQL_Reader;

   --|
   --| delete the parser and close all resources
   --|
   procedure Delete_ESQL_Reader(
      E : in out ESQL_Reader );

   --|
   --| Parse the a ESQL Statement. This prepares the data
   --| for the code generation
   --|
   procedure Embedded_SQL_Statement(
      e : in out ESQL_Reader );

   function Number_Of_Errors(
      E : ESQL_Reader ) return Natural;

   function Number_Of_Warnings(
      E : ESQL_Reader ) return Natural;

   -------------------------------------------------------------------------
private
   type ESQL_Reader_Type;
   type ESQL_Reader is access ESQL_Reader_Type;

end ESQL_Parser;


