{ Test of the FileUtils unit }

program FileUtilsTest;

uses GPC, FileUtils;

const
  TestName = 'f_u_test.dat'; { must fit into 8+3 chars }

var
  Called : Boolean = False;
  f : Text;

procedure DoOutput (const s : String);
begin
  if Called then
    begin
      Writeln ('failed: `DoOutput'' called twice');
      Halt
    end;
  if s <> DirSelf + DirSeparator + TestName then
    begin
      Writeln ('failed `', s, '''');
      Halt
    end;
  Called := True
end;

begin
  Rewrite (f, TestName);
  Close (f);
  FindFiles (DirSelf, TestName, False, DoOutput, DoOutput);
  (*@@iocritical*)CheckInOutRes;
  Erase (f);
  if not Called then
    Writeln ('failed: `DoOutput'' not called')
  else
    Writeln ('OK')
end.
