/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PolicyList.hh,v 1.13 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _POLICYLIST_HH
#define _POLICYLIST_HH

#include <gtk--.h>

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/RuleSet.hh"

class PolicyListItem;
class PolicyListElement;

class PolicyList : public Gtk::Table 
{

    friend class PolicyListItem;
    friend class PolicyListElement;

private:

    libfwbuilder::RuleSet   *ruleset;

    gint    x,y,width, height;

    gint    last_x, last_y;
    gint    freeze_count;
    gint    last_w_set, last_h_set;

    gint               current_selected_row;
    PolicyListElement *current_selected;

    bool    rebuild;
    int     activate_r;

  /*
    this does not work in GTK1.2 (see comment in gtk--/table.h):

       Gtk::Table_Helpers::TableList tbl=children();

    will keep track of all children widgets myself
   */
    vector<Gtk::Widget*>  table_children;

    
    void on_changed_event();
    void on_realize_event();
    gint on_button_release_event(GdkEventButton *ev);


    gint rebuild_when_idle();

    void set_data_changed_flag(bool flag);

    Gtk::Widget* _register_child(Gtk::Widget *c);
    void         _add_hseparator(gint row,gint col);
    void         _add_vseparator(gint row,gint col);

    void         __print_children();
    void         on_size_allocate(GtkAllocation *all);

/**
 *  this method copies rule elements from rule src to rule dst. If
 *  some elements are missing, they will be recreated and filled with
 *  default values. This allows for copying rules from Interface
 *  Policy to Global Policy and vice versa
 */
    void         copyRuleContent(libfwbuilder::Rule *dst, libfwbuilder::Rule *src);

public:

    PolicyList(libfwbuilder::RuleSet *p );
    ~PolicyList();

    static gint get_rule_by_row(gint row_n);
    static gint get_row_by_rule_num(gint rule_n);
  
    libfwbuilder::RuleSet*  getRuleSet() { return ruleset; }

    int  getX()      { return x;  }
    int  getY()      { return y;  }
    int  getWidth()  { return width;  }
    int  getHeight() { return height; }

    void Build();
    void Clear();

//    FWObject *getObject() { return object; }

    PolicyListElement *get_element(gint r,gint c);
    void               select_element(gint r,gint c);

    void               deselect_current();
    void               set_current_selected(PolicyListElement *pe);

    void request_focus();

    void move_focus(GtkDirectionType dir);

    void activate_row(gint r);
    void deactivate_row(gint r);
    
    void activate_rule(gint r);
    void deactivate_rule(gint r);

    void schedule_rebuild(int activate_row);

    //  void AddObject(libfwbuilder::FWObject *obj,gint row,gint col);

    void insertRuleAtTop(libfwbuilder::Rule *r=NULL);
    void insertRuleBefore(gint rule_n=-1,libfwbuilder::Rule *r=NULL);
    void appendRuleAfter(gint rule_n=-1,libfwbuilder::Rule *r=NULL);
    void appendRuleAtBottom(libfwbuilder::Rule *r=NULL);

    void delRule(gint rule_n=-1);

    void moveRuleUp(gint rule_n);
    void moveRuleDown(gint rule_n);

    void disableRule(gint rule_n);
    void enableRule(gint rule_n);
    bool isRuleDisabled(gint rule_n);
    
    SigC::Signal1<void,void*>open_item;

    protected:

    PolicyListElement* createPolicyListElement(int row, int col,
					       const char* element_name,
					       libfwbuilder::Rule *rule);
    
    void getTitles(libfwbuilder::RuleSet &rs, list<const char*>& titles);

};

#endif
