/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: GroupDialog.cc,v 1.53 2001/12/29 10:06:35 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "fwbuilder/Tools.hh"
#include "fwbuilder/FWObject.hh"
#include "fwbuilder/Group.hh"
#include "FWObjectDatabaseGUI.hh"
#include "GroupDialog.hh"
#include "MessageDialog.hh"
#include "helpers.hh"

#include "main_window.hh"

#include "gen_popup_menu.hh"

#include "glademm_support.hh"

#include <gtk--.h>

using namespace libfwbuilder;


GroupDialog::GroupDialog(FWObject *obj)
{
    GroupIconList=NULL;
    object=obj;

    assert( obj!=NULL );

    GroupIconList=manage(new  ListOfIcons(80,50,true));
    assert( GroupIconList!=NULL );

    GroupIconList->set_border(8);
    GroupIconList->set_row_spacing(12);
    GroupIconList->set_col_spacing(8);

    gr_lib="All";

    string ot=Preferences::global_prefs->getOptStr(
	"/FWBuilderPreferences/UI/ObjectTreeMode");

    if (ot=="Split") {

	FWObjectBook *book=(FWObjectBook*)glademm_get_Widget("FWObjectBook");
	assert (book!=NULL);
	gr_lib=main_w->getCurrentLibrary();
    }
/*
 *  disable mouse-activated pop-up menu for system and non-writable groups
 *
    if ( Resources::isSystem(obj) )  GroupIconList->disableMenu();
*/

    sw=manage(new Gtk::ScrolledWindow());
    sw->set_policy(GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    group_internal_hbox->remove( *group_internal_hbox_label );
    group_internal_hbox->pack_start(*sw);
    sw->show();

    sw->add_with_viewport( *GroupIconList);
    GroupIconList->show();

    set_name("group_dialog");

  /*******************************************************************/

    /* Drag destination */
    GroupIconList->drag_dest_set ( GTK_DEST_DEFAULT_ALL,
				   target_table, n_targets,
				   static_cast < GdkDragAction > ( GDK_ACTION_COPY ) );

    GroupIconList->drag_data_received.connect( 
	slot ( this, & ( GroupDialog::obj_drag_data_received ) ) );

  /*******************************************************************/

  /*  When user presses Enter while one of the group items is selected,
   *    IconList sends signal open_item. 
   */

    GroupIconList->open_item.connect(SigC::slot(this,&GroupDialog::on_open_item));
    GroupIconList->popup_menu.connect(SigC::slot(this,&GroupDialog::on_popup_menu));

    group_name->changed.connect(SigC::slot(this,&GroupDialog::on_changed));
}

GroupDialog::~GroupDialog()
{
//    sw->remove();
//    if (GroupIconList!=NULL) delete GroupIconList;
}

void GroupDialog::on_open_item(void *arg)
{
    string   *id = (string*)arg;
    if (id!=NULL)  main_w->schedule_open_object(*id);
}


void GroupDialog::on_popup_menu(void *arg)
{
    Gtk::Widget *itm;

    char **menu_items0;
    gen_popup_menu *gpm;

    menu_items0=new char*[6];
    menu_items0[0]="Open";
    menu_items0[1]="";
    menu_items0[2]="Copy";
    menu_items0[3]="Cut";
    menu_items0[4]="Paste";
    menu_items0[5]=NULL;
    gpm=new gen_popup_menu( (const char**)menu_items0 );

      

//    FWObject *o=(FWObject*)arg;
    string *id=(string*)arg;

    FWObject *scr  = NULL;
    FWObject *org  = NULL;

    if (id==NULL) {
	itm=find_widget("Open",gpm);   if (itm) itm->set_sensitive(false);
	itm=find_widget("Copy",gpm);   if (itm) itm->set_sensitive(false);
	itm=find_widget("Cut",gpm);    if (itm) itm->set_sensitive(false);
	itm=find_widget("Paste",gpm);  if (itm) itm->set_sensitive(true );
    } else {
	scr  = FWObjectDatabaseGUI::ScratchPad->getById(*id,true);
	org  = FWObjectDatabase::db->getById(*id,true);        

	itm=find_widget("Copy",gpm); if(itm)itm->set_sensitive(!Resources::isSystem(org));
	itm=find_widget("Cut",gpm);  if(itm)itm->set_sensitive(!Resources::isSystem(org));
	itm=find_widget("Paste",gpm);if(itm)itm->set_sensitive(!Resources::isSystem(org));
    }

    if ( Resources::isSystem(object) ) {
	itm=find_widget("Paste",gpm);if(itm)itm->set_sensitive(false);
    }

    gpm->popup(0,0);
    gint menu_choice=gpm->run();
    delete gpm;

    delete menu_items0;
    
    switch (menu_choice) {
    case 0:    // open
	main_w->schedule_open_object(*id);
	break;
    case 2:    // copy
	if (org) FWObjectClipboard::obj_clipboard->putObject(org);
	break;
    case 3:    // cut
	if (org) {
	    if ( ! Resources::isSystem(object) ||  main_w->confirm_remove_object(*id) ) {

		FWObjectClipboard::obj_clipboard->putObject(org);
		GroupIconList->removeObject(*id);
		data_changed_flag(true);
	    }
	}
	break;
    case 4:    // paste
    {
	FWObject *obj=FWObjectClipboard::obj_clipboard->getObject();
	if ( obj!=NULL ) 
	    addObject(obj);

	break;
    }
    }
  
}


void GroupDialog::on_viewport1_check_resize() {  }
void GroupDialog::on_viewport1_size_allocate(GtkAllocation *all)  { }

void GroupDialog::wrk2dlg()
{
    bool       show_hidden;
    FWObject  *obj;
    vector<FWObject*>::iterator m;

    assert( object!=NULL );

    show_hidden= (Preferences::global_prefs->getOptBool(
	"/FWBuilderPreferences/UI/ShowHidden"));

    Group     *gr=Group::cast(object);

    if (Resources::isSystem(gr)) {

	if ( gr->getId()== FWObjectDatabase::db->std.rootId ) {
	    string title("");
	    if (gr_lib=="") title=title+"User defined objects";
	    else            title=title+gr_lib;
	    group_name_lbl->set_text(title);
	}
	else {
	    group_name_lbl->set_text( gr->getName() );
	}
	group_name_frm->show();
	if (group_name!=NULL) {
	    group_name->hide();
	    packer129->remove( *group_name );
	    group_name=NULL;
	}
    } else {
	group_name->show();
	group_name->set_text( gr->getName() );
	group_name->set_editable(true);
	if (group_name_frm!=NULL) {
	    group_name_frm->hide();
	    packer129->remove( *group_name_frm );
	    group_name_frm=NULL;
	    group_name_lbl=NULL;
	}
    }

    GroupIconList->clear();

    for (m=gr->begin(); m!=gr->end(); ++m) {
	if ( (obj=(*m))!=NULL ) {
	    if ( FWReference::cast(obj)!=NULL) {
		obj=( FWReference::cast(obj) )->getPointer();
	    }
	    if ( (show_hidden ||
		  ! Resources::global_res->getObjResourceBool(obj,"hidden")) &&

		 ( ! Resources::isSystem(gr) ||
		   gr_lib=="All" || 
		   obj->getLibrary()==gr_lib || 
		   Resources::isSystem(obj) ) ) {

		GroupIconList->addObject(obj);
	    }
	}
    }

    GroupIconList->arrangeIcons();
    GroupIconList->select_icon(0);
}

void GroupDialog::on_changed()
{
    data_changed_flag(true);
}


void GroupDialog::setLibrary(const string &_lib)
{
    gr_lib=_lib;
}

bool GroupDialog::dlg2wrk()
{
    assert( object!=NULL );
    Group     *gr=Group::cast(object);

/*
 *  check if name is valid
 */
    if ( ! Resources::isSystem(gr) ) {
	assert(group_name!=NULL);
	if ( ! checkObjectName(group_name->get_text()) ) return(false);
	object->setName( group_name->get_text() );
    }

    FWObjectBook *book=(FWObjectBook*)glademm_get_Widget("FWObjectBook");
    assert(book);

 loop0:
    for (FWObject::iterator m=gr->begin(); m!=gr->end(); ++m) {
	FWObject *obj;
	if ( (obj=(*m))!=NULL ) {

	    string id1=obj->getId();

	    bool is_ref=(FWReference::cast(obj)!=NULL);
	    if (is_ref) obj=( FWReference::cast(obj) )->getPointer();

	    bool f=false;
	    for (int i=0; i<GroupIconList->getCount(); ++i) {
		string id2=GroupIconList->getObjectId(i);
		if (id1==id2) { f=true; break; }
	    }
	    if (f) continue;

	    if (!is_ref) {  // removing object itself, not a reference

		book->removeObject(obj);
/*
 * dialog works with a copy in ScratchPad, so obj points at the object
 * there
 */
		FWObjectDatabaseGUI::ScratchPad->removeAllInstances(obj);
		obj=FWObjectDatabaseGUI::db->getById( id1 , true);
		FWObjectDatabaseGUI::db->removeAllInstances(obj);
	    } else {

		gr->remove( *m );
	    }
	    goto loop0;
	}
    }



    for (int i=0; i<GroupIconList->getCount(); ++i) {
	string id2=GroupIconList->getObjectId(i);
	FWObject *o=FWObjectDatabaseGUI::ScratchPad->getById(id2,true);

	if (o) {
	    FWObject *obj;
	    bool f=false;
	    for (FWObject::iterator m=gr->begin(); m!=gr->end(); ++m) {
		obj=(*m);
		string id1=obj->getId();
		if (id1==id2) { f=true; break; }
	    }
	    if (f) continue;

	    if ( !Resources::isSystem(gr)  )  gr->addRef( o );
	}
    }

    return true;
}

void GroupDialog::Update()
{
  wrk2dlg();
}

void GroupDialog::addObject(FWObject *obj)
{
    Group     *gr=Group::cast(object);

    if (obj==NULL) return;

/*
 * if this is system group or it is not writable, do not accept object
 */
    if ( Resources::isSystem(gr)  )  return;

/*
 *  check if object is appropriate for this group
 */
    string id=obj->getId();

    if (gr->validateChild( obj ) && ! GroupIconList->checkObjectId(id) ) {

	GroupIconList->addObject( obj );
	GroupIconList->arrangeIcons();
	data_changed_flag(true);
    }
}





void GroupDialog::obj_drag_data_received ( GdkDragContext     *context,
					   gint                x,
					   gint                y,
					   GtkSelectionData   *data,
					   guint               info,
					   guint32             time)
{
    char           obj_id[64];

    assert( object!=NULL );

    Gdk_DragContext gdc ( context );
    if ( ( data -> length >= 0 ) && ( data -> format == 8 ) ) {

	Gtk::Widget::drag_finish ( gdc, true, false, time );
    
	FWObject *obj;

	memcpy(obj_id,(char*)data->data,data->length);
	obj=FWObjectDatabaseGUI::ScratchPad->getById( obj_id , true );

	addObject(obj);
	return;
    }
    Gtk::Widget::drag_finish ( gdc , false, false, time );
}


/*
 * Disable menu items which make sence only for specific objects
 */
void GroupDialog::updateMainMenu()
{
    DialogPlugin::updateMainMenu();

    Gtk::MenuBar *main_menubar=main_w->getMainMenuBar();
    Gtk::Widget *itm;

    itm=find_widget("paste",main_menubar);
    if (itm) itm->set_sensitive( ! Resources::isSystem(object) );

}





