/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FirewallDialog.hh,v 1.30 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef _FIREWALLDIALOG_HH
#  include "FirewallDialog_glade.hh"
#  define _FIREWALLDIALOG_HH
#include "glademm_support.hh"

/*
 *  workaround for the bug in glademm
 */
#define GTK_FILLX GTK_FILL_X
#define GTK_FILLY GTK_FILL_Y

#include "sigc++/slot.h"
#include "fwbuilder/FWObject.hh"
#include "fwbuilder/FWOptions.hh"
#include "fwbuilder/Interface.hh"
#include "InterfaceListWidget.hh"

class IPAddressWidget;
class PolicyList;

class FirewallDialog : public FirewallDialog_glade
{   
        
    friend class FirewallDialog_glade;

    void on_ipfilter_log_level_changed();
    void on_iptables_log_level_changed();
    void on_iptables_limit_suffix_changed();
    void on_iptables_action_on_reject_changed();
    void on_fw_platform_changed();
    void on_host_os_changed();

    void on_changed();

    void on_new_if_clicked();
    void on_del_if_clicked();
    void on_snmp_get_clicked();
    void on_snmp_get_released();
    void on_edit_clicked();
    void on_find_compiler_clicked();
    void on_find_install_script_clicked();
    void on_snmp_get_descr_released();
    void on_dyn_addr_toggled();
    void on_switch_page(Gtk::Notebook_Helpers::Page* p0,guint p1);
    void on_dns_lookup();

    void on_if_list_select_row(gint row, gint column, GdkEvent *event);
    void on_add_rule_clicked();
    void on_del_rule_clicked();

    void on_open_item(void *arg);

    void showInterfaces();
    void showInterfacePolicy(libfwbuilder::Interface *intf);

    void switchToPage(guint page);

    void hideAllFirewallTabs();
    void hideAllOSTabs();
    void showFirewallTab(guint tab_no);
    void showOSTab(guint tab_no);
    void showChosenFirewallTab();
    void showChosenOSTab();

    libfwbuilder::Interface* getSelectedInterface();
    libfwbuilder::Interface* getInterfaceByRow(int row);

    libfwbuilder::FWOptions* options;
    PolicyList*              interface_policy_list;

    map<string,string>  log_levels;
    vector<string>      limit_suffixes;
    vector<string>      actions_on_reject;
    vector<string>      platforms;

    map<string,string>  host_os_menu;
    map<string,string>  on_off_menu;

    IPAddressWidget*   fw_addr;

    vector<class DialogOption> object_parameters;
    vector<class DialogOption> common_options;

    vector<class DialogOption> iptables_options;
    vector<class DialogOption> ipfilter_options;

    vector<class DialogOption> linux24_options;

public:

    FirewallDialog(libfwbuilder::FWObject *obj);
    ~FirewallDialog();

    void if2dlg();

    virtual void wrk2dlg();
    virtual bool dlg2wrk();
    virtual void updateMainMenu();


    PolicyList* getPolicyList() { return interface_policy_list; }

};
#endif
