/* powercontrol.c generated by valac 0.14.2, the Vala compiler
 * generated from powercontrol.vala, do not modify */

/*
 * Copyright (C) 2010-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *                         Simon Busch <morphis@gravedo.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <fsodevice.h>
#include <fsobasics.h>
#include <fsoframework.h>
#include <fsosystem.h>
#include <freesmartphone.h>
#include <gio/gio.h>
#include <fsotransport.h>
#include <sys/ioctl.h>
#include <unistd.h>


#define PALM_PRE_TYPE_WIFI_POWER_CONTROL (palm_pre_wifi_power_control_get_type ())
#define PALM_PRE_WIFI_POWER_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PALM_PRE_TYPE_WIFI_POWER_CONTROL, PalmPreWifiPowerControl))
#define PALM_PRE_WIFI_POWER_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PALM_PRE_TYPE_WIFI_POWER_CONTROL, PalmPreWifiPowerControlClass))
#define PALM_PRE_IS_WIFI_POWER_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PALM_PRE_TYPE_WIFI_POWER_CONTROL))
#define PALM_PRE_IS_WIFI_POWER_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PALM_PRE_TYPE_WIFI_POWER_CONTROL))
#define PALM_PRE_WIFI_POWER_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PALM_PRE_TYPE_WIFI_POWER_CONTROL, PalmPreWifiPowerControlClass))

typedef struct _PalmPreWifiPowerControl PalmPreWifiPowerControl;
typedef struct _PalmPreWifiPowerControlClass PalmPreWifiPowerControlClass;
typedef struct _PalmPreWifiPowerControlPrivate PalmPreWifiPowerControlPrivate;
#define _fso_framework_kernel26_module_unref0(var) ((var == NULL) ? NULL : (var = (fso_framework_kernel26_module_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _fso_framework_network_interface_unref0(var) ((var == NULL) ? NULL : (var = (fso_framework_network_interface_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct __palm_pre_wifi_power_control_setPowerData _palm_pre_wifi_power_control_setPowerData;

#define PALM_PRE_TYPE_HCI_OVER_HSUART_TRANSPORT (palm_pre_hci_over_hsuart_transport_get_type ())
#define PALM_PRE_HCI_OVER_HSUART_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PALM_PRE_TYPE_HCI_OVER_HSUART_TRANSPORT, PalmPreHciOverHsuartTransport))
#define PALM_PRE_HCI_OVER_HSUART_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PALM_PRE_TYPE_HCI_OVER_HSUART_TRANSPORT, PalmPreHciOverHsuartTransportClass))
#define PALM_PRE_IS_HCI_OVER_HSUART_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PALM_PRE_TYPE_HCI_OVER_HSUART_TRANSPORT))
#define PALM_PRE_IS_HCI_OVER_HSUART_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PALM_PRE_TYPE_HCI_OVER_HSUART_TRANSPORT))
#define PALM_PRE_HCI_OVER_HSUART_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PALM_PRE_TYPE_HCI_OVER_HSUART_TRANSPORT, PalmPreHciOverHsuartTransportClass))

typedef struct _PalmPreHciOverHsuartTransport PalmPreHciOverHsuartTransport;
typedef struct _PalmPreHciOverHsuartTransportClass PalmPreHciOverHsuartTransportClass;
typedef struct _PalmPreHciOverHsuartTransportPrivate PalmPreHciOverHsuartTransportPrivate;

#define PALM_PRE_TYPE_BLUETOOTH_POWER_CONTROL (palm_pre_bluetooth_power_control_get_type ())
#define PALM_PRE_BLUETOOTH_POWER_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PALM_PRE_TYPE_BLUETOOTH_POWER_CONTROL, PalmPreBluetoothPowerControl))
#define PALM_PRE_BLUETOOTH_POWER_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PALM_PRE_TYPE_BLUETOOTH_POWER_CONTROL, PalmPreBluetoothPowerControlClass))
#define PALM_PRE_IS_BLUETOOTH_POWER_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PALM_PRE_TYPE_BLUETOOTH_POWER_CONTROL))
#define PALM_PRE_IS_BLUETOOTH_POWER_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PALM_PRE_TYPE_BLUETOOTH_POWER_CONTROL))
#define PALM_PRE_BLUETOOTH_POWER_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PALM_PRE_TYPE_BLUETOOTH_POWER_CONTROL, PalmPreBluetoothPowerControlClass))

typedef struct _PalmPreBluetoothPowerControl PalmPreBluetoothPowerControl;
typedef struct _PalmPreBluetoothPowerControlClass PalmPreBluetoothPowerControlClass;
typedef struct _PalmPreBluetoothPowerControlPrivate PalmPreBluetoothPowerControlPrivate;

#define PALM_PRE_TYPE_POWER_CONTROL (palm_pre_power_control_get_type ())
#define PALM_PRE_POWER_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PALM_PRE_TYPE_POWER_CONTROL, PalmPrePowerControl))
#define PALM_PRE_POWER_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PALM_PRE_TYPE_POWER_CONTROL, PalmPrePowerControlClass))
#define PALM_PRE_IS_POWER_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PALM_PRE_TYPE_POWER_CONTROL))
#define PALM_PRE_IS_POWER_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PALM_PRE_TYPE_POWER_CONTROL))
#define PALM_PRE_POWER_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PALM_PRE_TYPE_POWER_CONTROL, PalmPrePowerControlClass))

typedef struct _PalmPrePowerControl PalmPrePowerControl;
typedef struct _PalmPrePowerControlClass PalmPrePowerControlClass;
typedef struct _PalmPrePowerControlPrivate PalmPrePowerControlPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

struct _PalmPreWifiPowerControl {
	FsoDeviceBasePowerControl parent_instance;
	PalmPreWifiPowerControlPrivate * priv;
};

struct _PalmPreWifiPowerControlClass {
	FsoDeviceBasePowerControlClass parent_class;
};

struct _PalmPreWifiPowerControlPrivate {
	FsoFrameworkKernel26Module* sirloin_wifi_mod;
	FsoFrameworkSubsystem* subsystem;
	gboolean is_active;
};

struct _Block1Data {
	int _ref_count_;
	PalmPreWifiPowerControl * self;
	gpointer _async_data_;
};

struct __palm_pre_wifi_power_control_setPowerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	PalmPreWifiPowerControl* self;
	gboolean power;
	Block1Data* _data1_;
	gboolean ok;
	gboolean _tmp0_;
	gboolean _tmp1_;
	FsoFrameworkLogger* _tmp2_;
	FsoFrameworkLogger* _tmp3_;
	FsoFrameworkKernel26Module* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	FsoFrameworkLogger* _tmp7_;
	FsoFrameworkNetworkInterface* _tmp8_;
	FsoFrameworkNetworkInterface* iface;
	FsoFrameworkNetworkInterface* _tmp9_;
	FsoFrameworkNetworkInterface* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	FsoFrameworkNetworkInterface* _tmp13_;
	GError* e;
	FsoFrameworkLogger* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gboolean _tmp20_;
	FsoFrameworkLogger* _tmp21_;
	FsoFrameworkLogger* _tmp22_;
	FsoFrameworkKernel26Module* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	FsoFrameworkLogger* _tmp26_;
	GError * _inner_error_;
};

struct _PalmPreHciOverHsuartTransport {
	FsoFrameworkHsuartTransport parent_instance;
	PalmPreHciOverHsuartTransportPrivate * priv;
};

struct _PalmPreHciOverHsuartTransportClass {
	FsoFrameworkHsuartTransportClass parent_class;
};

struct _PalmPreBluetoothPowerControl {
	FsoDeviceBasePowerControl parent_instance;
	PalmPreBluetoothPowerControlPrivate * priv;
};

struct _PalmPreBluetoothPowerControlClass {
	FsoDeviceBasePowerControlClass parent_class;
};

struct _PalmPreBluetoothPowerControlPrivate {
	FsoFrameworkSubsystem* subsystem;
	FsoFrameworkBaseTransport* transport;
	gboolean power_status;
};

struct _PalmPrePowerControl {
	FsoFrameworkAbstractObject parent_instance;
	PalmPrePowerControlPrivate * priv;
};

struct _PalmPrePowerControlClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _PalmPrePowerControlPrivate {
	GList* resources;
	GList* instances;
};


static gpointer palm_pre_wifi_power_control_parent_class = NULL;
static GType palm_pre_wifi_power_control_type_id = 0;
static gpointer palm_pre_hci_over_hsuart_transport_parent_class = NULL;
static GType palm_pre_hci_over_hsuart_transport_type_id = 0;
static gpointer palm_pre_bluetooth_power_control_parent_class = NULL;
static GType palm_pre_bluetooth_power_control_type_id = 0;
static gpointer palm_pre_power_control_parent_class = NULL;
static GType palm_pre_power_control_type_id = 0;

#define PALM_PRE_POWERCONTROL_MODULE_NAME "fsodevice.palmpre_quirks/powercontrol"
GType palm_pre_wifi_power_control_get_type (void) G_GNUC_CONST;
GType palm_pre_wifi_power_control_register_type (GTypeModule * module);
#define PALM_PRE_WIFI_POWER_CONTROL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PALM_PRE_TYPE_WIFI_POWER_CONTROL, PalmPreWifiPowerControlPrivate))
enum  {
	PALM_PRE_WIFI_POWER_CONTROL_DUMMY_PROPERTY
};
PalmPreWifiPowerControl* palm_pre_wifi_power_control_new (FsoFrameworkSubsystem* subsystem);
PalmPreWifiPowerControl* palm_pre_wifi_power_control_construct (GType object_type, FsoFrameworkSubsystem* subsystem);
static gboolean palm_pre_wifi_power_control_real_getPower (FsoDeviceBasePowerControl* base);
static void _palm_pre_wifi_power_control_setPower_data_free (gpointer _data);
static void _palm_pre_wifi_power_control_setPower (PalmPreWifiPowerControl* self, gboolean power, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _palm_pre_wifi_power_control_setPower_finish (PalmPreWifiPowerControl* self, GAsyncResult* _res_);
static gboolean _palm_pre_wifi_power_control_setPower_co (_palm_pre_wifi_power_control_setPowerData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean ____lambda5_ (Block1Data* _data1_);
static gboolean _____lambda5__gsource_func (gpointer self);
static void palm_pre_wifi_power_control_real_setPower (FsoDeviceBasePowerControl* base, gboolean power);
static void palm_pre_wifi_power_control_finalize (GObject* obj);
GType palm_pre_hci_over_hsuart_transport_get_type (void) G_GNUC_CONST;
GType palm_pre_hci_over_hsuart_transport_register_type (GTypeModule * module);
enum  {
	PALM_PRE_HCI_OVER_HSUART_TRANSPORT_DUMMY_PROPERTY
};
#define PALM_PRE_HCI_OVER_HSUART_TRANSPORT_N_HCI ((guint) 15)
PalmPreHciOverHsuartTransport* palm_pre_hci_over_hsuart_transport_new (const gchar* portname);
PalmPreHciOverHsuartTransport* palm_pre_hci_over_hsuart_transport_construct (GType object_type, const gchar* portname);
static void palm_pre_hci_over_hsuart_transport_real_configure (FsoFrameworkBaseTransport* base);
GType palm_pre_bluetooth_power_control_get_type (void) G_GNUC_CONST;
GType palm_pre_bluetooth_power_control_register_type (GTypeModule * module);
#define PALM_PRE_BLUETOOTH_POWER_CONTROL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PALM_PRE_TYPE_BLUETOOTH_POWER_CONTROL, PalmPreBluetoothPowerControlPrivate))
enum  {
	PALM_PRE_BLUETOOTH_POWER_CONTROL_DUMMY_PROPERTY
};
#define PALM_PRE_BLUETOOTH_POWER_CONTROL_DEFAULT_DEV_NAME "/dev/btuart"
#define PALM_PRE_BLUETOOTH_POWER_CONTROL_DEFAULT_RESET_NODE "/sys/user_hw/pins/bt/reset/level"
PalmPreBluetoothPowerControl* palm_pre_bluetooth_power_control_new (FsoFrameworkSubsystem* subsystem);
PalmPreBluetoothPowerControl* palm_pre_bluetooth_power_control_construct (GType object_type, FsoFrameworkSubsystem* subsystem);
static gboolean palm_pre_bluetooth_power_control_real_getPower (FsoDeviceBasePowerControl* base);
static void palm_pre_bluetooth_power_control_real_setPower (FsoDeviceBasePowerControl* base, gboolean power);
static void palm_pre_bluetooth_power_control_finalize (GObject* obj);
GType palm_pre_power_control_get_type (void) G_GNUC_CONST;
GType palm_pre_power_control_register_type (GTypeModule * module);
#define PALM_PRE_POWER_CONTROL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PALM_PRE_TYPE_POWER_CONTROL, PalmPrePowerControlPrivate))
enum  {
	PALM_PRE_POWER_CONTROL_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
PalmPrePowerControl* palm_pre_power_control_new (FsoFrameworkSubsystem* subsystem);
PalmPrePowerControl* palm_pre_power_control_construct (GType object_type, FsoFrameworkSubsystem* subsystem);
static gchar* palm_pre_power_control_real_repr (FsoFrameworkAbstractObject* base);
static void palm_pre_power_control_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


PalmPreWifiPowerControl* palm_pre_wifi_power_control_construct (GType object_type, FsoFrameworkSubsystem* subsystem) {
	PalmPreWifiPowerControl * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	FsoFrameworkSubsystem* _tmp1_;
	FsoFrameworkKernel26Module* _tmp7_;
	FsoFrameworkSubsystem* _tmp8_;
	FsoFrameworkLogger* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (subsystem != NULL, NULL);
	self = (PalmPreWifiPowerControl*) fso_device_base_power_control_construct (object_type, "WiFi", "1", "0", (guint) 3);
	_tmp0_ = subsystem;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->subsystem);
	self->priv->subsystem = _tmp1_;
	{
		FsoFrameworkNetworkInterface* _tmp2_;
		FsoFrameworkNetworkInterface* iface;
		FsoFrameworkNetworkInterface* _tmp3_;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		FsoFrameworkNetworkInterface* _tmp6_;
		_tmp2_ = fso_framework_network_interface_new ("eth0", &_inner_error_);
		iface = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp3_ = iface;
		_tmp4_ = fso_framework_network_interface_is_up (_tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			_fso_framework_network_interface_unref0 (iface);
			goto __catch0_g_error;
		}
		self->priv->is_active = _tmp5_;
		_tmp6_ = iface;
		fso_framework_network_interface_finish (_tmp6_);
		_fso_framework_network_interface_unref0 (iface);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		self->priv->is_active = FALSE;
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp7_ = fso_framework_kernel26_module_new ("sirloin_wifi");
	_fso_framework_kernel26_module_unref0 (self->priv->sirloin_wifi_mod);
	self->priv->sirloin_wifi_mod = _tmp7_;
	_tmp8_ = subsystem;
	fso_framework_subsystem_registerObjectForServiceWithPrefix (_tmp8_, FREE_SMARTPHONE_DEVICE_TYPE_POWER_CONTROL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_DEVICE_ServiceDBusName, FSO_FRAMEWORK_DEVICE_PowerControlServicePath, (FreeSmartphoneDevicePowerControl*) self);
	_tmp9_ = ((FsoFrameworkAbstractObject*) self)->logger;
	fso_framework_logger_info (_tmp9_, "Created.");
	return self;
}


PalmPreWifiPowerControl* palm_pre_wifi_power_control_new (FsoFrameworkSubsystem* subsystem) {
	return palm_pre_wifi_power_control_construct (PALM_PRE_TYPE_WIFI_POWER_CONTROL, subsystem);
}


static gboolean palm_pre_wifi_power_control_real_getPower (FsoDeviceBasePowerControl* base) {
	PalmPreWifiPowerControl * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (PalmPreWifiPowerControl*) base;
	_tmp0_ = self->priv->is_active;
	result = _tmp0_;
	return result;
}


static void _palm_pre_wifi_power_control_setPower_data_free (gpointer _data) {
	_palm_pre_wifi_power_control_setPowerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (_palm_pre_wifi_power_control_setPowerData, _data_);
}


static void _palm_pre_wifi_power_control_setPower (PalmPreWifiPowerControl* self, gboolean power, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	_palm_pre_wifi_power_control_setPowerData* _data_;
	PalmPreWifiPowerControl* _tmp0_;
	gboolean _tmp1_;
	_data_ = g_slice_new0 (_palm_pre_wifi_power_control_setPowerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _palm_pre_wifi_power_control_setPower);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _palm_pre_wifi_power_control_setPower_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = power;
	_data_->power = _tmp1_;
	_palm_pre_wifi_power_control_setPower_co (_data_);
}


static void _palm_pre_wifi_power_control_setPower_finish (PalmPreWifiPowerControl* self, GAsyncResult* _res_) {
	_palm_pre_wifi_power_control_setPowerData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean ____lambda5_ (Block1Data* _data1_) {
	PalmPreWifiPowerControl * self;
	gboolean result = FALSE;
	self = _data1_->self;
	_palm_pre_wifi_power_control_setPower_co (_data1_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean _____lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda5_ (self);
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean _palm_pre_wifi_power_control_setPower_co (_palm_pre_wifi_power_control_setPowerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->ok = FALSE;
	_data_->_tmp0_ = _data_->power;
	if (_data_->_tmp0_) {
		_data_->_tmp1_ = _data_->self->priv->is_active;
		if (_data_->_tmp1_) {
			_data_->_tmp2_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
			fso_framework_logger_info (_data_->_tmp2_, "Wifi is already powered; not powering it again.");
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp3_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		fso_framework_logger_info (_data_->_tmp3_, "Powering on WiFi ...");
		_data_->_tmp4_ = _data_->self->priv->sirloin_wifi_mod;
		_data_->_tmp5_ = FALSE;
		_data_->_tmp5_ = fso_framework_kernel26_module_load (_data_->_tmp4_);
		_data_->ok = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->ok;
		if (!_data_->_tmp6_) {
			_data_->_tmp7_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
			fso_framework_logger_error (_data_->_tmp7_, "Loading WiFi kernel module failed!!!");
		} else {
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 900, _____lambda5__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
			_data_->_state_ = 1;
			return FALSE;
			_state_1:
			;
			{
				_data_->_tmp8_ = fso_framework_network_interface_new ("eth0", &_data_->_inner_error_);
				_data_->iface = _data_->_tmp8_;
				if (_data_->_inner_error_ != NULL) {
					goto __catch1_g_error;
				}
				_data_->_tmp9_ = _data_->iface;
				fso_framework_network_interface_up (_data_->_tmp9_, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					_fso_framework_network_interface_unref0 (_data_->iface);
					goto __catch1_g_error;
				}
				_data_->_tmp10_ = _data_->iface;
				_data_->_tmp11_ = FALSE;
				_data_->_tmp11_ = fso_framework_network_interface_is_up (_data_->_tmp10_, &_data_->_inner_error_);
				_data_->_tmp12_ = _data_->_tmp11_;
				if (_data_->_inner_error_ != NULL) {
					_fso_framework_network_interface_unref0 (_data_->iface);
					goto __catch1_g_error;
				}
				_data_->self->priv->is_active = _data_->_tmp12_;
				_data_->_tmp13_ = _data_->iface;
				fso_framework_network_interface_finish (_data_->_tmp13_);
				_fso_framework_network_interface_unref0 (_data_->iface);
			}
			goto __finally1;
			__catch1_g_error:
			{
				_data_->e = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp14_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
				_data_->_tmp15_ = _data_->e;
				_data_->_tmp16_ = _data_->_tmp15_->message;
				_data_->_tmp17_ = NULL;
				_data_->_tmp17_ = string_to_string (_data_->_tmp16_);
				_data_->_tmp18_ = NULL;
				_data_->_tmp18_ = g_strconcat ("Failued to bring interface eth0 up: ", _data_->_tmp17_, NULL);
				_data_->_tmp19_ = _data_->_tmp18_;
				fso_framework_logger_error (_data_->_tmp14_, _data_->_tmp19_);
				_g_free0 (_data_->_tmp19_);
				_g_error_free0 (_data_->e);
			}
			__finally1:
			if (_data_->_inner_error_ != NULL) {
				block1_data_unref (_data_->_data1_);
				_data_->_data1_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	} else {
		_data_->_tmp20_ = _data_->self->priv->is_active;
		if (!_data_->_tmp20_) {
			_data_->_tmp21_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
			fso_framework_logger_info (_data_->_tmp21_, "WiFi is not powered; not powering it off.");
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp22_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		fso_framework_logger_info (_data_->_tmp22_, "Powering off Wifi ...");
		_data_->_tmp23_ = _data_->self->priv->sirloin_wifi_mod;
		_data_->_tmp24_ = FALSE;
		_data_->_tmp24_ = fso_framework_kernel26_module_unload (_data_->_tmp23_);
		_data_->ok = _data_->_tmp24_;
		_data_->_tmp25_ = _data_->ok;
		if (!_data_->_tmp25_) {
			_data_->_tmp26_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
			fso_framework_logger_error (_data_->_tmp26_, "Unloading WiFi kernel module failed!!!");
		} else {
			_data_->self->priv->is_active = FALSE;
		}
	}
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void palm_pre_wifi_power_control_real_setPower (FsoDeviceBasePowerControl* base, gboolean power) {
	PalmPreWifiPowerControl * self;
	gboolean _tmp0_;
	self = (PalmPreWifiPowerControl*) base;
	_tmp0_ = power;
	_palm_pre_wifi_power_control_setPower (self, _tmp0_, NULL, NULL);
}


static void palm_pre_wifi_power_control_class_init (PalmPreWifiPowerControlClass * klass) {
	palm_pre_wifi_power_control_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PalmPreWifiPowerControlPrivate));
	FSO_DEVICE_BASE_POWER_CONTROL_CLASS (klass)->getPower = palm_pre_wifi_power_control_real_getPower;
	FSO_DEVICE_BASE_POWER_CONTROL_CLASS (klass)->setPower = palm_pre_wifi_power_control_real_setPower;
	G_OBJECT_CLASS (klass)->finalize = palm_pre_wifi_power_control_finalize;
}


static void palm_pre_wifi_power_control_instance_init (PalmPreWifiPowerControl * self) {
	self->priv = PALM_PRE_WIFI_POWER_CONTROL_GET_PRIVATE (self);
}


static void palm_pre_wifi_power_control_finalize (GObject* obj) {
	PalmPreWifiPowerControl * self;
	self = PALM_PRE_WIFI_POWER_CONTROL (obj);
	_fso_framework_kernel26_module_unref0 (self->priv->sirloin_wifi_mod);
	_g_object_unref0 (self->priv->subsystem);
	G_OBJECT_CLASS (palm_pre_wifi_power_control_parent_class)->finalize (obj);
}


/**
     * @class WifiPowerControl
     **/
GType palm_pre_wifi_power_control_get_type (void) {
	return palm_pre_wifi_power_control_type_id;
}


GType palm_pre_wifi_power_control_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (PalmPreWifiPowerControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) palm_pre_wifi_power_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PalmPreWifiPowerControl), 0, (GInstanceInitFunc) palm_pre_wifi_power_control_instance_init, NULL };
	palm_pre_wifi_power_control_type_id = g_type_module_register_type (module, FSO_DEVICE_TYPE_BASE_POWER_CONTROL, "PalmPreWifiPowerControl", &g_define_type_info, 0);
	return palm_pre_wifi_power_control_type_id;
}


PalmPreHciOverHsuartTransport* palm_pre_hci_over_hsuart_transport_construct (GType object_type, const gchar* portname) {
	PalmPreHciOverHsuartTransport * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (portname != NULL, NULL);
	_tmp0_ = portname;
	self = (PalmPreHciOverHsuartTransport*) fso_framework_hsuart_transport_construct (object_type, _tmp0_);
	return self;
}


PalmPreHciOverHsuartTransport* palm_pre_hci_over_hsuart_transport_new (const gchar* portname) {
	return palm_pre_hci_over_hsuart_transport_construct (PALM_PRE_TYPE_HCI_OVER_HSUART_TRANSPORT, portname);
}


static void palm_pre_hci_over_hsuart_transport_real_configure (FsoFrameworkBaseTransport* base) {
	PalmPreHciOverHsuartTransport * self;
	guint flags;
	gint _tmp0_;
	self = (PalmPreHciOverHsuartTransport*) base;
	FSO_FRAMEWORK_BASE_TRANSPORT_CLASS (palm_pre_hci_over_hsuart_transport_parent_class)->configure ((FsoFrameworkBaseTransport*) FSO_FRAMEWORK_HSUART_TRANSPORT (self));
	flags = (guint) 0;
	_tmp0_ = ((FsoFrameworkBaseTransport*) self)->fd;
	ioctl (_tmp0_, TIOCSETD, PALM_PRE_HCI_OVER_HSUART_TRANSPORT_N_HCI);
}


static void palm_pre_hci_over_hsuart_transport_class_init (PalmPreHciOverHsuartTransportClass * klass) {
	palm_pre_hci_over_hsuart_transport_parent_class = g_type_class_peek_parent (klass);
	FSO_FRAMEWORK_BASE_TRANSPORT_CLASS (klass)->configure = palm_pre_hci_over_hsuart_transport_real_configure;
}


static void palm_pre_hci_over_hsuart_transport_instance_init (PalmPreHciOverHsuartTransport * self) {
}


GType palm_pre_hci_over_hsuart_transport_get_type (void) {
	return palm_pre_hci_over_hsuart_transport_type_id;
}


GType palm_pre_hci_over_hsuart_transport_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (PalmPreHciOverHsuartTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) palm_pre_hci_over_hsuart_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PalmPreHciOverHsuartTransport), 0, (GInstanceInitFunc) palm_pre_hci_over_hsuart_transport_instance_init, NULL };
	palm_pre_hci_over_hsuart_transport_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_HSUART_TRANSPORT, "PalmPreHciOverHsuartTransport", &g_define_type_info, 0);
	return palm_pre_hci_over_hsuart_transport_type_id;
}


PalmPreBluetoothPowerControl* palm_pre_bluetooth_power_control_construct (GType object_type, FsoFrameworkSubsystem* subsystem) {
	PalmPreBluetoothPowerControl * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	FsoFrameworkSubsystem* _tmp1_;
	FsoFrameworkSubsystem* _tmp2_;
	FsoFrameworkLogger* _tmp3_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	self = (PalmPreBluetoothPowerControl*) fso_device_base_power_control_construct (object_type, "Bluetooth", "1", "0", (guint) 3);
	_tmp0_ = subsystem;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->subsystem);
	self->priv->subsystem = _tmp1_;
	self->priv->power_status = FALSE;
	_tmp2_ = subsystem;
	fso_framework_subsystem_registerObjectForServiceWithPrefix (_tmp2_, FREE_SMARTPHONE_DEVICE_TYPE_POWER_CONTROL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_DEVICE_ServiceDBusName, FSO_FRAMEWORK_DEVICE_PowerControlServicePath, (FreeSmartphoneDevicePowerControl*) self);
	_tmp3_ = ((FsoFrameworkAbstractObject*) self)->logger;
	fso_framework_logger_info (_tmp3_, "Created.");
	return self;
}


PalmPreBluetoothPowerControl* palm_pre_bluetooth_power_control_new (FsoFrameworkSubsystem* subsystem) {
	return palm_pre_bluetooth_power_control_construct (PALM_PRE_TYPE_BLUETOOTH_POWER_CONTROL, subsystem);
}


static gboolean palm_pre_bluetooth_power_control_real_getPower (FsoDeviceBasePowerControl* base) {
	PalmPreBluetoothPowerControl * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (PalmPreBluetoothPowerControl*) base;
	_tmp0_ = self->priv->power_status;
	result = _tmp0_;
	return result;
}


static void palm_pre_bluetooth_power_control_real_setPower (FsoDeviceBasePowerControl* base, gboolean power) {
	PalmPreBluetoothPowerControl * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_;
	gboolean _tmp19_;
	self = (PalmPreBluetoothPowerControl*) base;
	_tmp1_ = self->priv->power_status;
	if (!_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = power;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		FsoFrameworkLogger* _tmp4_;
		gboolean _tmp5_ = FALSE;
		FsoFrameworkLogger* _tmp6_;
		gboolean _tmp7_ = FALSE;
		PalmPreHciOverHsuartTransport* _tmp8_;
		FsoFrameworkBaseTransport* _tmp9_;
		FsoFrameworkLogger* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp4_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp5_ = fso_framework_logger_debug (_tmp4_, "Reseting bluetooth chip ...");
		g_assert (_tmp5_);
		fso_framework_file_handling_write ("0", PALM_PRE_BLUETOOTH_POWER_CONTROL_DEFAULT_RESET_NODE, FALSE);
		sleep ((guint) 2);
		fso_framework_file_handling_write ("1", PALM_PRE_BLUETOOTH_POWER_CONTROL_DEFAULT_RESET_NODE, FALSE);
		_tmp6_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp7_ = fso_framework_logger_debug (_tmp6_, "Opening HCI over HSUart transport ... ");
		g_assert (_tmp7_);
		_tmp8_ = palm_pre_hci_over_hsuart_transport_new (PALM_PRE_BLUETOOTH_POWER_CONTROL_DEFAULT_DEV_NAME);
		_g_object_unref0 (self->priv->transport);
		self->priv->transport = (FsoFrameworkBaseTransport*) _tmp8_;
		_tmp9_ = self->priv->transport;
		fso_framework_transport_open ((FsoFrameworkTransport*) _tmp9_);
		_tmp10_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp11_ = fso_framework_logger_debug (_tmp10_, "Successfully powerd on!");
		g_assert (_tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		gboolean _tmp15_;
		_tmp13_ = self->priv->power_status;
		if (_tmp13_) {
			gboolean _tmp14_;
			_tmp14_ = power;
			_tmp12_ = !_tmp14_;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp15_ = _tmp12_;
		if (_tmp15_) {
			FsoFrameworkLogger* _tmp16_;
			gboolean _tmp17_ = FALSE;
			FsoFrameworkBaseTransport* _tmp18_;
			_tmp16_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp17_ = fso_framework_logger_debug (_tmp16_, "Closing HCI over HSUart transport ... ");
			g_assert (_tmp17_);
			_tmp18_ = self->priv->transport;
			fso_framework_transport_close ((FsoFrameworkTransport*) _tmp18_);
		}
	}
	_tmp19_ = power;
	self->priv->power_status = _tmp19_;
}


static void palm_pre_bluetooth_power_control_class_init (PalmPreBluetoothPowerControlClass * klass) {
	palm_pre_bluetooth_power_control_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PalmPreBluetoothPowerControlPrivate));
	FSO_DEVICE_BASE_POWER_CONTROL_CLASS (klass)->getPower = palm_pre_bluetooth_power_control_real_getPower;
	FSO_DEVICE_BASE_POWER_CONTROL_CLASS (klass)->setPower = palm_pre_bluetooth_power_control_real_setPower;
	G_OBJECT_CLASS (klass)->finalize = palm_pre_bluetooth_power_control_finalize;
}


static void palm_pre_bluetooth_power_control_instance_init (PalmPreBluetoothPowerControl * self) {
	self->priv = PALM_PRE_BLUETOOTH_POWER_CONTROL_GET_PRIVATE (self);
}


static void palm_pre_bluetooth_power_control_finalize (GObject* obj) {
	PalmPreBluetoothPowerControl * self;
	self = PALM_PRE_BLUETOOTH_POWER_CONTROL (obj);
	_g_object_unref0 (self->priv->subsystem);
	_g_object_unref0 (self->priv->transport);
	G_OBJECT_CLASS (palm_pre_bluetooth_power_control_parent_class)->finalize (obj);
}


GType palm_pre_bluetooth_power_control_get_type (void) {
	return palm_pre_bluetooth_power_control_type_id;
}


GType palm_pre_bluetooth_power_control_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (PalmPreBluetoothPowerControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) palm_pre_bluetooth_power_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PalmPreBluetoothPowerControl), 0, (GInstanceInitFunc) palm_pre_bluetooth_power_control_instance_init, NULL };
	palm_pre_bluetooth_power_control_type_id = g_type_module_register_type (module, FSO_DEVICE_TYPE_BASE_POWER_CONTROL, "PalmPreBluetoothPowerControl", &g_define_type_info, 0);
	return palm_pre_bluetooth_power_control_type_id;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


PalmPrePowerControl* palm_pre_power_control_construct (GType object_type, FsoFrameworkSubsystem* subsystem) {
	PalmPrePowerControl * self = NULL;
	FsoFrameworkSmartKeyFile* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	FsoFrameworkSmartKeyFile* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	self = (PalmPrePowerControl*) fso_framework_abstract_object_construct (object_type);
	__g_list_free__g_object_unref0_0 (self->priv->instances);
	self->priv->instances = NULL;
	__g_list_free__g_object_unref0_0 (self->priv->resources);
	self->priv->resources = NULL;
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->config;
	_tmp1_ = string_to_string (PALM_PRE_POWERCONTROL_MODULE_NAME);
	_tmp2_ = g_strconcat (_tmp1_, "/wifi", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = fso_framework_smart_key_file_hasSection (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	if (_tmp5_) {
		FsoFrameworkSubsystem* _tmp6_;
		PalmPreWifiPowerControl* _tmp7_;
		PalmPreWifiPowerControl* wifi;
		PalmPreWifiPowerControl* _tmp8_;
		FsoDeviceBasePowerControl* _tmp9_;
		_tmp6_ = subsystem;
		_tmp7_ = palm_pre_wifi_power_control_new (_tmp6_);
		wifi = _tmp7_;
		_tmp8_ = wifi;
		_tmp9_ = _g_object_ref0 ((FsoDeviceBasePowerControl*) _tmp8_);
		self->priv->instances = g_list_append (self->priv->instances, _tmp9_);
		_g_object_unref0 (wifi);
	}
	_tmp10_ = ((FsoFrameworkAbstractObject*) self)->config;
	_tmp11_ = string_to_string (PALM_PRE_POWERCONTROL_MODULE_NAME);
	_tmp12_ = g_strconcat (_tmp11_, "/bluetooth", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = fso_framework_smart_key_file_hasSection (_tmp10_, _tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	if (_tmp15_) {
		FsoFrameworkSubsystem* _tmp16_;
		PalmPreBluetoothPowerControl* _tmp17_;
		PalmPreBluetoothPowerControl* bt;
		PalmPreBluetoothPowerControl* _tmp18_;
		FsoDeviceBasePowerControl* _tmp19_;
		_tmp16_ = subsystem;
		_tmp17_ = palm_pre_bluetooth_power_control_new (_tmp16_);
		bt = _tmp17_;
		_tmp18_ = bt;
		_tmp19_ = _g_object_ref0 ((FsoDeviceBasePowerControl*) _tmp18_);
		self->priv->instances = g_list_append (self->priv->instances, _tmp19_);
		_g_object_unref0 (bt);
	}
	return self;
}


PalmPrePowerControl* palm_pre_power_control_new (FsoFrameworkSubsystem* subsystem) {
	return palm_pre_power_control_construct (PALM_PRE_TYPE_POWER_CONTROL, subsystem);
}


static gchar* palm_pre_power_control_real_repr (FsoFrameworkAbstractObject* base) {
	PalmPrePowerControl * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (PalmPrePowerControl*) base;
	_tmp0_ = g_strdup ("<PalmPre.PowerControl @ >");
	result = _tmp0_;
	return result;
}


static void palm_pre_power_control_class_init (PalmPrePowerControlClass * klass) {
	palm_pre_power_control_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PalmPrePowerControlPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = palm_pre_power_control_real_repr;
	G_OBJECT_CLASS (klass)->finalize = palm_pre_power_control_finalize;
}


static void palm_pre_power_control_instance_init (PalmPrePowerControl * self) {
	self->priv = PALM_PRE_POWER_CONTROL_GET_PRIVATE (self);
}


static void palm_pre_power_control_finalize (GObject* obj) {
	PalmPrePowerControl * self;
	self = PALM_PRE_POWER_CONTROL (obj);
	__g_list_free__g_object_unref0_0 (self->priv->resources);
	__g_list_free__g_object_unref0_0 (self->priv->instances);
	G_OBJECT_CLASS (palm_pre_power_control_parent_class)->finalize (obj);
}


/**
     * @class PowerControl
     **/
GType palm_pre_power_control_get_type (void) {
	return palm_pre_power_control_type_id;
}


GType palm_pre_power_control_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (PalmPrePowerControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) palm_pre_power_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PalmPrePowerControl), 0, (GInstanceInitFunc) palm_pre_power_control_instance_init, NULL };
	palm_pre_power_control_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "PalmPrePowerControl", &g_define_type_info, 0);
	return palm_pre_power_control_type_id;
}



