;;; -*- Mode: fdscript -*-

(load-once (get-component "test-util.scm"))
(start-test "stringio.scm")

;;; Testing string I/O

(testing 'string-output '(write-to-string 33) "33")
(testing 'string-output '(write-to-string 1/2) "1/2")
(testing 'string-output '(write-to-string 3+5i) "3+5i")
(testing 'string-output '(write-to-string 'foo) "FOO")
(testing 'string-output '(write-to-string '(foo bar)) "(FOO BAR)")
(testing 'string-output '(write-to-string '#(foo bar)) "#(FOO BAR)")
(testing 'string-output '(write-to-string '#[a 3 b 12 c 9]) "#[A 3 B 12 C 9]")

(testing 'string-input '(read-from-string "33") 33)
(testing 'string-input '(read-from-string "1/2") 1/2)
(testing 'string-input '(read-from-string "3+5i") 3+5i)
(testing 'string-input '(read-from-string "FOO") 'foo)
(testing 'string-input '(read-from-string "(FOO BAR)") '(foo bar))
(testing 'string-input '(read-from-string "#(FOO BAR)") '#(foo bar))
(testing 'string-input '(read-from-string "#[A 3 B 12 C 9]") '#[a 3 b 12 c 9])
(define (alternate-write-to-string-1 x)
  (with-string-output (display x)))

(testing 'with-string-output '(alternate-write-to-string-1 33) "33")
(testing 'with-string-output '(alternate-write-to-string-1 1/2) "1/2")
(testing 'with-string-output '(alternate-write-to-string-1 3+5i) "3+5i")
(testing 'with-string-output '(alternate-write-to-string-1 'foo) "FOO")
(testing 'with-string-output '(alternate-write-to-string-1 '(foo bar))
	 "(FOO BAR)")
(testing 'with-string-output '(alternate-write-to-string-1 '#(foo bar))
	 "#(FOO BAR)")
(testing 'with-string-output '(alternate-write-to-string-1 '#[a 3 b 12 c 9])
	 "#[A 3 B 12 C 9]")

(define (alternate-write-to-string-2 x)
  (let ((port (open-output-string)))
    (display x port)
    (string-stream-contents port)))

(testing 'open-output-string '(alternate-write-to-string-2 33) "33")
(testing 'open-output-string '(alternate-write-to-string-2 1/2) "1/2")
(testing 'open-output-string '(alternate-write-to-string-2 3+5i) "3+5i")
(testing 'open-output-string '(alternate-write-to-string-2 'foo) "FOO")
(testing 'open-output-string '(alternate-write-to-string-2 '(foo bar))
	 "(FOO BAR)")
(testing 'open-output-string '(alternate-write-to-string-2 '#(foo bar))
	 "#(FOO BAR)")
(testing 'open-output-string '(alternate-write-to-string-2 '#[a 3 b 12 c 9])
	 "#[A 3 B 12 C 9]")

(define (alternate-read-from-string-1 s)
  (with-string-input s (read)))

(testing 'with-string-input '(alternate-read-from-string-1 "33") 33)
(testing 'with-string-input '(alternate-read-from-string-1 "1/2") 1/2)
(testing 'with-string-input '(alternate-read-from-string-1 "3+5i") 3+5i)
(testing 'with-string-input '(alternate-read-from-string-1 "FOO") 'foo)
(testing 'with-string-input '(alternate-read-from-string-1 "(FOO BAR)")
	 '(foo bar))
(testing 'with-string-input '(alternate-read-from-string-1 "#(FOO BAR)")
	 '#(foo bar))
(testing 'with-string-input '(alternate-read-from-string-1 "#[A 3 B 12 C 9]")
	 '#[a 3 b 12 c 9])

(define (alternate-read-from-string-2 s)
  (let ((port (open-input-string s)))
    (read port)))

(testing 'open-input-string '(alternate-read-from-string-2 "33") 33)
(testing 'open-input-string '(alternate-read-from-string-2 "1/2") 1/2)
(testing 'open-input-string '(alternate-read-from-string-2 "3+5i") 3+5i)
(testing 'open-input-string '(alternate-read-from-string-2 "FOO") 'foo)
(testing 'open-input-string '(alternate-read-from-string-2 "(FOO BAR)")
	 '(foo bar))
(testing 'open-input-string '(alternate-read-from-string-2 "#(FOO BAR)")
	 '#(foo bar))
(testing 'open-input-string '(alternate-read-from-string-2 "#[A 3 B 12 C 9]")
	 '#[a 3 b 12 c 9])

(clear-env-changes!)
(report-problems)
